/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.kaplanmeier.figure;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.biojava.nbio.survival.cox.CoxCoefficient;
import org.biojava.nbio.survival.cox.CoxInfo;
import org.biojava.nbio.survival.cox.StrataInfo;
import org.biojava.nbio.survival.cox.SurvFitInfo;
import org.biojava.nbio.survival.cox.SurvivalInfo;
import org.biojava.nbio.survival.kaplanmeier.figure.CensorStatus;
import org.biojava.nbio.survival.kaplanmeier.figure.KMFigureInfo;
import org.biojava.nbio.survival.kaplanmeier.figure.NumbersAtRiskPanel;
import org.biojava.nbio.survival.kaplanmeier.figure.SurvFitKM;

public class KaplanMeierFigure
extends JPanel {
    private static final long serialVersionUID = 1L;
    ArrayList<String> title = new ArrayList();
    private int top;
    private int bottom;
    private int left;
    private int yaxisLabel = 20;
    private int right;
    int titleHeight;
    int xAxisLabelHeight;
    int labelWidth;
    double minTime = 0.0;
    double maxTime = 10.0;
    double minPercentage = 0.0;
    double maxPercentage = 1.0;
    FontMetrics fm;
    KMFigureInfo kmfi = new KMFigureInfo();
    LinkedHashMap<String, ArrayList<CensorStatus>> survivalData = new LinkedHashMap();
    ArrayList<String> lineInfoList = new ArrayList();
    SurvFitInfo sfi = new SurvFitInfo();
    private String fileName = "";
    private ArrayList<Double> xAxisTimeValues = new ArrayList();
    private ArrayList<Integer> xAxisTimeCoordinates = new ArrayList();
    DecimalFormat df = new DecimalFormat("#.#");
    Double adjustedPercentIncrement = 0.0;

    public KaplanMeierFigure() {
        this.setSize(500, 400);
        this.setBackground(Color.WHITE);
    }

    public ArrayList<String> getGroups() {
        return new ArrayList<String>(this.survivalData.keySet());
    }

    public Double getSurvivalTimePercentile(String group, double percentile) {
        StrataInfo si = this.sfi.getStrataInfoHashMap().get(group);
        ArrayList<Double> percentage = si.getSurv();
        Integer percentileIndex = null;
        for (int i = 0; i < percentage.size(); ++i) {
            if (percentage.get(i) == percentile) {
                if (i + 1 >= percentage.size()) break;
                percentileIndex = i + 1;
                break;
            }
            if (!(percentage.get(i) < percentile)) continue;
            percentileIndex = i;
            break;
        }
        if (percentileIndex != null) {
            return si.getTime().get(percentileIndex);
        }
        return null;
    }

    public void setKMFigureInfo(KMFigureInfo kmfi) {
        this.kmfi = kmfi;
        if (kmfi.width != null && kmfi.height != null) {
            this.setSize(kmfi.width, kmfi.height);
        }
    }

    public KMFigureInfo getKMFigureInfo() {
        return this.kmfi;
    }

    public void setFigureLineInfo(ArrayList<String> lineInfoList) {
        this.lineInfoList = lineInfoList;
        this.repaint();
    }

    public void setCoxInfo(ArrayList<String> title, CoxInfo ci, String strataVariable, LinkedHashMap<String, String> legendMap, Boolean useWeighted) throws Exception {
        LinkedHashMap<String, ArrayList<CensorStatus>> survivalData = new LinkedHashMap<String, ArrayList<CensorStatus>>();
        ArrayList<SurvivalInfo> siList = ci.getSurvivalInfoList();
        int n = 0;
        int event = 0;
        for (SurvivalInfo si : siList) {
            ArrayList<CensorStatus> censorStatusList;
            String strata = si.getOriginalMetaData(strataVariable);
            String legend = legendMap.get(strata);
            if (legend == null) {
                legend = strata;
            }
            if ((censorStatusList = survivalData.get(legend)) == null) {
                censorStatusList = new ArrayList();
                survivalData.put(legend, censorStatusList);
            }
            CensorStatus cs = new CensorStatus(strata, si.getTime(), si.getStatus() + "");
            cs.weight = si.getWeight();
            censorStatusList.add(cs);
            ++n;
            if (si.getStatus() != 1) continue;
            ++event;
        }
        this.setSurvivalData(title, survivalData, useWeighted);
        CoxCoefficient cc = ci.getCoefficient(strataVariable);
        String line1 = "HR=" + KaplanMeierFigure.fmt(cc.getHazardRatio(), 2, 0) + " (CI:" + KaplanMeierFigure.fmt(cc.getHazardRatioLoCI(), 2, 0) + "-" + KaplanMeierFigure.fmt(cc.getHazardRatioHiCI(), 2, 0) + ")";
        String line2 = "p=" + KaplanMeierFigure.fmt(cc.getPvalue(), 3, 0);
        String line3 = "n=" + n + " events=" + event;
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(line1);
        lines.add(line2);
        lines.add(line3);
        this.setFigureLineInfo(lines);
    }

    public static String fmt(Double d, int precision, int pad) {
        String value = "";
        DecimalFormat dfe = new DecimalFormat("0.00E0");
        String dpad = "0.";
        double p = 1.0;
        for (int i = 0; i < precision; ++i) {
            dpad = dpad + "0";
            p /= 10.0;
        }
        DecimalFormat df = new DecimalFormat(dpad);
        value = Math.abs(d) >= p ? df.format(d) : dfe.format(d);
        int length = value.length();
        int extra = pad - length;
        if (extra > 0) {
            for (int i = 0; i < extra; ++i) {
                value = " " + value;
            }
        }
        return value;
    }

    public SurvFitInfo getSurvivalFitInfo() {
        return this.sfi;
    }

    public void setSurvivalData(ArrayList<String> title, SurvFitInfo sfi, Double userSetMaxTime) {
        this.title = title;
        LinkedHashMap<String, StrataInfo> strataInfoHashMap = sfi.getStrataInfoHashMap();
        Double mTime = null;
        for (StrataInfo si : strataInfoHashMap.values()) {
            for (double t : si.getTime()) {
                if (mTime != null && !(t > mTime)) continue;
                mTime = t;
            }
        }
        int evenCheck = Math.round(mTime.floatValue());
        if (evenCheck % 2 == 1) {
            ++evenCheck;
        }
        this.maxTime = evenCheck;
        if (userSetMaxTime != null && userSetMaxTime > this.maxTime) {
            this.maxTime = userSetMaxTime;
        }
        this.sfi = sfi;
        if (sfi.getStrataInfoHashMap().size() == 1) {
            return;
        }
        this.repaint();
    }

    public void setSurvivalData(ArrayList<String> title, LinkedHashMap<String, ArrayList<CensorStatus>> survivalData, Boolean useWeighted) throws Exception {
        this.setSurvivalData(title, survivalData, null, useWeighted);
    }

    public void setSurvivalData(ArrayList<String> title, LinkedHashMap<String, ArrayList<CensorStatus>> survivalData, Double userSetMaxTime, Boolean useWeighted) throws Exception {
        this.title = title;
        this.survivalData = survivalData;
        Double mTime = null;
        ArrayList<String> labels = new ArrayList<String>(survivalData.keySet());
        Collections.sort(labels);
        for (String legend : labels) {
            ArrayList<CensorStatus> censorStatusList = survivalData.get(legend);
            for (CensorStatus cs : censorStatusList) {
                if (mTime != null && !(cs.time > mTime)) continue;
                mTime = cs.time;
            }
        }
        int evenCheck = Math.round(mTime.floatValue());
        if (evenCheck % 2 == 1) {
            ++evenCheck;
        }
        this.maxTime = evenCheck;
        if (userSetMaxTime != null && userSetMaxTime > this.maxTime) {
            this.maxTime = userSetMaxTime;
        }
        SurvFitKM survFitKM = new SurvFitKM();
        this.sfi = survFitKM.process(survivalData, useWeighted);
        this.repaint();
    }

    public void saveSurvivalData(String fileName) throws Exception {
        FileWriter fw = new FileWriter(fileName);
        fw.write("index\tTIME\tSTATUS\tGROUP\r\n");
        int index = 0;
        for (String group : this.survivalData.keySet()) {
            ArrayList<CensorStatus> sd = this.survivalData.get(group);
            for (CensorStatus cs : sd) {
                String line = index + "\t" + cs.time + "\t" + cs.censored + "\t" + cs.group + "\r\n";
                ++index;
                fw.write(line);
            }
        }
        fw.close();
    }

    @Override
    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        this.setFigureDimensions();
        g.setColor(Color.white);
        g.clearRect(0, 0, width, height);
        super.paintComponent(g);
        this.drawLegend(g);
        this.drawSurvivalCurves(g);
        this.drawFigureLineInfo(g);
    }

    private void drawFigureLineInfo(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        this.setRenderingHints(g2);
        g2.setColor(Color.BLACK);
        this.fm = this.getFontMetrics(this.getFont());
        int yoffset = this.fm.getHeight() * this.lineInfoList.size();
        int x = this.getTimeX(this.kmfi.figureLineInfoLowerPercentX * this.maxTime);
        int y = this.getPercentageY(this.kmfi.figureLineInfoLowerPercentY) - yoffset;
        for (String line : this.lineInfoList) {
            g2.drawString(line, x, y);
            y += this.fm.getHeight();
        }
    }

    private void drawSurvivalCurves(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        this.setRenderingHints(g2);
        g2.setStroke(this.kmfi.kmStroke);
        int colorIndex = 0;
        ArrayList<String> labels = new ArrayList<String>(this.sfi.getStrataInfoHashMap().keySet());
        Collections.sort(labels);
        LinkedHashMap<String, StrataInfo> strataInfoHashMap = this.sfi.getStrataInfoHashMap();
        for (String string : labels) {
            StrataInfo si = strataInfoHashMap.get(string);
            g2.setColor(this.kmfi.legendColor[colorIndex]);
            ++colorIndex;
            for (int i = 0; i < si.getSurv().size() - 1; ++i) {
                double p0time = si.getTime().get(i);
                double p1time = si.getTime().get(i + 1);
                double p0percentage = si.getSurv().get(i);
                double p1percentage = si.getSurv().get(i + 1);
                if (i == 0) {
                    g2.drawLine(this.getTimeX(0.0), this.getPercentageY(1.0), this.getTimeX(p0time), this.getPercentageY(1.0));
                    g2.drawLine(this.getTimeX(p0time), this.getPercentageY(1.0), this.getTimeX(p0time), this.getPercentageY(p0percentage));
                }
                g2.drawLine(this.getTimeX(p0time), this.getPercentageY(p0percentage), this.getTimeX(p1time), this.getPercentageY(p0percentage));
                g2.drawLine(this.getTimeX(p1time), this.getPercentageY(p0percentage), this.getTimeX(p1time), this.getPercentageY(p1percentage));
                if (i <= 0 || !(si.getNcens().get(i) > 0.0)) continue;
                g2.drawLine(this.getTimeX(p0time), this.getPercentageY(p0percentage) - 4, this.getTimeX(p0time), this.getPercentageY(p0percentage) + 4);
                g2.drawLine(this.getTimeX(p0time) - 4, this.getPercentageY(p0percentage), this.getTimeX(p0time) + 4, this.getPercentageY(p0percentage));
            }
        }
        String maxString = "";
        for (String legend : labels) {
            if (legend.length() <= maxString.length()) continue;
            maxString = legend;
        }
        int n = this.fm.stringWidth(maxString);
        int x = this.getTimeX(this.kmfi.legendUpperPercentX * this.maxTime) - n;
        int y = this.getPercentageY(this.kmfi.legendUpperPercentY);
        colorIndex = 0;
        for (String legend : labels) {
            g2.setColor(this.kmfi.legendColor[colorIndex]);
            ++colorIndex;
            g2.drawLine(x - 20, y - this.fm.getHeight() / 3, x - 5, y - this.fm.getHeight() / 3);
            g2.drawString(legend, x, y);
            y += this.fm.getHeight();
        }
    }

    private int getTimeX(double value) {
        double d = (double)this.left + (double)(this.right - this.left) * value / (this.maxTime - this.minTime);
        return (int)d;
    }

    private int getPercentageY(double value) {
        value = 1.0 - value;
        double d = (double)this.top + (double)(this.bottom - this.top) * value / (this.maxPercentage - this.minPercentage);
        return (int)d;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    public ArrayList<Double> getxAxisTimeValues() {
        return this.xAxisTimeValues;
    }

    public ArrayList<Integer> getxAxisTimeCoordinates() {
        return this.xAxisTimeCoordinates;
    }

    private void setRenderingHints(Graphics2D g) {
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        rh.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        rh.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        rh.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHints(rh);
    }

    private void drawLegend(Graphics g) {
        Integer coordinate;
        double d;
        Graphics2D g2 = (Graphics2D)g;
        this.setRenderingHints(g2);
        g2.setColor(Color.BLACK);
        Font font = g2.getFont();
        Font f = new Font(font.getFontName(), 1, font.getSize());
        g2.setFont(f);
        this.fm = this.getFontMetrics(f);
        int fontHeight = this.fm.getHeight();
        for (int i = 0; i < this.title.size(); ++i) {
            if ((double)this.fm.stringWidth(this.title.get(i)) > 0.8 * (double)this.getWidth()) {
                f = new Font(font.getFontName(), 1, 10);
                g2.setFont(f);
                this.fm = this.getFontMetrics(f);
            }
            g2.drawString(this.title.get(i), (this.getSize().width - this.fm.stringWidth(this.title.get(i))) / 2, (i + 1) * fontHeight);
        }
        String label = this.df.format(this.minPercentage);
        g2.drawString(label, this.left - 5 - this.fm.stringWidth(label), this.bottom + this.titleHeight / 6);
        g2.drawLine(this.left - 5, this.bottom, this.left, this.bottom);
        for (d = this.minPercentage + this.kmfi.yaxisPercentIncrement; d < this.maxPercentage; d += this.kmfi.yaxisPercentIncrement) {
            int yvalue = this.bottom - (int)(d * (double)(this.bottom - this.top));
            label = this.df.format(d * 100.0);
            g2.drawString(label, this.left - 5 - this.fm.stringWidth(label), yvalue + this.titleHeight / 6);
            g2.drawLine(this.left - 5, yvalue, this.left, yvalue);
        }
        label = this.df.format(this.maxPercentage * 100.0);
        g2.drawString(label, this.left - 5 - this.fm.stringWidth(label), this.top + this.titleHeight / 6);
        g2.drawLine(this.left - 5, this.top, this.left, this.top);
        AffineTransform fontAT = new AffineTransform();
        fontAT.rotate(4.71238898038469);
        Font theDerivedFont = f.deriveFont(fontAT);
        g2.setFont(theDerivedFont);
        int yaxisHeight = this.fm.stringWidth(this.kmfi.yAxisLegend);
        g2.drawString(this.kmfi.yAxisLegend, this.yaxisLabel, this.bottom - (int)(0.5 * (double)(this.bottom - this.top)) + yaxisHeight / 2);
        g2.setFont(f);
        double timeDistance = this.maxTime - this.minTime;
        double timeIncrement = timeDistance * this.kmfi.xaxisPercentIncrement;
        double timeInt = (int)Math.floor(timeIncrement);
        if (timeInt < 1.0) {
            timeInt = 1.0;
        }
        this.adjustedPercentIncrement = timeInt / timeDistance;
        this.xAxisTimeValues.clear();
        this.xAxisTimeCoordinates.clear();
        if (this.kmfi.xAxisLabels.isEmpty()) {
            this.xAxisTimeValues.add(this.minTime);
            this.xAxisTimeCoordinates.add(this.left);
            for (d = this.adjustedPercentIncrement.doubleValue(); d <= 1.0; d += this.adjustedPercentIncrement.doubleValue()) {
                double xaxisTime = this.minTime * this.kmfi.timeScale + d * ((this.maxTime - this.minTime) * this.kmfi.timeScale);
                this.xAxisTimeValues.add(xaxisTime);
                coordinate = this.left + (int)(d * (double)(this.right - this.left));
                this.xAxisTimeCoordinates.add(coordinate);
            }
        } else {
            this.minTime = this.kmfi.xAxisLabels.get(0);
            this.maxTime = this.kmfi.xAxisLabels.get(this.kmfi.xAxisLabels.size() - 1);
            for (Double xaxisTime : this.kmfi.xAxisLabels) {
                this.xAxisTimeValues.add(xaxisTime);
                d = (xaxisTime - this.minTime) / (this.maxTime - this.minTime);
                coordinate = this.left + (int)(d * (double)(this.right - this.left));
                this.xAxisTimeCoordinates.add(coordinate);
            }
        }
        for (int i = 0; i < this.xAxisTimeValues.size(); ++i) {
            Double xaxisTime;
            xaxisTime = this.xAxisTimeValues.get(i);
            Integer xCoordinate = this.xAxisTimeCoordinates.get(i);
            label = this.df.format(xaxisTime);
            if (i == this.xAxisTimeValues.size() - 1) {
                g2.drawString(label, xCoordinate - this.fm.stringWidth(label), this.bottom + this.fm.getHeight() + 5);
            } else {
                g2.drawString(label, xCoordinate - this.fm.stringWidth(label) / 2, this.bottom + this.fm.getHeight() + 5);
            }
            g2.drawLine(xCoordinate, this.bottom, xCoordinate, this.bottom + 5);
        }
        g2.setStroke(this.kmfi.axisStroke);
        g2.drawLine(this.left, this.top, this.left, this.bottom);
        g2.drawLine(this.left, this.bottom, this.right, this.bottom);
        g2.drawString(this.kmfi.xAxisLegend, this.getSize().width / 2 - this.fm.stringWidth(this.kmfi.xAxisLegend) / 2, this.bottom + 2 * this.fm.getHeight() + 10);
    }

    public Double getTimeAxisIncrementPercentage() {
        return this.adjustedPercentIncrement;
    }

    private void setFigureDimensions() {
        this.fm = this.getFontMetrics(this.getFont());
        this.xAxisLabelHeight = this.titleHeight = this.kmfi.titleHeight;
        this.labelWidth = Math.max(this.fm.stringWidth(this.df.format(this.minPercentage)), this.fm.stringWidth(this.df.format(this.maxPercentage))) + 5;
        this.top = this.kmfi.padding + this.titleHeight;
        this.bottom = this.getHeight() - this.kmfi.padding - this.xAxisLabelHeight;
        this.left = this.kmfi.padding + this.labelWidth + this.yaxisLabel;
        this.right = this.getWidth() - this.kmfi.padding;
    }

    public void savePNGKMNumRisk(String fileName) {
        if (fileName.startsWith("null") || fileName.startsWith("Null") || fileName.startsWith("NULL")) {
            return;
        }
        this.fileName = fileName;
        NumbersAtRiskPanel numbersAtRiskPanel = new NumbersAtRiskPanel();
        numbersAtRiskPanel.setKaplanMeierFigure(this);
        numbersAtRiskPanel.setSize(this.getWidth(), numbersAtRiskPanel.getHeight());
        BufferedImage imageKM = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D graphics2D = imageKM.createGraphics();
        this.paint(graphics2D);
        BufferedImage imageNumRisk = new BufferedImage(numbersAtRiskPanel.getWidth(), numbersAtRiskPanel.getHeight(), 1);
        Graphics2D graphics2DNumRisk = imageNumRisk.createGraphics();
        numbersAtRiskPanel.paint(graphics2DNumRisk);
        BufferedImage image = new BufferedImage(numbersAtRiskPanel.getWidth(), numbersAtRiskPanel.getHeight() + this.getHeight(), 1);
        Graphics2D g = image.createGraphics();
        g.drawImage((Image)imageKM, 0, 0, null);
        g.drawImage((Image)imageNumRisk, 0, this.getHeight(), null);
        try {
            ImageIO.write((RenderedImage)image, "png", new File(fileName));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void savePNG(String fileName) {
        if (fileName.startsWith("null") || fileName.startsWith("Null") || fileName.startsWith("NULL")) {
            return;
        }
        this.fileName = fileName;
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D graphics2D = image.createGraphics();
        this.paint(graphics2D);
        try {
            ImageIO.write((RenderedImage)image, "png", new File(fileName));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            KaplanMeierFigure kaplanMeierFigure = new KaplanMeierFigure();
            LinkedHashMap<String, ArrayList<CensorStatus>> survivalDataHashMap = new LinkedHashMap<String, ArrayList<CensorStatus>>();
            ArrayList<CensorStatus> graph1 = new ArrayList<CensorStatus>();
            graph1.add(new CensorStatus("A", 1.0, "1"));
            graph1.add(new CensorStatus("A", 1.0, "1"));
            graph1.add(new CensorStatus("A", 1.0, "1"));
            graph1.add(new CensorStatus("A", 2.0, "1"));
            graph1.add(new CensorStatus("A", 2.0, "1"));
            graph1.add(new CensorStatus("A", 3.0, "1"));
            graph1.add(new CensorStatus("A", 4.0, "1"));
            graph1.add(new CensorStatus("A", 4.0, "1"));
            graph1.add(new CensorStatus("A", 4.0, "1"));
            graph1.add(new CensorStatus("A", 4.0, "1"));
            graph1.add(new CensorStatus("A", 4.0, "1"));
            graph1.add(new CensorStatus("A", 4.0, "1"));
            graph1.add(new CensorStatus("A", 4.0, "0"));
            graph1.add(new CensorStatus("A", 5.0, "1"));
            graph1.add(new CensorStatus("A", 5.0, "1"));
            graph1.add(new CensorStatus("A", 8.0, "0"));
            graph1.add(new CensorStatus("A", 8.0, "0"));
            graph1.add(new CensorStatus("A", 8.0, "0"));
            graph1.add(new CensorStatus("A", 8.0, "0"));
            graph1.add(new CensorStatus("A", 8.0, "0"));
            graph1.add(new CensorStatus("A", 8.0, "0"));
            graph1.add(new CensorStatus("A", 8.0, "1"));
            graph1.add(new CensorStatus("A", 9.0, "1"));
            graph1.add(new CensorStatus("A", 9.0, "1"));
            graph1.add(new CensorStatus("A", 9.0, "1"));
            graph1.add(new CensorStatus("A", 9.0, "1"));
            graph1.add(new CensorStatus("A", 9.0, "1"));
            graph1.add(new CensorStatus("A", 13.0, "0"));
            graph1.add(new CensorStatus("A", 13.0, "0"));
            graph1.add(new CensorStatus("A", 13.0, "1"));
            survivalDataHashMap.put("Label 1", graph1);
            ArrayList<CensorStatus> graph2 = new ArrayList<CensorStatus>();
            graph2.add(new CensorStatus("A", 1.0, "1"));
            graph2.add(new CensorStatus("A", 1.0, "1"));
            graph2.add(new CensorStatus("A", 1.0, "0"));
            graph2.add(new CensorStatus("A", 3.0, "0"));
            graph2.add(new CensorStatus("A", 3.0, "1"));
            graph2.add(new CensorStatus("A", 4.0, "1"));
            graph2.add(new CensorStatus("A", 4.0, "1"));
            graph2.add(new CensorStatus("A", 4.0, "1"));
            graph2.add(new CensorStatus("A", 4.0, "1"));
            graph2.add(new CensorStatus("A", 5.0, "1"));
            graph2.add(new CensorStatus("A", 5.0, "0"));
            graph2.add(new CensorStatus("A", 5.0, "0"));
            graph2.add(new CensorStatus("A", 5.0, "0"));
            graph2.add(new CensorStatus("A", 6.0, "1"));
            graph2.add(new CensorStatus("A", 6.0, "0"));
            graph2.add(new CensorStatus("A", 7.0, "0"));
            graph2.add(new CensorStatus("A", 7.0, "0"));
            graph2.add(new CensorStatus("A", 7.0, "0"));
            graph2.add(new CensorStatus("A", 7.0, "0"));
            graph2.add(new CensorStatus("A", 8.0, "1"));
            graph2.add(new CensorStatus("A", 8.0, "1"));
            graph2.add(new CensorStatus("A", 8.0, "1"));
            graph2.add(new CensorStatus("A", 8.0, "1"));
            graph2.add(new CensorStatus("A", 8.0, "1"));
            graph2.add(new CensorStatus("A", 8.0, "0"));
            graph2.add(new CensorStatus("A", 9.0, "0"));
            graph2.add(new CensorStatus("A", 9.0, "1"));
            graph2.add(new CensorStatus("A", 10.0, "0"));
            graph2.add(new CensorStatus("A", 10.0, "0"));
            graph2.add(new CensorStatus("A", 10.0, "0"));
            survivalDataHashMap.put("Label 2", graph2);
            ArrayList<String> figureInfo = new ArrayList<String>();
            JFrame application = new JFrame();
            application.setDefaultCloseOperation(3);
            application.add(kaplanMeierFigure);
            kaplanMeierFigure.setSize(500, 400);
            application.setSize(500, 400);
            application.setVisible(true);
            ArrayList<String> titles = new ArrayList<String>();
            titles.add("Line 1");
            titles.add("line 2");
            kaplanMeierFigure.setSurvivalData(titles, survivalDataHashMap, true);
            kaplanMeierFigure.setFigureLineInfo(figureInfo);
            kaplanMeierFigure.savePNGKMNumRisk("/Users/Scooter/Downloads/test.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class PlotInfo {
        double time;
        double atRisk;
        double censored;
        double events;
        double percentage;

        PlotInfo() {
        }

        public String toString() {
            return this.time + "\t" + this.atRisk + "\t" + this.censored + "\t" + this.events + "\t" + (this.atRisk - this.events) + "\t" + this.percentage;
        }
    }
}

