/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.kaplanmeier.figure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.JFrame;
import org.biojava.nbio.survival.cox.StrataInfo;
import org.biojava.nbio.survival.cox.SurvFitInfo;
import org.biojava.nbio.survival.cox.SurvivalInfo;
import org.biojava.nbio.survival.data.WorkSheet;
import org.biojava.nbio.survival.kaplanmeier.figure.CensorStatus;
import org.biojava.nbio.survival.kaplanmeier.figure.KaplanMeierFigure;

public class SurvFitKM {
    public SurvFitInfo process(LinkedHashMap<String, ArrayList<CensorStatus>> survivalData, boolean useWeights) throws Exception {
        ArrayList<SurvivalInfo> survivalInfoList = new ArrayList<SurvivalInfo>();
        int i = 0;
        for (String strata : survivalData.keySet()) {
            ArrayList<CensorStatus> csList = survivalData.get(strata);
            for (CensorStatus cs : csList) {
                SurvivalInfo si = new SurvivalInfo(cs.time, Integer.parseInt(cs.censored));
                si.setOrder(i);
                ++i;
                si.setWeight(cs.weight);
                si.addUnknownDataTypeVariable("STRATA", strata);
                si.addUnknownDataTypeVariable("VALUE", cs.value + "");
                survivalInfoList.add(si);
            }
        }
        return this.process("STRATA", survivalInfoList, useWeights);
    }

    public SurvFitInfo process(String datafile, String timeColumn, String statusColumn, String weightColumn, String variableColumn, boolean useWeights) throws Exception {
        WorkSheet worksheet = WorkSheet.readCSV(datafile, '\t');
        ArrayList<SurvivalInfo> survivalInfoList = new ArrayList<SurvivalInfo>();
        int i = 1;
        for (String row : worksheet.getRows()) {
            double time = worksheet.getCellDouble(row, timeColumn);
            double c = worksheet.getCellDouble(row, statusColumn);
            double weight = 1.0;
            if (weightColumn != null && weightColumn.length() > 0) {
                weight = worksheet.getCellDouble(row, weightColumn);
            }
            int strata = 0;
            int censor = (int)c;
            if (weight <= 0.0) {
                ++i;
                continue;
            }
            SurvivalInfo si = new SurvivalInfo(time, censor);
            si.setOrder(i);
            si.setWeight(weight);
            si.setStrata(strata);
            String value = worksheet.getCell(row, variableColumn);
            si.addUnknownDataTypeVariable(variableColumn, value);
            survivalInfoList.add(si);
            ++i;
        }
        return this.process(variableColumn, survivalInfoList, useWeights);
    }

    public SurvFitInfo process(String variable, ArrayList<SurvivalInfo> dataT, boolean useWeighted) throws Exception {
        return this.process(variable, dataT, Method.kaplanMeier, Error.greenwood, true, 0.95, ConfType.log, ConfLower.usual, null, null, useWeighted);
    }

    public LinkedHashMap<String, StrataInfo> processStrataInfo(String variable, ArrayList<SurvivalInfo> dataT, Method method, Error error, boolean seFit, double confInt, ConfType confType, ConfLower confLower, Double startTime, Double newTime, boolean useWeighted) throws Exception {
        int j;
        Collections.sort(dataT);
        if (startTime == null && newTime != null) {
            startTime = newTime;
        }
        if (startTime != null) {
            throw new Exception("Filter on startTime not implemented");
        }
        int n = dataT.size();
        LinkedHashMap<String, Integer> levels = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, ArrayList<Object>> strataHashMap = new LinkedHashMap<String, ArrayList<Object>>();
        for (int i = 0; i < n; ++i) {
            SurvivalInfo si = dataT.get(i);
            String value = si.getUnknownDataTypeVariable(variable);
            Integer count = (Integer)levels.get(value);
            if (count == null) {
                count = 0;
            }
            Integer n2 = count;
            Integer n3 = count = Integer.valueOf(count + 1);
            levels.put(value, count);
            ArrayList<Object> strataList = (ArrayList<Object>)strataHashMap.get(value);
            if (strataList == null) {
                strataList = new ArrayList<Object>();
                strataHashMap.put(value, strataList);
            }
            strataList.add(si);
        }
        LinkedHashMap<String, StrataInfo> strataInfoHashMap = new LinkedHashMap<String, StrataInfo>();
        for (String strata : strataHashMap.keySet()) {
            int i;
            ArrayList strataList = (ArrayList)strataHashMap.get(strata);
            StrataInfo strataInfo = new StrataInfo();
            strataInfoHashMap.put(strata, strataInfo);
            Double previousTime = null;
            Iterator iterator = strataList.iterator();
            while (iterator.hasNext()) {
                SurvivalInfo si = (SurvivalInfo)iterator.next();
                double w = 1.0;
                if (useWeighted) {
                    w = si.getWeight();
                }
                if (previousTime == null || si.getTime() != previousTime.doubleValue()) {
                    strataInfo.getTime().add(si.getTime());
                    if (si.getStatus() == 0) {
                        strataInfo.getStatus().add(0);
                        strataInfo.getNcens().add(w);
                        strataInfo.getNevent().add(0.0);
                    } else {
                        strataInfo.getNcens().add(0.0);
                        strataInfo.getNevent().add(w);
                        strataInfo.getStatus().add(1);
                    }
                    strataInfo.getNrisk().add(0.0);
                    strataInfo.getStderr().add(0.0);
                    strataInfo.getWeight().add(w);
                } else {
                    double nw;
                    int index = strataInfo.getTime().size() - 1;
                    if (si.getStatus() == 0) {
                        nw = strataInfo.getNcens().get(index) + w;
                        strataInfo.getNcens().remove(index);
                        strataInfo.getNcens().add(nw);
                    } else {
                        nw = strataInfo.getNevent().get(index) + w;
                        strataInfo.getNevent().remove(index);
                        strataInfo.getNevent().add(nw);
                    }
                    nw = strataInfo.getWeight().get(index) + w;
                    strataInfo.getWeight().remove(index);
                    strataInfo.getWeight().add(nw);
                }
                previousTime = si.getTime();
                Integer ndead = strataInfo.getNdead().get(si.getTime());
                if (ndead == null) {
                    ndead = 0;
                }
                if (si.getStatus() == 1) {
                    Integer nw = ndead;
                    Integer n4 = ndead = Integer.valueOf(ndead + 1);
                }
                strataInfo.getNdead().put(si.getTime(), ndead);
            }
            j = strataInfo.getWeight().size() - 1;
            double cw = 0.0;
            for (i = strataInfo.getWeight().size() - 1; i >= 0; --i) {
                double c = strataInfo.getWeight().get(i);
                strataInfo.getNrisk().set(j, cw += c);
                --j;
            }
            if (method == Method.kaplanMeier) {
                for (i = 0; i < strataInfo.getNrisk().size(); ++i) {
                    double t = (strataInfo.getNrisk().get(i) - strataInfo.getNevent().get(i)) / strataInfo.getNrisk().get(i);
                    if (i == 0) {
                        strataInfo.getSurv().add(t);
                        continue;
                    }
                    strataInfo.getSurv().add(t * strataInfo.getSurv().get(i - 1));
                }
            } else if (method == Method.flemingHarrington) {
                for (i = 0; i < strataInfo.getNrisk().size(); ++i) {
                    double hazard = strataInfo.getNevent().get(i) / strataInfo.getNrisk().get(i);
                    if (i == 0) {
                        strataInfo.getSurv().add(Math.exp(-1.0 * hazard));
                        continue;
                    }
                    strataInfo.getSurv().add(Math.exp(-1.0 * (hazard + strataInfo.getSurv().get(i - 1))));
                }
            } else if (method == Method.fh2) {
                throw new Exception("Method.fh2 not supported. Need to implement survfit4.c ");
            }
            if (!seFit) continue;
            if (error == Error.greenwood) {
                for (i = 0; i < strataInfo.getNrisk().size(); ++i) {
                    double t = strataInfo.getNevent().get(i) / (strataInfo.getNrisk().get(i) * (strataInfo.getNrisk().get(i) - strataInfo.getNevent().get(i)));
                    if (i == 0) {
                        strataInfo.getVarhaz().add(t);
                        continue;
                    }
                    strataInfo.getVarhaz().add(t + strataInfo.getVarhaz().get(i - 1));
                }
            } else if (method == Method.kaplanMeier || method == Method.flemingHarrington) {
                for (i = 0; i < strataInfo.getNrisk().size(); ++i) {
                    double t = strataInfo.getNevent().get(i) / (strataInfo.getNrisk().get(i) * strataInfo.getNrisk().get(i));
                    if (i == 0) {
                        strataInfo.getVarhaz().add(t);
                        continue;
                    }
                    strataInfo.getVarhaz().add(t + strataInfo.getVarhaz().get(i - 1));
                }
            } else {
                throw new Exception("Method.fh2 not supported. Need to implement survfit4.c ");
            }
            strataInfo.getStderr().clear();
            for (i = 0; i < strataInfo.getNrisk().size(); ++i) {
                strataInfo.getStderr().add(Math.sqrt(strataInfo.getVarhaz().get(i)));
            }
        }
        ArrayList<Boolean> events = new ArrayList<Boolean>();
        ArrayList<Double> nrisk = new ArrayList<Double>();
        for (StrataInfo strataInfo : strataInfoHashMap.values()) {
            boolean firsttime = true;
            for (j = 0; j < strataInfo.getNevent().size(); ++j) {
                Double d = strataInfo.getNevent().get(j);
                if (d > 0.0 || firsttime) {
                    firsttime = false;
                    events.add(true);
                    nrisk.add(strataInfo.getNrisk().get(j));
                    continue;
                }
                events.add(false);
            }
        }
        ArrayList<Integer> zz = new ArrayList<Integer>();
        for (int i = 0; i < events.size(); ++i) {
            if (!((Boolean)events.get(i)).booleanValue()) continue;
            zz.add(i + 1);
        }
        zz.add(events.size() + 1);
        ArrayList<Integer> diffzz = new ArrayList<Integer>();
        for (int i = 0; i < zz.size() - 1; ++i) {
            diffzz.add((Integer)zz.get(i + 1) - (Integer)zz.get(i));
        }
        ArrayList nlag = new ArrayList();
        for (j = 0; j < nrisk.size(); ++j) {
            int count = (Integer)diffzz.get(j);
            for (int c = 0; c < count; ++c) {
                nlag.add(nrisk.get(j));
            }
        }
        if (confLower == ConfLower.usual) {
            for (StrataInfo strataInfo : strataInfoHashMap.values()) {
                strataInfo.setStdlow(strataInfo.getStderr());
            }
        } else if (confLower == ConfLower.peto) {
            for (StrataInfo strataInfo : strataInfoHashMap.values()) {
                for (int j2 = 0; j2 < strataInfo.getSurv().size(); ++j2) {
                    double v = Math.sqrt((1.0 - strataInfo.getSurv().get(j2)) / strataInfo.getNrisk().get(j2));
                    strataInfo.getStdlow().add(v);
                }
            }
        } else if (confLower == ConfLower.modified) {
            int i = 0;
            for (StrataInfo strataInfo : strataInfoHashMap.values()) {
                for (int j3 = 0; j3 < strataInfo.getSurv().size(); ++j3) {
                    double v = strataInfo.getStderr().get(j3) * Math.sqrt((Double)nlag.get(i) / strataInfo.getNrisk().get(j3));
                    strataInfo.getStdlow().add(v);
                    ++i;
                }
            }
        }
        double zvalue = 1.959964;
        if (confType == ConfType.plain) {
            for (StrataInfo strataInfo : strataInfoHashMap.values()) {
                for (int j4 = 0; j4 < strataInfo.getSurv().size(); ++j4) {
                    double upper = strataInfo.getSurv().get(j4) + zvalue * strataInfo.getStderr().get(j4) * strataInfo.getSurv().get(j4);
                    double lower = strataInfo.getSurv().get(j4) - zvalue * strataInfo.getStdlow().get(j4) * strataInfo.getSurv().get(j4);
                    strataInfo.getLower().add(lower);
                    strataInfo.getUpper().add(upper);
                }
            }
        } else if (confType == ConfType.log) {
            for (StrataInfo strataInfo : strataInfoHashMap.values()) {
                for (int j5 = 0; j5 < strataInfo.getSurv().size(); ++j5) {
                    double surv = strataInfo.getSurv().get(j5);
                    if (surv == 0.0) {
                        strataInfo.getLower().add(Double.NaN);
                        strataInfo.getUpper().add(Double.NaN);
                        continue;
                    }
                    double upper = Math.exp(Math.log(surv) + zvalue * strataInfo.getStderr().get(j5));
                    double lower = Math.exp(Math.log(surv) - zvalue * strataInfo.getStdlow().get(j5));
                    strataInfo.getLower().add(lower);
                    strataInfo.getUpper().add(upper);
                }
            }
        } else if (confType == ConfType.log_log) {
            throw new Exception("ConfType log-log currently not supported");
        }
        return strataInfoHashMap;
    }

    public SurvFitInfo process(String variable, ArrayList<SurvivalInfo> dataT, Method method, Error error, boolean seFit, double confInt, ConfType confType, ConfLower confLower, Double startTime, Double newTime, boolean useWeighted) throws Exception {
        SurvFitInfo si = new SurvFitInfo();
        LinkedHashMap<String, StrataInfo> strataInfoHashMap = this.processStrataInfo(variable, dataT, method, error, seFit, confInt, confType, confLower, startTime, newTime, useWeighted);
        si.setStrataInfoHashMap(strataInfoHashMap);
        LinkedHashMap<String, StrataInfo> unweightedStrataInfoHashMap = this.processStrataInfo(variable, dataT, method, error, seFit, confInt, confType, confLower, startTime, newTime, false);
        si.setUnweightedStrataInfoHashMap(unweightedStrataInfoHashMap);
        si.setWeighted(useWeighted);
        return si;
    }

    public static void main(String[] args) {
        try {
            String datafile = "/Users/Scooter/scripps/ngs/BLJ/E2197/Predictive Signatures/V$HSF_Q6-E2197 TTR.txt";
            SurvFitKM survFitKM = new SurvFitKM();
            SurvFitInfo si = survFitKM.process(datafile, "TIME", "STATUS", "WEIGHT", "MEAN", true);
            KaplanMeierFigure kaplanMeierFigure = new KaplanMeierFigure();
            JFrame application = new JFrame();
            application.setDefaultCloseOperation(3);
            application.add(kaplanMeierFigure);
            kaplanMeierFigure.setSize(500, 400);
            application.setSize(500, 400);
            application.setVisible(true);
            ArrayList<String> titles = new ArrayList<String>();
            titles.add("Line 1");
            titles.add("line 2");
            kaplanMeierFigure.setSurvivalData(titles, si, null);
            ArrayList<String> figureInfo = new ArrayList<String>();
            kaplanMeierFigure.setFigureLineInfo(figureInfo);
            kaplanMeierFigure.savePNG("/Users/Scooter/Downloads/test.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum ConfLower {
        usual,
        peto,
        modified;

    }

    public static enum ConfType {
        log,
        log_log,
        plain,
        none;

    }

    public static enum Error {
        greenwood,
        tsiatis;

    }

    public static enum Method {
        kaplanMeier,
        flemingHarrington,
        fh2;

    }
}

