/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.cox;

import java.text.DecimalFormat;

public class CoxCoefficient {
    String name;
    double coeff;
    double stdError;
    double robustStdError;
    double z;
    double hazardRatio;
    double hazardRatioLoCI;
    double hazardRatioHiCI;
    double pvalue;
    double mean;
    double standardDeviation;

    public String toString() {
        return this.name + " " + this.coeff + " " + this.pvalue + " " + this.hazardRatio + " " + this.hazardRatioLoCI + " " + this.hazardRatioHiCI;
    }

    public String getHRText() {
        return CoxCoefficient.fmt(this.hazardRatio, 2, 0) + " CI(" + CoxCoefficient.fmt(this.hazardRatioLoCI, 2, 0) + "-" + CoxCoefficient.fmt(this.hazardRatioHiCI, 2, 0) + ")";
    }

    public String getName() {
        return this.name;
    }

    public double getCoeff() {
        return this.coeff;
    }

    public double getStdError() {
        return this.stdError;
    }

    public double getRobustStdError() {
        return this.robustStdError;
    }

    public double getZ() {
        return this.z;
    }

    public double getHazardRatio() {
        return this.hazardRatio;
    }

    public double getHazardRatioLoCI() {
        return this.hazardRatioLoCI;
    }

    public double getHazardRatioHiCI() {
        return this.hazardRatioHiCI;
    }

    public double getPvalue() {
        return this.pvalue;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCoeff(double coeff) {
        this.coeff = coeff;
    }

    public void setStdError(double stdError) {
        this.stdError = stdError;
    }

    public void setRobustStdError(double robustStdError) {
        this.robustStdError = robustStdError;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setHazardRatio(double hazardRatio) {
        this.hazardRatio = hazardRatio;
    }

    public void setHazardRatioLoCI(double hazardRatioLoCI) {
        this.hazardRatioLoCI = hazardRatioLoCI;
    }

    public void setHazardRatioHiCI(double hazardRatioHiCI) {
        this.hazardRatioHiCI = hazardRatioHiCI;
    }

    public void setPvalue(double pvalue) {
        this.pvalue = pvalue;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public void setStandardDeviation(double standardDeviation) {
        this.standardDeviation = standardDeviation;
    }

    public static String fmt(Double d, int precision, int pad) {
        String value = "";
        DecimalFormat dfe = new DecimalFormat("0.00E0");
        String dpad = "0.";
        double p = 1.0;
        for (int i = 0; i < precision; ++i) {
            dpad = dpad + "0";
            p /= 10.0;
        }
        DecimalFormat df = new DecimalFormat(dpad);
        value = Math.abs(d) >= p ? df.format(d) : dfe.format(d);
        int length = value.length();
        int extra = pad - length;
        if (extra > 0) {
            for (int i = 0; i < extra; ++i) {
                value = " " + value;
            }
        }
        return value;
    }
}

