/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.cox.comparators;

import java.util.Comparator;
import org.biojava.nbio.survival.cox.CoxInfo;
import org.biojava.nbio.survival.cox.CoxVariables;

public class MeanModelComparator
implements Comparator<CoxVariables> {
    String variable = "";

    public MeanModelComparator(String variable) {
        this.variable = variable;
    }

    @Override
    public int compare(CoxVariables coxVariables1, CoxVariables coxVariables2) {
        double c2GTpvalue;
        CoxInfo ci1LTMean = coxVariables1.getCoxInfo("<MEAN");
        CoxInfo ci1GTMean = coxVariables1.getCoxInfo(">MEAN");
        if (ci1LTMean == null || ci1GTMean == null) {
            return 0;
        }
        double c1LTpvalue = ci1LTMean.getCoefficient(this.variable).getPvalue();
        double c1GTpvalue = ci1GTMean.getCoefficient(this.variable).getPvalue();
        double c1ratio = Math.min(c1LTpvalue, c1GTpvalue) / Math.max(c1LTpvalue, c1GTpvalue);
        CoxInfo ci2LTMean = coxVariables2.getCoxInfo("<MEAN");
        CoxInfo ci2GTMean = coxVariables2.getCoxInfo(">MEAN");
        double c2LTpvalue = ci2LTMean.getCoefficient(this.variable).getPvalue();
        double c2ratio = Math.min(c2LTpvalue, c2GTpvalue = ci2GTMean.getCoefficient(this.variable).getPvalue()) / Math.max(c2LTpvalue, c2GTpvalue);
        if (c1ratio > c2ratio) {
            return 1;
        }
        if (c1ratio < c2ratio) {
            return -1;
        }
        return 0;
    }
}

