/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.data;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class CompactCharSequence
implements CharSequence,
Serializable {
    static final long serialVersionUID = 1L;
    private static final String ENCODING = "ISO-8859-1";
    private final int offset;
    private final int end;
    private final byte[] data;
    private final boolean nullstring;

    private CompactCharSequence(byte[] data, int offset, int end) {
        this.data = data;
        this.offset = offset;
        this.end = end;
        this.nullstring = false;
    }

    public CompactCharSequence(String str) {
        try {
            if (str != null) {
                this.data = str.getBytes(ENCODING);
                this.offset = 0;
                this.end = this.data.length;
                this.nullstring = false;
            } else {
                this.data = new byte[0];
                this.offset = 0;
                this.end = 0;
                this.nullstring = true;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected: ISO-8859-1 not supported!");
        }
    }

    @Override
    public char charAt(int index) {
        int ix = index + this.offset;
        if (ix >= this.end) {
            throw new StringIndexOutOfBoundsException("Invalid index " + index + " length " + this.length());
        }
        return (char)(this.data[ix] & 0xFF);
    }

    @Override
    public int length() {
        return this.end - this.offset;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || end >= this.end - this.offset) {
            throw new IllegalArgumentException("Illegal range " + start + "-" + end + " for sequence of length " + this.length());
        }
        return new CompactCharSequence(this.data, start + this.offset, end + this.offset);
    }

    @Override
    public String toString() {
        try {
            if (this.nullstring) {
                return null;
            }
            if (this.length() == 0) {
                return "";
            }
            return new String(this.data, this.offset, this.end - this.offset, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected: ISO-8859-1 not supported");
        }
    }
}

