/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.cox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.commons.math.stat.correlation.Covariance;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.biojava.nbio.survival.cox.CoxInfo;
import org.biojava.nbio.survival.cox.CoxR;
import org.biojava.nbio.survival.cox.ResidualsCoxph;
import org.biojava.nbio.survival.cox.SurvivalInfo;
import org.biojava.nbio.survival.cox.matrix.Matrix;

public class CoxCC {
    public static void process(CoxInfo ci) throws Exception {
        ArrayList<SurvivalInfo> survivalInfoList = ci.survivalInfoList;
        ArrayList<String> variables = new ArrayList<String>(ci.getCoefficientsList().keySet());
        ArrayList<Integer> strataClass = new ArrayList<Integer>(survivalInfoList.size());
        double[] wt = new double[survivalInfoList.size()];
        for (int i = 0; i < survivalInfoList.size(); ++i) {
            SurvivalInfo si = survivalInfoList.get(i);
            strataClass.add(si.getStrata());
            wt[i] = si.getWeight();
        }
        double[][] r = ResidualsCoxph.process(ci, ResidualsCoxph.Type.score, false, null);
        double[][] rvar = null;
        rvar = ci.getNaiveVariance() != null ? ci.getNaiveVariance() : ci.getVariance();
        LinkedHashMap<Integer, Double> nj = new LinkedHashMap<Integer, Double>();
        Collections.sort(strataClass);
        for (Integer value : strataClass) {
            Double count = (Double)nj.get(value);
            if (count == null) {
                count = 0.0;
            }
            Double d = count;
            Double d2 = count = Double.valueOf(count + 1.0);
            nj.put(value, count);
        }
        LinkedHashMap<Integer, Double> Nj = new LinkedHashMap<Integer, Double>();
        double N = 0.0;
        for (int i = 0; i < survivalInfoList.size(); ++i) {
            SurvivalInfo si = survivalInfoList.get(i);
            Integer strata = si.getStrata();
            Double weight = si.getWeight();
            Double sum = (Double)Nj.get(strata);
            if (sum == null) {
                sum = 0.0;
            }
            sum = sum + weight;
            Nj.put(strata, sum);
        }
        for (Object value : Nj.values()) {
            N += ((Double)value).doubleValue();
        }
        LinkedHashMap<Object, Double> k1j = new LinkedHashMap<Object, Double>();
        for (Object key : nj.keySet()) {
            double _nj = (Double)nj.get(key);
            double _Nj = (Double)Nj.get(key);
            k1j.put(key, _Nj * (_Nj / _nj - 1.0));
        }
        double[][] V = new double[variables.size()][variables.size()];
        for (Integer i : k1j.keySet()) {
            if (!((Double)nj.get(i) > 1.0)) continue;
            LinkedHashMap<String, DescriptiveStatistics> variableStatsMap = new LinkedHashMap<String, DescriptiveStatistics>();
            for (int p = 0; p < survivalInfoList.size(); ++p) {
                SurvivalInfo si = survivalInfoList.get(p);
                if (si.getStrata() != i.intValue()) continue;
                for (int col = 0; col < variables.size(); ++col) {
                    String v = variables.get(col);
                    DescriptiveStatistics ds = (DescriptiveStatistics)variableStatsMap.get(v);
                    if (ds == null) {
                        ds = new DescriptiveStatistics();
                        variableStatsMap.put(v, ds);
                    }
                    ds.addValue(r[p][col]);
                }
            }
            double[][] var_covar = new double[variables.size()][variables.size()];
            for (int m = 0; m < variables.size(); ++m) {
                String var_m = variables.get(m);
                for (int n = 0; n < variables.size(); ++n) {
                    double covar;
                    String var_n = variables.get(n);
                    if (m == n) {
                        DescriptiveStatistics ds = (DescriptiveStatistics)variableStatsMap.get(var_m);
                        var_covar[m][n] = ds.getVariance();
                        continue;
                    }
                    DescriptiveStatistics ds_m = (DescriptiveStatistics)variableStatsMap.get(var_m);
                    DescriptiveStatistics ds_n = (DescriptiveStatistics)variableStatsMap.get(var_n);
                    Covariance cv = new Covariance();
                    var_covar[m][n] = covar = cv.covariance(ds_m.getValues(), ds_n.getValues(), true);
                }
            }
            V = Matrix.add(V, Matrix.scale(var_covar, (Double)k1j.get(i)));
        }
        double[][] imat1 = Matrix.multiply(rvar, V);
        imat1 = Matrix.multiply(imat1, rvar);
        imat1 = Matrix.add(rvar, imat1);
        ci.setVariance(imat1);
        CoxR.calculateWaldTestInfo(ci);
        ci.setScoreLogrankTest(Double.NaN);
        ci.setScoreLogrankTestpvalue(Double.NaN);
    }

    public static void main(String[] args) {
    }
}

