/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.cox;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.biojava.nbio.survival.cox.CoxCoefficient;
import org.biojava.nbio.survival.cox.CoxMethod;
import org.biojava.nbio.survival.cox.SurvivalInfo;
import org.biojava.nbio.survival.cox.WaldTestInfo;
import org.biojava.nbio.survival.cox.stats.ChiSq;
import org.biojava.nbio.survival.kaplanmeier.figure.ExpressionFigure;
import org.biojava.nbio.survival.kaplanmeier.figure.KaplanMeierFigure;

public class CoxInfo {
    private WaldTestInfo waldTestInfo = null;
    String message = "";
    Integer maxIterations = null;
    Double eps = null;
    Double toler = null;
    CoxMethod method;
    private double[][] imat = null;
    private double[][] naive_imat = null;
    double[] u = new double[0];
    int iterations = 0;
    int flag = 0;
    double logTest = 0.0;
    double logTestpval = 0.0;
    double loglikInit = 0.0;
    double loglikFinal = 0.0;
    Double scoreLogrankTest;
    private Double rscore = null;
    private Double rscoreLogrankTestpvalue = null;
    private double degreeFreedom;
    private Double scoreLogrankTestpvalue;
    int numSamples = 0;
    int numEvents = 0;
    private LinkedHashMap<String, String> metaDataFilter = null;
    private LinkedHashMap<String, CoxCoefficient> coefficientsList = new LinkedHashMap();
    LinkedHashMap<Double, Double> baselineSurvivorFunction = new LinkedHashMap();
    ArrayList<SurvivalInfo> survivalInfoList = new ArrayList();
    public KaplanMeierFigure kmf = null;
    public ExpressionFigure ef = null;

    public ArrayList<SurvivalInfo> getSurvivalInfoList() {
        return this.survivalInfoList;
    }

    public void setVariance(double[][] var) throws Exception {
        this.imat = new double[var.length][var[0].length];
        for (int i = 0; i < var.length; ++i) {
            for (int j = 0; j < var[0].length; ++j) {
                this.imat[i][j] = var[i][j];
            }
        }
        this.calcSummaryValues();
    }

    public double[][] getVariance() {
        double[][] var = new double[this.imat.length][this.imat[0].length];
        for (int i = 0; i < var.length; ++i) {
            for (int j = 0; j < var[0].length; ++j) {
                var[i][j] = this.imat[i][j];
            }
        }
        return var;
    }

    public void setNaiveVariance(double[][] var) throws Exception {
        this.naive_imat = new double[var.length][var[0].length];
        for (int i = 0; i < var.length; ++i) {
            for (int j = 0; j < var[0].length; ++j) {
                this.naive_imat[i][j] = var[i][j];
            }
        }
        this.calcSummaryValues();
    }

    public double[][] getNaiveVariance() {
        double[][] var = new double[this.imat.length][this.imat[0].length];
        for (int i = 0; i < var.length; ++i) {
            for (int j = 0; j < var[0].length; ++j) {
                var[i][j] = this.naive_imat[i][j];
            }
        }
        return var;
    }

    public void setSurvivalInfoList(ArrayList<SurvivalInfo> data) {
        this.survivalInfoList = data;
        this.numSamples = data.size();
        for (SurvivalInfo si : data) {
            if (si.getStatus() != 1) continue;
            ++this.numEvents;
        }
    }

    public double[] getWeighted() {
        double[] weighted = new double[this.survivalInfoList.size()];
        int p = 0;
        for (SurvivalInfo si : this.survivalInfoList) {
            weighted[p] = si.getWeight();
            ++p;
        }
        return weighted;
    }

    public double[][] getVariableResiduals() {
        ArrayList<String> variables = new ArrayList<String>(this.coefficientsList.keySet());
        double[][] rr = new double[this.survivalInfoList.size()][variables.size()];
        int p = 0;
        for (SurvivalInfo si : this.survivalInfoList) {
            int i = 0;
            for (String v : variables) {
                rr[p][i] = si.getResidualVariable(v);
                ++i;
            }
            ++p;
        }
        return rr;
    }

    public void setVariableResiduals(double[][] rr) {
        ArrayList<String> variables = new ArrayList<String>(this.coefficientsList.keySet());
        int p = 0;
        for (SurvivalInfo si : this.survivalInfoList) {
            int i = 0;
            for (String v : variables) {
                si.setResidualVariable(v, rr[p][i]);
                ++i;
            }
            ++p;
        }
    }

    public int getNumberCoefficients() {
        return this.coefficientsList.size();
    }

    public CoxCoefficient getCoefficient(String name) {
        return this.coefficientsList.get(name);
    }

    public void setCoefficient(String name, CoxCoefficient coefficient) {
        this.coefficientsList.put(name, coefficient);
    }

    public String getCoefficientText(boolean header, String beginLine, String beginCell, String endCell, String endLine) {
        String o = "";
        if (header) {
            String robust = "";
            if (this.naive_imat != null) {
                robust = beginCell + "robust se" + endCell;
            }
            o = o + beginLine + beginCell + this.fmtpl("", 9) + endCell + beginCell + this.fmtpl("coef", 9) + endCell + beginCell + this.fmtpl("se(coef)", 9) + endCell + robust + beginCell + this.fmtpl("z", 9) + endCell + beginCell + this.fmtpl("p-value", 9) + endCell + beginCell + this.fmtpl("HR", 9) + endCell + beginCell + this.fmtpl("lower .95", 9) + endCell + beginCell + this.fmtpl("upper .95", 9) + endCell + endLine;
        }
        for (CoxCoefficient coe : this.coefficientsList.values()) {
            String robust = "";
            String stderror = "";
            if (this.naive_imat != null) {
                stderror = beginCell + CoxInfo.fmt(coe.getRobustStdError(), 5, 9) + endCell;
                robust = beginCell + CoxInfo.fmt(coe.getStdError(), 5, 9) + endCell;
            } else {
                stderror = beginCell + CoxInfo.fmt(coe.getStdError(), 5, 9) + endCell;
            }
            o = o + beginLine + beginCell + this.fmtpr(coe.getName(), 9) + endCell + beginCell + CoxInfo.fmt(coe.getCoeff(), 5, 9) + stderror + robust + endCell + beginCell + CoxInfo.fmt(coe.getZ(), 5, 9) + endCell + beginCell + CoxInfo.fmt(coe.getPvalue(), 6, 9) + endCell + beginCell + CoxInfo.fmt(coe.getHazardRatio(), 3, 9) + endCell + beginCell + CoxInfo.fmt(coe.getHazardRatioLoCI(), 3, 9) + endCell + beginCell + CoxInfo.fmt(coe.getHazardRatioHiCI(), 3, 9) + endCell + endLine;
        }
        return o;
    }

    public static String fmt(Double d, int precision, int pad) {
        if (d == null) {
            return "";
        }
        if (Double.isNaN(d)) {
            return "";
        }
        String value = "";
        DecimalFormat dfe = new DecimalFormat("0.00E0");
        String dpad = "0.";
        double p = 1.0;
        for (int i = 0; i < precision; ++i) {
            dpad = dpad + "0";
            p /= 10.0;
        }
        DecimalFormat df = new DecimalFormat(dpad);
        value = Math.abs(d) >= p ? df.format(d) : dfe.format(d);
        int length = value.length();
        int extra = pad - length;
        if (extra > 0) {
            for (int i = 0; i < extra; ++i) {
                value = " " + value;
            }
        }
        return value;
    }

    private void calcSummaryValues() {
        ArrayList<String> variables = new ArrayList<String>(this.coefficientsList.keySet());
        for (int i = 0; i < variables.size(); ++i) {
            String variable = variables.get(i);
            CoxCoefficient coe = this.coefficientsList.get(variable);
            coe.setStdError(Math.sqrt(this.imat[i][i]));
            if (this.naive_imat != null) {
                coe.setRobustStdError(Math.sqrt(this.naive_imat[i][i]));
            }
            coe.setZ(coe.getCoeff() / coe.getStdError());
            coe.setPvalue(ChiSq.norm(Math.abs(coe.getCoeff() / coe.getStdError())));
            double z = 1.959964;
            coe.setHazardRatioLoCI(Math.exp(coe.getCoeff() - z * coe.getStdError()));
            coe.setHazardRatioHiCI(Math.exp(coe.getCoeff() + z * coe.getStdError()));
        }
        this.logTest = -2.0 * (this.loglikInit - this.loglikFinal);
        this.logTestpval = ChiSq.chiSq(this.logTest, (int)this.degreeFreedom);
        this.scoreLogrankTestpvalue = ChiSq.chiSq(this.scoreLogrankTest, (int)this.degreeFreedom);
        if (this.rscore != null) {
            this.rscoreLogrankTestpvalue = ChiSq.chiSq(this.rscore, (int)this.degreeFreedom);
        }
    }

    public void dump() {
        int j;
        int i;
        System.out.println();
        System.out.println("$coef");
        for (CoxCoefficient coe : this.coefficientsList.values()) {
            System.out.print(coe.getCoeff() + " ");
        }
        System.out.println();
        System.out.println("$means");
        for (CoxCoefficient coe : this.coefficientsList.values()) {
            System.out.print(coe.getMean() + " ");
        }
        System.out.println();
        System.out.println("$u");
        for (Object d : (Object)this.u) {
            System.out.print((double)d + " ");
        }
        System.out.println();
        System.out.println("$imat");
        for (i = 0; i < this.imat.length; ++i) {
            for (j = 0; j < this.imat[0].length; ++j) {
                System.out.print(this.imat[i][j] + " ");
            }
            System.out.println();
        }
        if (this.naive_imat != null) {
            System.out.println("$naive_imat");
            for (i = 0; i < this.naive_imat.length; ++i) {
                for (j = 0; j < this.naive_imat[0].length; ++j) {
                    System.out.print(this.naive_imat[i][j] + " ");
                }
                System.out.println();
            }
        }
        System.out.println();
        System.out.println("$loglik");
        System.out.println(this.loglikInit + " " + this.loglikFinal);
        System.out.println();
        System.out.println("$sctest");
        System.out.println(this.scoreLogrankTest);
        System.out.println("$iter");
        System.out.println(this.iterations);
        System.out.println("$flag");
        System.out.println(this.flag);
        System.out.println();
    }

    public String fmtpr(String d, int pad) {
        int length = d.length();
        int extra = pad - length;
        if (extra < 0) {
            extra = 0;
        }
        String v = d;
        for (int i = 0; i < extra; ++i) {
            v = v + " ";
        }
        return v;
    }

    public String fmtpl(String d, int pad) {
        int length = d.length();
        int extra = pad - length;
        if (extra < 0) {
            extra = 0;
        }
        String v = d;
        for (int i = 0; i < extra; ++i) {
            v = " " + v;
        }
        return v;
    }

    public String toString() {
        return this.toString("", " ", "\r\n");
    }

    public String toString(String beginLine, String del, String endLine) {
        String o = beginLine + this.fmtpl("", 9) + this.fmtpl("Avg", 9) + this.fmtpl("SD", 9) + endLine;
        for (CoxCoefficient coe : this.coefficientsList.values()) {
            o = o + beginLine + this.fmtpr(coe.getName(), 9) + CoxInfo.fmt(coe.getMean(), 4, 9) + CoxInfo.fmt(coe.getStandardDeviation(), 4, 9) + endLine;
        }
        o = o + beginLine + endLine;
        o = o + beginLine + "n= " + this.numSamples + ", number of events=" + this.numEvents + endLine;
        o = o + this.getCoefficientText(true, beginLine, del, "", endLine);
        o = o + beginLine + endLine;
        if (this.baselineSurvivorFunction.size() > 0) {
            o = o + beginLine + "Baseline Survivor Function (at predictor means)" + endLine;
            for (Double time : this.baselineSurvivorFunction.keySet()) {
                Double mean = this.baselineSurvivorFunction.get(time);
                o = o + beginLine + CoxInfo.fmt(time, 4, 10) + CoxInfo.fmt(mean, 4, 10) + endLine;
            }
        }
        o = o + beginLine + endLine;
        o = o + beginLine + "Overall Model Fit" + endLine;
        o = o + beginLine + "Iterations=" + this.iterations + endLine;
        o = o + beginLine + "Likelihood ratio test = " + CoxInfo.fmt(this.logTest, 2, 0) + " df=" + this.degreeFreedom + " p-value=" + CoxInfo.fmt(this.logTestpval, 7, 0) + endLine;
        o = o + beginLine + "Wald test             = " + CoxInfo.fmt(this.waldTestInfo.getTest(), 2, 0) + " df=" + this.waldTestInfo.getDf() + " p-value=" + CoxInfo.fmt(this.waldTestInfo.getPvalue(), 7, 0) + endLine;
        o = o + beginLine + "Score (logrank) test  = " + CoxInfo.fmt(this.scoreLogrankTest, 2, 0) + " df=" + (int)this.degreeFreedom + " p-value=" + CoxInfo.fmt(this.scoreLogrankTestpvalue, 7, 0);
        if (this.rscore != null) {
            o = o + ",  Robust = " + CoxInfo.fmt(this.rscore, 2, 0) + " p-value=" + CoxInfo.fmt(this.rscoreLogrankTestpvalue, 7, 0);
        }
        o = o + endLine;
        o = o + beginLine + "Method=" + this.method.name() + endLine;
        return o;
    }

    public double getChiSquare() {
        return this.scoreLogrankTest;
    }

    public double getDegreeFreedom() {
        return this.degreeFreedom;
    }

    public double getOverallModelFitPvalue() {
        return this.scoreLogrankTestpvalue;
    }

    public Double getRscore() {
        return this.rscore;
    }

    public void setRscore(Double rscore) {
        this.rscore = rscore;
        if (rscore != null) {
            this.rscoreLogrankTestpvalue = ChiSq.chiSq(rscore, (int)this.degreeFreedom);
        }
    }

    public Double getRscoreLogrankTestpvalue() {
        return this.rscoreLogrankTestpvalue;
    }

    public void setRscoreLogrankTestpvalue(Double rscoreLogrankTestpvalue) {
        this.rscoreLogrankTestpvalue = rscoreLogrankTestpvalue;
    }

    public Double getScoreLogrankTest() {
        return this.scoreLogrankTest;
    }

    public void setScoreLogrankTest(Double scoreLogrankTest) {
        this.scoreLogrankTest = scoreLogrankTest;
    }

    public Double getScoreLogrankTestpvalue() {
        return this.scoreLogrankTestpvalue;
    }

    public void setScoreLogrankTestpvalue(Double scoreLogrankTestpvalue) {
        this.scoreLogrankTestpvalue = scoreLogrankTestpvalue;
    }

    public LinkedHashMap<String, String> getMetaDataFilter() {
        return this.metaDataFilter;
    }

    public void setMetaDataFilter(LinkedHashMap<String, String> metaDataFilter) {
        this.metaDataFilter = metaDataFilter;
    }

    public LinkedHashMap<String, CoxCoefficient> getCoefficientsList() {
        return this.coefficientsList;
    }

    public WaldTestInfo getWaldTestInfo() {
        return this.waldTestInfo;
    }

    public double[][] getImat() {
        return this.imat;
    }

    public double[][] getNaive_imat() {
        return this.naive_imat;
    }

    public void setDegreeFreedom(double degreeFreedom) {
        this.degreeFreedom = degreeFreedom;
    }

    public void setWaldTestInfo(WaldTestInfo waldTestInfo) {
        this.waldTestInfo = waldTestInfo;
    }
}

