/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.cox;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import org.biojava.nbio.survival.cox.CoxCoefficient;
import org.biojava.nbio.survival.cox.CoxInfo;
import org.biojava.nbio.survival.cox.CoxMart;
import org.biojava.nbio.survival.cox.CoxMethod;
import org.biojava.nbio.survival.cox.ResidualsCoxph;
import org.biojava.nbio.survival.cox.SurvivalInfo;
import org.biojava.nbio.survival.cox.SurvivalInfoHelper;
import org.biojava.nbio.survival.cox.WaldTest;
import org.biojava.nbio.survival.cox.WaldTestInfo;
import org.biojava.nbio.survival.cox.matrix.Matrix;
import org.biojava.nbio.survival.cox.stats.ChiSq;
import org.biojava.nbio.survival.cox.stats.Cholesky2;
import org.biojava.nbio.survival.data.WorkSheet;

public class CoxR {
    public CoxInfo process(ArrayList<String> variables, ArrayList<SurvivalInfo> DataT, boolean useStrata, boolean useWeighted, boolean robust, boolean cluster) throws Exception {
        int maxiter2 = 20;
        double eps2 = 1.0E-9;
        double toler2 = Math.pow(eps2, 0.75);
        int doscale2 = 1;
        double[] beta = new double[variables.size()];
        return this.process(variables, DataT, maxiter2, CoxMethod.Efron, eps2, toler2, beta, doscale2, useStrata, useWeighted, robust, cluster);
    }

    public CoxInfo process(ArrayList<String> variables, ArrayList<SurvivalInfo> data, int maxiter, CoxMethod method, double eps, double toler, double[] beta, int doscale, boolean useStrata, boolean useWeighted, boolean robust, boolean cluster) throws Exception {
        double d2;
        double wtave;
        int k;
        double temp2;
        double risk;
        double zbeta;
        double efronwt;
        double deadwt;
        int ndead;
        double dtime;
        double temp;
        int person;
        SurvivalInfoHelper.categorizeData(data);
        for (String variable : variables) {
            if (variable.indexOf(":") == -1) continue;
            String[] d = variable.split(":");
            SurvivalInfoHelper.addInteraction(d[0], d[1], data);
        }
        Collections.sort(data);
        CoxInfo coxInfo = new CoxInfo();
        coxInfo.setSurvivalInfoList(data);
        boolean gotofinish = false;
        double denom = 0.0;
        double newlk = 0.0;
        int nrisk = 0;
        int flag = 0;
        int iter = 0;
        int nused = data.size();
        int nvar = variables.size();
        double[][] imat = new double[nvar][nvar];
        double[] a = new double[nvar];
        double[] newbeta = new double[nvar];
        double[] a2 = new double[nvar];
        double[] scale = new double[nvar];
        double[][] cmat = new double[nvar][nvar];
        double[][] cmat2 = new double[nvar][nvar];
        double[] means = new double[nvar];
        double[] sd = new double[nvar];
        double[] u = new double[nvar];
        double[] loglik = new double[2];
        double[] time = new double[nused];
        int[] status = new int[nused];
        double[] offset = new double[nused];
        double[] weights = new double[nused];
        int[] strata = new int[nused];
        double[][] covar = new double[nvar][nused];
        ArrayList<String> clusterList = null;
        if (cluster) {
            clusterList = new ArrayList<String>();
        }
        for (person = 0; person < nused; ++person) {
            SurvivalInfo si = data.get(person);
            time[person] = si.getTime();
            status[person] = si.getStatus();
            offset[person] = si.getOffset();
            if (cluster) {
                if (si.getClusterValue() == null && si.getClusterValue().length() == 0) {
                    throw new Exception("Cluster value is not valid for " + si.toString());
                }
                clusterList.add(si.getClusterValue());
            }
            weights[person] = useWeighted ? si.getWeight() : 1.0;
            strata[person] = useStrata ? si.getStrata() : 0;
            for (int i = 0; i < variables.size(); ++i) {
                String variable = variables.get(i);
                covar[i][person] = si.getVariable(variable);
            }
        }
        double tempsd = 0.0;
        int i = 0;
        for (i = 0; i < nvar; ++i) {
            temp = 0.0;
            tempsd = 0.0;
            for (person = 0; person < nused; ++person) {
                temp += covar[i][person];
                tempsd += covar[i][person] * covar[i][person];
            }
            means[i] = temp /= (double)nused;
            tempsd /= (double)nused;
            sd[i] = tempsd = Math.sqrt(tempsd - temp * temp);
            person = 0;
            while (person < nused) {
                double[] dArray = covar[i];
                int n = person++;
                dArray[n] = dArray[n] - temp;
            }
            if (doscale != 1) continue;
            temp = 0.0;
            for (person = 0; person < nused; ++person) {
                temp += Math.abs(covar[i][person]);
            }
            temp = temp > 0.0 ? (double)nused / temp : 1.0;
            scale[i] = temp;
            person = 0;
            while (person < nused) {
                double[] dArray = covar[i];
                int n = person++;
                dArray[n] = dArray[n] * temp;
            }
        }
        if (doscale == 1) {
            for (i = 0; i < nvar; ++i) {
                int n = i;
                beta[n] = beta[n] / scale[i];
            }
        } else {
            for (i = 0; i < nvar; ++i) {
                scale[i] = 1.0;
            }
        }
        strata[nused - 1] = 1;
        loglik[1] = 0.0;
        for (i = 0; i < nvar; ++i) {
            u[i] = 0.0;
            a2[i] = 0.0;
            for (int j = 0; j < nvar; ++j) {
                imat[i][j] = 0.0;
                cmat2[i][j] = 0.0;
            }
        }
        person = nused - 1;
        while (person >= 0) {
            int j;
            if (strata[person] == 1) {
                nrisk = 0;
                denom = 0.0;
                for (i = 0; i < nvar; ++i) {
                    a[i] = 0.0;
                    for (j = 0; j < nvar; ++j) {
                        cmat[i][j] = 0.0;
                    }
                }
            }
            dtime = time[person];
            ndead = 0;
            deadwt = 0.0;
            efronwt = 0.0;
            while (person >= 0 && time[person] == dtime) {
                ++nrisk;
                zbeta = offset[person];
                for (i = 0; i < nvar; ++i) {
                    zbeta += beta[i] * covar[i][person];
                }
                zbeta = this.coxsafe(zbeta);
                risk = Math.exp(zbeta) * weights[person];
                denom += risk;
                for (i = 0; i < nvar; ++i) {
                    int n = i;
                    a[n] = a[n] + risk * covar[i][person];
                    for (j = 0; j <= i; ++j) {
                        double[] dArray = cmat[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + risk * covar[i][person] * covar[j][person];
                    }
                }
                if (status[person] == 1) {
                    ++ndead;
                    deadwt += weights[person];
                    efronwt += risk;
                    loglik[1] = loglik[1] + weights[person] * zbeta;
                    for (i = 0; i < nvar; ++i) {
                        int n = i;
                        u[n] = u[n] + weights[person] * covar[i][person];
                    }
                    if (method == CoxMethod.Efron) {
                        for (i = 0; i < nvar; ++i) {
                            int n = i;
                            a2[n] = a2[n] + risk * covar[i][person];
                            for (j = 0; j <= i; ++j) {
                                double[] dArray = cmat2[i];
                                int n3 = j;
                                dArray[n3] = dArray[n3] + risk * covar[i][person] * covar[j][person];
                            }
                        }
                    }
                }
                if (--person < 0 || strata[person] != 1) continue;
            }
            if (ndead <= 0) continue;
            if (method == CoxMethod.Breslow) {
                loglik[1] = loglik[1] - deadwt * Math.log(denom);
                for (i = 0; i < nvar; ++i) {
                    temp2 = a[i] / denom;
                    int n = i;
                    u[n] = u[n] - deadwt * temp2;
                    for (j = 0; j <= i; ++j) {
                        double[] dArray = imat[j];
                        int n4 = i;
                        dArray[n4] = dArray[n4] + deadwt * (cmat[i][j] - temp2 * a[j]) / denom;
                    }
                }
                continue;
            }
            for (k = 0; k < ndead; ++k) {
                temp = (double)k / (double)ndead;
                wtave = deadwt / (double)ndead;
                d2 = denom - temp * efronwt;
                loglik[1] = loglik[1] - wtave * Math.log(d2);
                for (i = 0; i < nvar; ++i) {
                    temp2 = (a[i] - temp * a2[i]) / d2;
                    int n = i;
                    u[n] = u[n] - wtave * temp2;
                    for (j = 0; j <= i; ++j) {
                        double[] dArray = imat[j];
                        int n5 = i;
                        dArray[n5] = dArray[n5] + wtave / d2 * (cmat[i][j] - temp * cmat2[i][j] - temp2 * (a[j] - temp * a2[j]));
                    }
                }
            }
            for (i = 0; i < nvar; ++i) {
                a2[i] = 0.0;
                for (j = 0; j < nvar; ++j) {
                    cmat2[i][j] = 0.0;
                }
            }
        }
        loglik[0] = loglik[1];
        for (i = 0; i < nvar; ++i) {
            a[i] = u[i];
        }
        flag = Cholesky2.process(imat, nvar, toler);
        this.chsolve2(imat, nvar, a);
        temp = 0.0;
        for (i = 0; i < nvar; ++i) {
            temp += u[i] * a[i];
        }
        double sctest = temp;
        for (i = 0; i < nvar; ++i) {
            newbeta[i] = beta[i] + a[i];
        }
        if (maxiter == 0) {
            this.chinv2(imat, nvar);
            for (i = 0; i < nvar; ++i) {
                int n = i;
                beta[n] = beta[n] * scale[i];
                int n6 = i;
                u[n6] = u[n6] / scale[i];
                double[] dArray = imat[i];
                int n7 = i;
                dArray[n7] = dArray[n7] * (scale[i] * scale[i]);
                for (int j = 0; j < i; ++j) {
                    double[] dArray2 = imat[j];
                    int n8 = i;
                    dArray2[n8] = dArray2[n8] * (scale[i] * scale[j]);
                    imat[i][j] = imat[j][i];
                }
            }
            gotofinish = true;
        }
        if (!gotofinish) {
            boolean halving = false;
            for (iter = 1; iter <= maxiter; ++iter) {
                int j;
                newlk = 0.0;
                for (i = 0; i < nvar; ++i) {
                    u[i] = 0.0;
                    for (j = 0; j < nvar; ++j) {
                        imat[i][j] = 0.0;
                    }
                }
                person = nused - 1;
                while (person >= 0) {
                    if (strata[person] == 1) {
                        denom = 0.0;
                        nrisk = 0;
                        for (i = 0; i < nvar; ++i) {
                            a[i] = 0.0;
                            for (j = 0; j < nvar; ++j) {
                                cmat[i][j] = 0.0;
                            }
                        }
                    }
                    dtime = time[person];
                    deadwt = 0.0;
                    ndead = 0;
                    efronwt = 0.0;
                    while (person >= 0 && time[person] == dtime) {
                        ++nrisk;
                        zbeta = offset[person];
                        for (i = 0; i < nvar; ++i) {
                            zbeta += newbeta[i] * covar[i][person];
                        }
                        zbeta = this.coxsafe(zbeta);
                        risk = Math.exp(zbeta) * weights[person];
                        denom += risk;
                        for (i = 0; i < nvar; ++i) {
                            int n = i;
                            a[n] = a[n] + risk * covar[i][person];
                            for (j = 0; j <= i; ++j) {
                                double[] dArray = cmat[i];
                                int n9 = j;
                                dArray[n9] = dArray[n9] + risk * covar[i][person] * covar[j][person];
                            }
                        }
                        if (status[person] == 1) {
                            ++ndead;
                            deadwt += weights[person];
                            newlk += weights[person] * zbeta;
                            for (i = 0; i < nvar; ++i) {
                                int n = i;
                                u[n] = u[n] + weights[person] * covar[i][person];
                            }
                            if (method == CoxMethod.Efron) {
                                efronwt += risk;
                                for (i = 0; i < nvar; ++i) {
                                    int n = i;
                                    a2[n] = a2[n] + risk * covar[i][person];
                                    for (j = 0; j <= i; ++j) {
                                        double[] dArray = cmat2[i];
                                        int n10 = j;
                                        dArray[n10] = dArray[n10] + risk * covar[i][person] * covar[j][person];
                                    }
                                }
                            }
                        }
                        if (--person < 0 || strata[person] != 1) continue;
                    }
                    if (ndead <= 0) continue;
                    if (method == CoxMethod.Breslow) {
                        newlk -= deadwt * Math.log(denom);
                        for (i = 0; i < nvar; ++i) {
                            temp2 = a[i] / denom;
                            int n = i;
                            u[n] = u[n] - deadwt * temp2;
                            for (j = 0; j <= i; ++j) {
                                double[] dArray = imat[j];
                                int n11 = i;
                                dArray[n11] = dArray[n11] + deadwt / denom * (cmat[i][j] - temp2 * a[j]);
                            }
                        }
                        continue;
                    }
                    for (k = 0; k < ndead; ++k) {
                        temp = (double)k / (double)ndead;
                        wtave = deadwt / (double)ndead;
                        d2 = denom - temp * efronwt;
                        newlk -= wtave * Math.log(d2);
                        for (i = 0; i < nvar; ++i) {
                            temp2 = (a[i] - temp * a2[i]) / d2;
                            int n = i;
                            u[n] = u[n] - wtave * temp2;
                            for (j = 0; j <= i; ++j) {
                                double[] dArray = imat[j];
                                int n12 = i;
                                dArray[n12] = dArray[n12] + wtave / d2 * (cmat[i][j] - temp * cmat2[i][j] - temp2 * (a[j] - temp * a2[j]));
                            }
                        }
                    }
                    for (i = 0; i < nvar; ++i) {
                        a2[i] = 0.0;
                        for (j = 0; j < nvar; ++j) {
                            cmat2[i][j] = 0.0;
                        }
                    }
                }
                flag = Cholesky2.process(imat, nvar, toler);
                if (Math.abs(1.0 - loglik[1] / newlk) <= eps && !halving) {
                    loglik[1] = newlk;
                    this.chinv2(imat, nvar);
                    for (i = 0; i < nvar; ++i) {
                        beta[i] = newbeta[i] * scale[i];
                        int n = i;
                        u[n] = u[n] / scale[i];
                        double[] dArray = imat[i];
                        int n13 = i;
                        dArray[n13] = dArray[n13] * (scale[i] * scale[i]);
                        for (int j2 = 0; j2 < i; ++j2) {
                            double[] dArray3 = imat[j2];
                            int n14 = i;
                            dArray3[n14] = dArray3[n14] * (scale[i] * scale[j2]);
                            imat[i][j2] = imat[j2][i];
                        }
                    }
                    gotofinish = true;
                    break;
                }
                if (iter == maxiter) break;
                if (newlk < loglik[1]) {
                    halving = true;
                    for (i = 0; i < nvar; ++i) {
                        newbeta[i] = (newbeta[i] + beta[i]) / 2.0;
                    }
                    continue;
                }
                halving = false;
                loglik[1] = newlk;
                this.chsolve2(imat, nvar, u);
                j = 0;
                for (i = 0; i < nvar; ++i) {
                    beta[i] = newbeta[i];
                    newbeta[i] = newbeta[i] + u[i];
                }
            }
        }
        if (!gotofinish) {
            loglik[1] = newlk;
            this.chinv2(imat, nvar);
            for (i = 0; i < nvar; ++i) {
                beta[i] = newbeta[i] * scale[i];
                int n = i;
                u[n] = u[n] / scale[i];
                double[] dArray = imat[i];
                int n15 = i;
                dArray[n15] = dArray[n15] * (scale[i] * scale[i]);
                for (int j = 0; j < i; ++j) {
                    double[] dArray4 = imat[j];
                    int n16 = i;
                    dArray4[n16] = dArray4[n16] * (scale[i] * scale[j]);
                    imat[i][j] = imat[j][i];
                }
            }
            flag = 1000;
        }
        coxInfo.setScoreLogrankTest(sctest);
        coxInfo.setDegreeFreedom(beta.length);
        coxInfo.setScoreLogrankTestpvalue(ChiSq.chiSq(coxInfo.getScoreLogrankTest(), beta.length));
        coxInfo.setVariance(imat);
        coxInfo.u = u;
        for (int n = 0; n < beta.length; ++n) {
            CoxCoefficient coe = new CoxCoefficient();
            coe.name = variables.get(n);
            coe.mean = means[n];
            coe.standardDeviation = sd[n];
            coe.coeff = beta[n];
            coe.stdError = Math.sqrt(imat[n][n]);
            coe.hazardRatio = Math.exp(coe.getCoeff());
            coe.z = coe.getCoeff() / coe.getStdError();
            coe.pvalue = ChiSq.norm(Math.abs(coe.getCoeff() / coe.getStdError()));
            double z = 1.959964;
            coe.hazardRatioLoCI = Math.exp(coe.getCoeff() - z * coe.getStdError());
            coe.hazardRatioHiCI = Math.exp(coe.getCoeff() + z * coe.getStdError());
            coxInfo.setCoefficient(coe.getName(), coe);
        }
        coxInfo.maxIterations = maxiter;
        coxInfo.eps = eps;
        coxInfo.toler = toler;
        coxInfo.iterations = iter;
        coxInfo.flag = flag;
        coxInfo.loglikInit = loglik[0];
        coxInfo.loglikFinal = loglik[1];
        coxInfo.method = method;
        this.coxphfitSCleanup(coxInfo, useWeighted, robust, clusterList);
        return coxInfo;
    }

    public void coxphfitSCleanup(CoxInfo ci, boolean useWeighted, boolean robust, ArrayList<String> cluster) throws Exception {
        double[][] du = new double[1][ci.u.length];
        du[0] = ci.u;
        double[] infs = Matrix.abs(Matrix.multiply(ci.u, ci.getVariance()));
        ArrayList<CoxCoefficient> coxCoefficients = new ArrayList<CoxCoefficient>(ci.getCoefficientsList().values());
        for (int i = 0; i < infs.length; ++i) {
            double inf = infs[i];
            double coe = coxCoefficients.get(i).getCoeff();
            if (!(inf > ci.eps) || !(inf > ci.toler * Math.abs(coe))) continue;
            ci.message = "Loglik converged before variable ";
        }
        double sumcoefmeans = 0.0;
        for (CoxCoefficient cc : coxCoefficients) {
            sumcoefmeans += cc.getCoeff() * cc.getMean();
        }
        for (SurvivalInfo si : ci.survivalInfoList) {
            double offset = si.getOffset();
            double lp = 0.0;
            for (CoxCoefficient cc : coxCoefficients) {
                String name = cc.getName();
                double coef = cc.getCoeff();
                double value = si.getVariable(name);
                lp += value * coef;
            }
            lp = lp + offset - sumcoefmeans;
            si.setLinearPredictor(lp);
            si.setScore(Math.exp(lp));
        }
        double[] res = CoxMart.process(ci.method, ci.survivalInfoList, false);
        for (int i = 0; i < ci.survivalInfoList.size(); ++i) {
            SurvivalInfo si = ci.survivalInfoList.get(i);
            si.setResidual(res[i]);
        }
        if (robust) {
            double[][] temp0;
            int i;
            double[] tempscore;
            double[] templp;
            double[][] temp;
            ci.setNaiveVariance(ci.getVariance());
            if (cluster != null) {
                temp = ResidualsCoxph.process(ci, ResidualsCoxph.Type.dfbeta, useWeighted, cluster);
                templp = new double[ci.survivalInfoList.size()];
                tempscore = new double[ci.survivalInfoList.size()];
                i = 0;
                for (SurvivalInfo si : ci.survivalInfoList) {
                    templp[i] = si.getLinearPredictor();
                    tempscore[i] = si.getScore();
                    si.setLinearPredictor(0.0);
                    si.setScore(1.0);
                    ++i;
                }
                temp0 = ResidualsCoxph.process(ci, ResidualsCoxph.Type.score, useWeighted, cluster);
                i = 0;
                for (SurvivalInfo si : ci.survivalInfoList) {
                    si.setLinearPredictor(templp[i]);
                    si.setScore(tempscore[i]);
                    ++i;
                }
            } else {
                temp = ResidualsCoxph.process(ci, ResidualsCoxph.Type.dfbeta, useWeighted, null);
                templp = new double[ci.survivalInfoList.size()];
                tempscore = new double[ci.survivalInfoList.size()];
                i = 0;
                for (SurvivalInfo si : ci.survivalInfoList) {
                    templp[i] = si.getLinearPredictor();
                    tempscore[i] = si.getScore();
                    si.setLinearPredictor(0.0);
                    si.setScore(1.0);
                }
                temp0 = ResidualsCoxph.process(ci, ResidualsCoxph.Type.score, useWeighted, null);
                i = 0;
                for (SurvivalInfo si : ci.survivalInfoList) {
                    si.setLinearPredictor(templp[i]);
                    si.setScore(tempscore[i]);
                    ++i;
                }
            }
            double[][] ttemp = Matrix.transpose(temp);
            double[][] var = Matrix.multiply(ttemp, temp);
            ci.setVariance(var);
            double[] u = new double[temp0[0].length];
            for (int i2 = 0; i2 < temp0[0].length; ++i2) {
                for (int j = 0; j < temp0.length; ++j) {
                    u[i2] = u[i2] + temp0[j][i2];
                }
            }
            double[][] wtemp = Matrix.multiply(Matrix.transpose(temp0), temp0);
            double toler_chol = 1.818989E-12;
            WaldTestInfo wti = WaldTest.process(wtemp, u, toler_chol);
            ci.setRscore(wti.getTest());
        }
        CoxR.calculateWaldTestInfo(ci);
    }

    public static void calculateWaldTestInfo(CoxInfo ci) {
        if (ci.getNumberCoefficients() > 0) {
            double toler_chol = 1.818989E-12;
            double[][] b = new double[1][ci.getNumberCoefficients()];
            int i = 0;
            for (CoxCoefficient coe : ci.getCoefficientsList().values()) {
                b[0][i] = coe.getCoeff();
                ++i;
            }
            ci.setWaldTestInfo(WaldTest.process(ci.getVariance(), b, toler_chol));
        }
    }

    public static void main(String[] args) {
        CoxR coxr = new CoxR();
        try {
            InputStream is = coxr.getClass().getClassLoader().getResourceAsStream("uis-complete.txt");
            WorkSheet worksheet = WorkSheet.readCSV(is, '\t');
            ArrayList<SurvivalInfo> survivalInfoList = new ArrayList<SurvivalInfo>();
            int i = 0;
            for (String row : worksheet.getRows()) {
                double time = worksheet.getCellDouble(row, "TIME");
                double age = worksheet.getCellDouble(row, "AGE");
                double treat = worksheet.getCellDouble(row, "TREAT");
                double c = worksheet.getCellDouble(row, "CENSOR");
                int censor = (int)c;
                SurvivalInfo si = new SurvivalInfo(time, censor);
                si.setOrder(i);
                si.addContinuousVariable("AGE", age);
                si.addContinuousVariable("TREAT", treat);
                survivalInfoList.add(si);
                ++i;
            }
            CoxR cox = new CoxR();
            ArrayList<String> variables = new ArrayList<String>();
            variables.add("AGE");
            variables.add("TREAT");
            CoxInfo ci = cox.process(variables, survivalInfoList, false, true, false, false);
            System.out.println(ci);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void chinv2(double[][] matrix, int n) {
        int k;
        int j;
        int i;
        for (i = 0; i < n; ++i) {
            if (!(matrix[i][i] > 0.0)) continue;
            matrix[i][i] = 1.0 / matrix[i][i];
            for (j = i + 1; j < n; ++j) {
                matrix[j][i] = -matrix[j][i];
                for (k = 0; k < i; ++k) {
                    double[] dArray = matrix[j];
                    int n2 = k;
                    dArray[n2] = dArray[n2] + matrix[j][i] * matrix[i][k];
                }
            }
        }
        for (i = 0; i < n; ++i) {
            if (matrix[i][i] == 0.0) {
                for (j = 0; j < i; ++j) {
                    matrix[j][i] = 0.0;
                }
                for (j = i; j < n; ++j) {
                    matrix[i][j] = 0.0;
                }
                continue;
            }
            for (j = i + 1; j < n; ++j) {
                double temp = matrix[j][i] * matrix[j][j];
                if (j != i) {
                    matrix[i][j] = temp;
                }
                for (k = i; k < j; ++k) {
                    double[] dArray = matrix[i];
                    int n3 = k;
                    dArray[n3] = dArray[n3] + temp * matrix[j][k];
                }
            }
        }
    }

    void chsolve2(double[][] matrix, int n, double[] y) {
        int j;
        double temp;
        int i;
        for (i = 0; i < n; ++i) {
            temp = y[i];
            for (j = 0; j < i; ++j) {
                temp -= y[j] * matrix[i][j];
            }
            y[i] = temp;
        }
        for (i = n - 1; i >= 0; --i) {
            if (matrix[i][i] == 0.0) {
                y[i] = 0.0;
                continue;
            }
            temp = y[i] / matrix[i][i];
            for (j = i + 1; j < n; ++j) {
                temp -= y[j] * matrix[j][i];
            }
            y[i] = temp;
        }
    }

    public double coxsafe(double x) {
        if (x < -200.0) {
            return -200.0;
        }
        if (x > 22.0) {
            return 22.0;
        }
        return x;
    }
}

