/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.cox;

import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import org.biojava.nbio.survival.cox.CoxInfo;

public class CoxVariables {
    private String cohortName = "";
    private String geneSet = "";
    private String genes = "";
    private LinkedHashMap<String, CoxInfo> coxInfoHashMap = new LinkedHashMap();

    public CoxVariables(String cohortName, String geneSet, String genes) {
        this.cohortName = cohortName;
        this.geneSet = geneSet;
        this.genes = genes;
    }

    public int getUniqueID() {
        String link = this.geneSet + "_" + this.cohortName;
        return link.hashCode();
    }

    public void putCoxInfo(String name, CoxInfo coxInfo) {
        this.coxInfoHashMap.put(name, coxInfo);
    }

    public CoxInfo getCoxInfo(String name) {
        return this.coxInfoHashMap.get(name);
    }

    public String encodeFileURL(String file) {
        file = file.replaceAll(" ", "%20");
        file = file.replaceAll("<", "%3C");
        file = file.replaceAll(">", "%3E");
        return file;
    }

    public static String fmt(Double d, int precision, int pad) {
        String value = "";
        DecimalFormat dfe = new DecimalFormat("0.00E0");
        String dpad = "0.";
        double p = 1.0;
        for (int i = 0; i < precision; ++i) {
            dpad = dpad + "0";
            p /= 10.0;
        }
        DecimalFormat df = new DecimalFormat(dpad);
        value = Math.abs(d) >= p ? df.format(d) : dfe.format(d);
        int length = value.length();
        int extra = pad - length;
        if (extra > 0) {
            for (int i = 0; i < extra; ++i) {
                value = " " + value;
            }
        }
        return value;
    }

    public String toString() {
        String coxOutput = this.geneSet + "\r\n";
        coxOutput = coxOutput + this.cohortName + "," + this.genes.replace(',', ' ') + "\r\n";
        coxOutput = coxOutput + ",Coe,StdErr,p-value,HR,HR Lo 95%,HR Hi 95%\r\n";
        for (String variables : this.coxInfoHashMap.keySet()) {
            CoxInfo ci = this.coxInfoHashMap.get(variables);
            coxOutput = coxOutput + "Overall Model Fit p-value=" + CoxVariables.fmt(ci.getOverallModelFitPvalue(), 5, 0) + "\r\n";
            coxOutput = coxOutput + ci.getCoefficientText(false, "", ",", "", "");
            coxOutput = coxOutput + "\r\n";
        }
        return coxOutput;
    }

    public String getCohortName() {
        return this.cohortName;
    }

    public String getGeneSet() {
        return this.geneSet;
    }

    public String getGenes() {
        return this.genes;
    }

    public LinkedHashMap<String, CoxInfo> getCoxInfoHashMap() {
        return this.coxInfoHashMap;
    }
}

