/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.cox.comparators;

import org.biojava.nbio.survival.cox.CoxInfo;
import org.biojava.nbio.survival.cox.CoxVariables;
import org.biojava.nbio.survival.cox.comparators.CoxComparatorInterface;

public class CoxVariablesVariableComparator
implements CoxComparatorInterface {
    String variables = "";
    String variable = "";
    String description = "Signatures ranked by p-value ";

    public CoxVariablesVariableComparator(String variables, String variable) {
        this.variables = variables;
        this.variable = variable;
        this.description = "Signatures ranked by model " + variables + " and variable " + variable + " p-value";
    }

    @Override
    public int compare(CoxVariables coxVariables1, CoxVariables coxVariables2) {
        if (coxVariables1.equals(coxVariables2)) {
            return 0;
        }
        CoxInfo ci1 = coxVariables1.getCoxInfo(this.variables);
        CoxInfo ci2 = coxVariables2.getCoxInfo(this.variables);
        if (ci1 == null && ci2 == null) {
            return 0;
        }
        if (ci1 == null && ci2 != null) {
            return 1;
        }
        if (ci2 == null && ci1 != null) {
            return -1;
        }
        if (ci1.getCoefficientsList().get(this.variable).getPvalue() < ci2.getCoefficientsList().get(this.variable).getPvalue()) {
            return -1;
        }
        if (ci1.getCoefficientsList().get(this.variable).getPvalue() > ci2.getCoefficientsList().get(this.variable).getPvalue()) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getModelVariables() {
        return this.variables;
    }

    @Override
    public String getSortVariable() {
        return this.variable;
    }
}

