/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.cox.stats;

import java.util.ArrayList;
import org.biojava.nbio.survival.cox.CoxInfo;
import org.biojava.nbio.survival.cox.CoxMethod;
import org.biojava.nbio.survival.cox.SurvivalInfo;

public class AgScore {
    public static double[][] process(CoxMethod method, ArrayList<SurvivalInfo> survivalInfoList, CoxInfo coxInfo, boolean useStrata) {
        int n = survivalInfoList.size();
        ArrayList<String> variables = new ArrayList<String>(coxInfo.getCoefficientsList().keySet());
        int nvar = variables.size();
        double[] event = new double[n];
        double[] start = new double[n];
        double[] stop = new double[n];
        double[] strata = new double[n];
        double[] weights = new double[n];
        double[] score = new double[n];
        double[] a = new double[nvar];
        double[] a2 = new double[nvar];
        double[] mean = new double[nvar];
        double[] mh1 = new double[nvar];
        double[] mh2 = new double[nvar];
        double[] mh3 = new double[nvar];
        double denom = 0.0;
        double time = 0.0;
        double e_denom = 0.0;
        double meanwt = 0.0;
        double deaths = 0.0;
        double[][] covar = new double[nvar][n];
        double[][] resid = new double[nvar][n];
        int person = 0;
        for (int p = 0; p < n; ++p) {
            SurvivalInfo si = survivalInfoList.get(p);
            stop[p] = si.getTime();
            event[p] = si.getStatus();
            strata[p] = useStrata ? (double)si.getStrata() : 0.0;
            weights[p] = si.getWeight();
            score[p] = si.getScore();
            for (int v = 0; v < variables.size(); ++v) {
                String variable = variables.get(v);
                Double value = si.getVariable(variable);
                covar[v][p] = value;
            }
        }
        person = 0;
        block2: while (person < n) {
            double hazard;
            double risk;
            int k;
            int i;
            if (event[person] == 0.0) {
                ++person;
                continue;
            }
            denom = 0.0;
            e_denom = 0.0;
            meanwt = 0.0;
            deaths = 0.0;
            for (i = 0; i < nvar; ++i) {
                a[i] = 0.0;
                a2[i] = 0.0;
            }
            time = stop[person];
            for (k = person; k < n; ++k) {
                if (start[k] < time) {
                    risk = score[k] * weights[k];
                    denom += risk;
                    for (i = 0; i < nvar; ++i) {
                        a[i] = a[i] + risk * covar[i][k];
                    }
                    if (stop[k] == time && event[k] == 1.0) {
                        deaths += 1.0;
                        e_denom += risk;
                        meanwt += weights[k];
                        for (i = 0; i < nvar; ++i) {
                            a2[i] = a2[i] + risk * covar[i][k];
                        }
                    }
                }
                if (strata[k] == 1.0) break;
            }
            if (deaths < 2.0 || method == CoxMethod.Breslow) {
                hazard = meanwt / denom;
                for (i = 0; i < nvar; ++i) {
                    mean[i] = a[i] / denom;
                }
                for (k = person; k < n; ++k) {
                    if (start[k] < time) {
                        risk = score[k];
                        for (i = 0; i < nvar; ++i) {
                            double[] dArray = resid[i];
                            int n2 = k;
                            dArray[n2] = dArray[n2] - (covar[i][k] - mean[i]) * risk * hazard;
                        }
                        if (stop[k] == time) {
                            ++person;
                            if (event[k] == 1.0) {
                                for (i = 0; i < nvar; ++i) {
                                    double[] dArray = resid[i];
                                    int n3 = k;
                                    dArray[n3] = dArray[n3] + (covar[i][k] - mean[i]);
                                }
                            }
                        }
                    }
                    if (strata[k] == 1.0) continue block2;
                }
                continue;
            }
            double temp1 = 0.0;
            double temp2 = 0.0;
            for (i = 0; i < nvar; ++i) {
                mh1[i] = 0.0;
                mh2[i] = 0.0;
                mh3[i] = 0.0;
            }
            meanwt /= deaths;
            int dd = 0;
            while ((double)dd < deaths) {
                double downwt = (double)dd / deaths;
                double d2 = denom - downwt * e_denom;
                hazard = meanwt / d2;
                temp1 += hazard;
                temp2 += (1.0 - downwt) * hazard;
                for (i = 0; i < nvar; ++i) {
                    mean[i] = (a[i] - downwt * a2[i]) / d2;
                    int n4 = i;
                    mh1[n4] = mh1[n4] + mean[i] * hazard;
                    int n5 = i;
                    mh2[n5] = mh2[n5] + mean[i] * (1.0 - downwt) * hazard;
                    int n6 = i;
                    mh3[n6] = mh3[n6] + mean[i] / deaths;
                }
                ++dd;
            }
            for (k = person; k < n; ++k) {
                if (start[k] < time) {
                    risk = score[k];
                    if (stop[k] == time && event[k] == 1.0) {
                        for (i = 0; i < nvar; ++i) {
                            double[] dArray = resid[i];
                            int n7 = k;
                            dArray[n7] = dArray[n7] + (covar[i][k] - mh3[i]);
                            double[] dArray2 = resid[i];
                            int n8 = k;
                            dArray2[n8] = dArray2[n8] - risk * covar[i][k] * temp2;
                            double[] dArray3 = resid[i];
                            int n9 = k;
                            dArray3[n9] = dArray3[n9] + risk * mh2[i];
                        }
                    } else {
                        for (i = 0; i < nvar; ++i) {
                            double[] dArray = resid[i];
                            int n10 = k;
                            dArray[n10] = dArray[n10] - risk * (covar[i][k] * temp1 - mh1[i]);
                        }
                    }
                }
                if (strata[k] == 1.0) break;
            }
            while (stop[person] == time && strata[person] != 1.0) {
                ++person;
            }
        }
        double[][] flipresid = new double[n][nvar];
        for (int s = 0; s < resid.length; ++s) {
            for (int t = 0; t < resid[0].length; ++t) {
                flipresid[t][s] = resid[s][t];
            }
        }
        return flipresid;
    }

    public static void main(String[] args) {
    }
}

