/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.kaplanmeier.figure;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.biojava.nbio.survival.cox.SurvivalInfo;
import org.biojava.nbio.survival.cox.comparators.SurvivalInfoValueComparator;
import org.biojava.nbio.survival.kaplanmeier.figure.KMFigureInfo;

public class ExpressionFigure
extends JPanel {
    private static final long serialVersionUID = 1L;
    ArrayList<String> title = new ArrayList();
    public int top;
    public int bottom;
    public int left;
    public int right;
    int titleHeight;
    int xAxisLabelHeight;
    int labelWidth;
    Double maxTime = null;
    Double minX = 0.0;
    Double maxX = 10.0;
    Double minY = 0.0;
    Double maxY = 1.0;
    Double mean = 0.0;
    FontMetrics fm;
    KMFigureInfo kmfi = new KMFigureInfo();
    ArrayList<String> lineInfoList = new ArrayList();
    ArrayList<SurvivalInfo> siList = new ArrayList();
    String variable = "";
    private String fileName = "";
    DecimalFormat df = new DecimalFormat("#.#");

    public ExpressionFigure() {
        this.setSize(500, 400);
        this.setBackground(Color.WHITE);
    }

    public ArrayList<SurvivalInfo> getSurvivalInfoList() {
        return this.siList;
    }

    public void setKMFigureInfo(KMFigureInfo kmfi) {
        this.kmfi = kmfi;
        if (kmfi.width != null && kmfi.height != null) {
            this.setSize(kmfi.width, kmfi.height);
        }
    }

    public void setFigureLineInfo(ArrayList<String> lineInfoList) {
        this.lineInfoList = lineInfoList;
        this.repaint();
    }

    public void setSurvivalInfo(ArrayList<String> title, ArrayList<SurvivalInfo> _siList, String variable) {
        this.siList = new ArrayList();
        this.title = title;
        this.variable = variable;
        this.minX = 0.0;
        this.maxX = _siList.size();
        this.minY = 0.0;
        this.maxY = null;
        DescriptiveStatistics ds = new DescriptiveStatistics();
        for (SurvivalInfo si : _siList) {
            this.siList.add(si);
            String v = si.getOriginalMetaData(variable);
            Double value = Double.parseDouble(v);
            ds.addValue(value.doubleValue());
            if (this.maxTime != null && !(this.maxTime < si.getTime())) continue;
            this.maxTime = si.getTime();
        }
        SurvivalInfoValueComparator sivc = new SurvivalInfoValueComparator(variable);
        Collections.sort(this.siList, sivc);
        this.mean = ds.getMean();
        this.minY = ds.getMin();
        this.maxY = ds.getMax();
        this.minY = Math.floor(this.minY);
        this.maxY = Math.ceil(this.maxY);
        this.repaint();
    }

    private void setRenderingHints(Graphics2D g) {
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        rh.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        rh.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        rh.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHints(rh);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.setFigureDimensions();
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.setRenderingHints(g2);
        this.drawExpressionLevels(g);
        this.drawFigureLineInfo(g);
        this.drawLegend(g);
    }

    private void drawFigureLineInfo(Graphics g) {
        g.setColor(Color.BLACK);
        Font font = g.getFont();
        Font f = new Font(font.getFontName(), 1, font.getSize());
        g.setFont(f);
        this.fm = this.getFontMetrics(this.getFont());
        int yoffset = this.fm.getHeight() * this.lineInfoList.size();
        int x = this.getX(this.kmfi.figureLineInfoLowerPercentX * this.maxX);
        int y = this.getY(this.kmfi.figureLineInfoLowerPercentY) - yoffset;
        for (String line : this.lineInfoList) {
            g.drawString(line, x, y);
            y += this.fm.getHeight();
        }
    }

    private void drawExpressionLevels(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(this.kmfi.kmStroke);
        g2.setColor(Color.blue);
        Double py = null;
        for (int x = 0; x < this.siList.size(); ++x) {
            SurvivalInfo si = this.siList.get(x);
            String v = si.getOriginalMetaData(this.variable);
            Double y = Double.parseDouble(v);
            if (si.getStatus() == 1) {
                g2.setColor(Color.RED);
            } else {
                g2.setColor(Color.LIGHT_GRAY);
            }
            g2.drawLine(this.getX(x), this.getY(this.maxY - this.minY), this.getX(x), this.getY(this.maxY - y));
            if (py == null) {
                py = y;
            }
            if (this.mean >= py && this.mean <= y) {
                g2.setColor(Color.green);
                g2.drawLine(this.getX(x), this.getY(this.maxY - this.minY), this.getX(x), this.getY(this.maxY - y));
                g2.drawLine(this.getX(x - 1), this.getY(this.maxY - this.minY), this.getX(x - 1), this.getY(this.maxY - y));
            }
            py = y;
        }
    }

    private int getX(double value) {
        double d = (double)this.left + (double)(this.right - this.left) * value / (this.maxX - this.minX);
        return (int)d;
    }

    private int getY(double value) {
        double d = (double)this.top + (double)(this.bottom - this.top) * value / (this.maxY - this.minY);
        return (int)d;
    }

    public String getFileName() {
        return this.fileName;
    }

    private void drawLegend(Graphics g) {
        double adjustedPercentIncrement;
        double d;
        Graphics2D g2 = (Graphics2D)g;
        Font font = g2.getFont();
        font = new Font(font.getFontName(), 1, font.getSize());
        g2.setFont(font);
        this.fm = this.getFontMetrics(font);
        int fontHeight = this.fm.getHeight();
        for (int i = 0; i < this.title.size(); ++i) {
            if ((double)this.fm.stringWidth(this.title.get(i)) > 0.8 * (double)this.getWidth()) {
                Font f = new Font(font.getFontName(), 1, 10);
                g2.setFont(f);
                this.fm = this.getFontMetrics(f);
            }
            g2.drawString(this.title.get(i), (this.getSize().width - this.fm.stringWidth(this.title.get(i))) / 2, (i + 1) * fontHeight);
            g2.setFont(font);
        }
        g2.drawString(this.df.format(this.minY), this.left - this.fm.stringWidth(this.df.format(this.minY)) - 20, this.bottom + this.titleHeight / 6);
        g2.drawLine(this.left - 5, this.bottom, this.left, this.bottom);
        double ySize = this.maxY - this.minY;
        double increment = this.kmfi.yaxisPercentIncrement * ySize;
        increment = Math.ceil(increment);
        String label = "";
        for (d = this.minY + increment; d < this.maxY; d += increment) {
            int yvalue = this.getY(this.maxY - d);
            label = this.df.format(d);
            g2.drawString(label, this.left - this.fm.stringWidth(label) - 20, yvalue + this.titleHeight / 6);
            g2.drawLine(this.left - 5, yvalue, this.left, yvalue);
        }
        label = this.df.format(this.maxY);
        g2.drawString(label, this.left - this.fm.stringWidth(label) - 20, this.top + this.titleHeight / 6);
        g2.drawLine(this.left - 5, this.top, this.left, this.top);
        double timeDistance = this.maxX - this.minX;
        double timeIncrement = timeDistance * this.kmfi.xaxisPercentIncrement;
        double timeInt = (int)timeIncrement;
        if (timeInt < 1.0) {
            timeInt = 1.0;
        }
        for (d = adjustedPercentIncrement = timeInt / timeDistance; d <= 1.0; d += adjustedPercentIncrement) {
            label = this.df.format(this.minX * this.kmfi.timeScale + d * ((this.maxX - this.minX) * this.kmfi.timeScale));
            if (d + adjustedPercentIncrement > 1.0) {
                g2.drawString(label, this.left + (int)(d * (double)(this.right - this.left)) - (int)(0.5 * (double)this.fm.stringWidth(label)), this.bottom + this.fm.getHeight() + 5);
            } else {
                g2.drawString(label, this.left + (int)(d * (double)(this.right - this.left)) - this.fm.stringWidth(label) / 2, this.bottom + this.fm.getHeight() + 5);
            }
            g2.drawLine(this.left + (int)(d * (double)(this.right - this.left)), this.bottom, this.left + (int)(d * (double)(this.right - this.left)), this.bottom + 5);
        }
        g2.setStroke(this.kmfi.axisStroke);
        g2.drawLine(this.left, this.top, this.left, this.bottom);
        g2.drawLine(this.left, this.bottom, this.right, this.bottom);
    }

    private void setFigureDimensions() {
        this.fm = this.getFontMetrics(this.getFont());
        this.xAxisLabelHeight = this.titleHeight = this.kmfi.titleHeight;
        this.labelWidth = Math.max(this.fm.stringWidth(this.df.format(this.minY)), this.fm.stringWidth(this.df.format(this.maxY))) + 5;
        this.top = this.kmfi.padding + this.titleHeight;
        this.bottom = this.getHeight() - this.kmfi.padding - this.xAxisLabelHeight;
        this.left = this.kmfi.padding + this.labelWidth;
        this.right = this.getWidth() - this.kmfi.padding;
    }

    public void savePNG(String fileName) {
        if (fileName.startsWith("null")) {
            return;
        }
        this.fileName = fileName;
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D graphics2D = image.createGraphics();
        this.paint(graphics2D);
        try {
            ImageIO.write((RenderedImage)image, "png", new File(fileName));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            ExpressionFigure expressionFigure = new ExpressionFigure();
            JFrame application = new JFrame();
            application.setDefaultCloseOperation(3);
            application.add(expressionFigure);
            expressionFigure.setSize(500, 400);
            application.setSize(500, 400);
            application.setVisible(true);
            ArrayList<String> titles = new ArrayList<String>();
            titles.add("Line 1");
            titles.add("line 2");
            ArrayList<String> figureInfo = new ArrayList<String>();
            ArrayList<SurvivalInfo> survivalInfoList = new ArrayList<SurvivalInfo>();
            for (int i = 0; i < 600; ++i) {
                double r = Math.random();
                double v = r * 10000.0;
                double t = Math.random() * 5.0;
                r = Math.random();
                int e = 0;
                if (r < 0.3) {
                    e = 1;
                }
                SurvivalInfo si = new SurvivalInfo(t, e);
                si.addContinuousVariable("META_GENE", v);
                survivalInfoList.add(si);
            }
            expressionFigure.setSurvivalInfo(titles, survivalInfoList, "META_GENE");
            expressionFigure.setFigureLineInfo(figureInfo);
            expressionFigure.savePNG("/Users/Scooter/Downloads/test.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

