/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.cox;

import java.util.ArrayList;
import org.biojava.nbio.survival.cox.CoxCC;
import org.biojava.nbio.survival.cox.CoxInfo;
import org.biojava.nbio.survival.cox.CoxR;
import org.biojava.nbio.survival.cox.SurvivalInfo;
import org.biojava.nbio.survival.data.WorkSheet;

public class CoxHelper {
    public static CoxInfo process(String datafile, String timeColumn, String statusColumn, String weightColumn, String strataColumn, String clusterColumn, ArrayList<String> variables, boolean useStrata, boolean useWeights) throws Exception {
        WorkSheet worksheet = WorkSheet.readCSV(datafile, '\t');
        return CoxHelper.process(worksheet, timeColumn, statusColumn, weightColumn, strataColumn, clusterColumn, variables, useStrata, useWeights);
    }

    public static CoxInfo process(WorkSheet worksheet, String timeColumn, String statusColumn, String weightColumn, String strataColumn, String clusterColumn, ArrayList<String> variables, boolean useStrata, boolean useWeights) {
        try {
            ArrayList<SurvivalInfo> survivalInfoList = new ArrayList<SurvivalInfo>();
            int i = 1;
            for (String row : worksheet.getRows()) {
                double time = worksheet.getCellDouble(row, timeColumn);
                double c = worksheet.getCellDouble(row, statusColumn);
                double weight = 1.0;
                if (weightColumn != null && weightColumn.length() > 0) {
                    weight = worksheet.getCellDouble(row, weightColumn);
                }
                int strata = 0;
                if (strataColumn != null && strataColumn.length() > 0) {
                    strata = worksheet.getCellDouble(row, strataColumn).intValue();
                }
                int censor = (int)c;
                if (weight <= 0.0) {
                    ++i;
                    continue;
                }
                SurvivalInfo si = new SurvivalInfo(time, censor);
                si.setOrder(i);
                si.setWeight(weight);
                si.setStrata(strata);
                for (String column : variables) {
                    if (column.contains(":")) continue;
                    String value = worksheet.getCell(row, column);
                    si.addUnknownDataTypeVariable(column, value);
                }
                if (clusterColumn != null && clusterColumn.length() > 0) {
                    String v = worksheet.getCell(row, clusterColumn);
                    si.setClusterValue(v);
                }
                survivalInfoList.add(si);
                ++i;
            }
            boolean cluster = false;
            boolean robust = false;
            if (clusterColumn != null && clusterColumn.length() > 0) {
                cluster = true;
                robust = true;
            }
            CoxR cox = new CoxR();
            CoxInfo ci = cox.process(variables, survivalInfoList, useStrata, useWeights, robust, cluster);
            return ci;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            String datafile = "/Users/Scooter/scripps/ngs/DataSets/E2197/misc/ecoglabtransfer/500790/2013.05.10.12.28.58.313/clindasl0228.txt";
            ArrayList<String> variables = new ArrayList<String>();
            variables.add("nndpos");
            variables.add("meno");
            CoxInfo ci = CoxHelper.process(datafile, "ttr", "recind", "wt", "sstrat", "Seq", variables, false, true);
            System.out.println(ci);
            System.out.println();
            CoxCC.process(ci);
            ci.dump();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

