/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.data;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.biojava.nbio.survival.data.ChangeValue;
import org.biojava.nbio.survival.data.CompactCharSequence;
import org.biojava.nbio.survival.data.HeaderInfo;

public class WorkSheet {
    private LinkedHashMap<String, HeaderInfo> columnLookup = new LinkedHashMap();
    private LinkedHashMap<String, HeaderInfo> rowLookup = new LinkedHashMap();
    private CompactCharSequence[][] data = new CompactCharSequence[1][1];
    HashMap<String, String> dataGrid = new HashMap();
    private String indexColumnName = "";
    private LinkedHashMap<String, String> metaDataColumnsHashMap = new LinkedHashMap();
    private LinkedHashMap<String, String> metaDataRowsHashMap = new LinkedHashMap();
    HashMap<String, Double> doubleValues = new HashMap();
    boolean cacheDoubleValues = false;
    private String rowHeader = "REF";

    public WorkSheet() {
    }

    public WorkSheet(Collection<String> rows, Collection<String> columns) throws Exception {
        int i = 1;
        for (String row : rows) {
            if (this.rowLookup.containsKey(row)) {
                throw new Exception("Duplicate row " + row);
            }
            this.rowLookup.put(row, new HeaderInfo(i));
            ++i;
        }
        i = 1;
        for (String col : columns) {
            if (this.columnLookup.containsKey(col)) {
                throw new Exception("Duplicate row " + col);
            }
            this.columnLookup.put(col, new HeaderInfo(i));
            ++i;
        }
        this.data = new CompactCharSequence[this.rowLookup.size() + 1][this.columnLookup.size() + 1];
    }

    public WorkSheet(String[][] values) {
        int i;
        String[] columns = new String[values[0].length];
        for (i = 0; i < columns.length; ++i) {
            columns[i] = new String(values[0][i].getBytes());
        }
        for (i = 1; i < columns.length; ++i) {
            this.columnLookup.put(columns[i], new HeaderInfo(i));
        }
        for (i = 1; i < values.length; ++i) {
            String row = new String(values[i][0].getBytes());
            this.rowLookup.put(row, new HeaderInfo(i));
        }
        this.data = new CompactCharSequence[values.length][values[0].length];
        for (int row = 0; row < values.length; ++row) {
            for (int col = 0; col < values[0].length; ++col) {
                String value = values[row][col];
                this.data[row][col] = new CompactCharSequence(value);
                values[row][col] = null;
            }
            System.out.println("Row " + row + " " + Runtime.getRuntime().totalMemory());
        }
        values = null;
        System.gc();
    }

    public void clear() {
        this.columnLookup.clear();
        this.rowLookup.clear();
        this.data = null;
        this.dataGrid.clear();
        this.doubleValues.clear();
        System.gc();
    }

    public String toString() {
        return super.toString();
    }

    public void randomlyDivideSave(double percentage, String fileName1, String fileName2) throws Exception {
        int i;
        ArrayList<String> rows = this.getDataRows();
        Collections.shuffle(rows);
        int portion = (int)((double)rows.size() * percentage);
        for (i = 0; i < portion; ++i) {
            this.hideRow(rows.get(i), true);
        }
        this.saveTXT(fileName2);
        for (i = 0; i < portion; ++i) {
            this.hideRow(rows.get(i), false);
        }
        for (i = portion; i < rows.size(); ++i) {
            this.hideRow(rows.get(i), true);
        }
        this.saveTXT(fileName1);
        for (i = portion; i < rows.size(); ++i) {
            this.hideRow(rows.get(i), false);
        }
    }

    public static WorkSheet getCopyWorkSheetSelectedRows(WorkSheet copyWorkSheet, ArrayList<String> rows) throws Exception {
        ArrayList<String> columns = copyWorkSheet.getColumns();
        WorkSheet workSheet = new WorkSheet(rows, columns);
        for (String row : rows) {
            for (String col : columns) {
                workSheet.addCell(row, col, copyWorkSheet.getCell(row, col));
            }
        }
        workSheet.setMetaDataColumns(copyWorkSheet.getMetaDataColumns());
        workSheet.setMetaDataRows(copyWorkSheet.getMetaDataRows());
        return workSheet;
    }

    public static WorkSheet getCopyWorkSheet(WorkSheet copyWorkSheet) throws Exception {
        ArrayList<String> rows = copyWorkSheet.getRows();
        ArrayList<String> columns = copyWorkSheet.getColumns();
        WorkSheet workSheet = new WorkSheet(rows, columns);
        for (String row : rows) {
            for (String col : columns) {
                workSheet.addCell(row, col, copyWorkSheet.getCell(row, col));
            }
        }
        workSheet.setMetaDataColumns(copyWorkSheet.getMetaDataColumns());
        workSheet.setMetaDataRows(copyWorkSheet.getMetaDataRows());
        return workSheet;
    }

    public WorkSheet(CompactCharSequence[][] values) {
        int i;
        String[] columns = new String[values[0].length];
        for (i = 0; i < columns.length; ++i) {
            columns[i] = values[0][i].toString();
        }
        this.setIndexColumnName(columns[0]);
        for (i = 1; i < columns.length; ++i) {
            this.columnLookup.put(columns[i], new HeaderInfo(i));
        }
        for (i = 1; i < values.length; ++i) {
            String row = values[i][0].toString();
            this.rowLookup.put(row, new HeaderInfo(i));
        }
        this.data = values;
    }

    public ArrayList<String> getMetaDataColumns() {
        ArrayList<String> metaColumns = new ArrayList<String>();
        for (String key : this.metaDataColumnsHashMap.keySet()) {
            HeaderInfo hi = this.columnLookup.get(key);
            if (hi.isHide()) continue;
            metaColumns.add(key);
        }
        return metaColumns;
    }

    public ArrayList<String> getMetaDataRows() {
        ArrayList<String> metaRows = new ArrayList<String>();
        for (String key : this.metaDataRowsHashMap.keySet()) {
            HeaderInfo hi = this.rowLookup.get(key);
            if (hi.isHide()) continue;
            metaRows.add(key);
        }
        return metaRows;
    }

    public ArrayList<String> getDataColumns() {
        ArrayList<String> dataColumns = new ArrayList<String>();
        ArrayList<String> columns = this.getColumns();
        for (String column : columns) {
            if (this.metaDataColumnsHashMap.containsKey(column)) continue;
            dataColumns.add(column);
        }
        return dataColumns;
    }

    public void shuffleColumnsAndThenRows(ArrayList<String> columns, ArrayList<String> rows) throws Exception {
        String value;
        String temp;
        int randomIndex;
        int i;
        this.doubleValues.clear();
        for (String column : columns) {
            ArrayList<Integer> rowIndex = new ArrayList<Integer>();
            for (i = 0; i < rows.size(); ++i) {
                rowIndex.add(i);
            }
            Collections.shuffle(rowIndex);
            for (i = 0; i < rows.size(); ++i) {
                String row = rows.get(i);
                randomIndex = (Integer)rowIndex.get(i);
                String destinationRow = rows.get(randomIndex);
                temp = this.getCell(destinationRow, column);
                value = this.getCell(row, column);
                this.addCell(destinationRow, column, value);
                this.addCell(row, column, temp);
            }
        }
        for (String row : rows) {
            ArrayList<Integer> columnIndex = new ArrayList<Integer>();
            for (i = 0; i < columns.size(); ++i) {
                columnIndex.add(i);
            }
            Collections.shuffle(columnIndex);
            for (i = 0; i < columns.size(); ++i) {
                String column = columns.get(i);
                randomIndex = (Integer)columnIndex.get(i);
                String destinationCol = columns.get(randomIndex);
                temp = this.getCell(row, destinationCol);
                value = this.getCell(row, column);
                this.addCell(row, destinationCol, value);
                this.addCell(row, column, temp);
            }
        }
    }

    public void shuffleColumnValues(ArrayList<String> columns) throws Exception {
        this.doubleValues.clear();
        ArrayList<String> rows = this.getDataRows();
        for (String column : columns) {
            int i;
            ArrayList<Integer> rowIndex = new ArrayList<Integer>();
            for (i = 0; i < rows.size(); ++i) {
                rowIndex.add(i);
            }
            Collections.shuffle(rowIndex);
            for (i = 0; i < rows.size(); ++i) {
                String row = rows.get(i);
                int randomIndex = (Integer)rowIndex.get(i);
                String destinationRow = rows.get(randomIndex);
                String temp = this.getCell(destinationRow, column);
                String value = this.getCell(row, column);
                this.addCell(destinationRow, column, value);
                this.addCell(row, column, temp);
            }
        }
    }

    public void shuffleRowValues(ArrayList<String> rows) throws Exception {
        this.doubleValues.clear();
        ArrayList<String> columns = this.getColumns();
        for (String row : rows) {
            int i;
            ArrayList<Integer> columnIndex = new ArrayList<Integer>();
            for (i = 0; i < columns.size(); ++i) {
                columnIndex.add(i);
            }
            Collections.shuffle(columnIndex);
            for (i = 0; i < columns.size(); ++i) {
                String column = columns.get(i);
                int randomIndex = (Integer)columnIndex.get(i);
                String destinationCol = columns.get(randomIndex);
                String temp = this.getCell(row, destinationCol);
                String value = this.getCell(row, column);
                this.addCell(row, destinationCol, value);
                this.addCell(row, column, temp);
            }
        }
    }

    public void hideMetaDataColumns(boolean value) {
        ArrayList<String> metadataColumns = this.getMetaDataColumns();
        for (String column : metadataColumns) {
            this.hideColumn(column, value);
        }
    }

    public void hideMetaDataRows(boolean value) {
        ArrayList<String> metadataRows = this.getMetaDataRows();
        for (String row : metadataRows) {
            this.hideRow(row, value);
        }
    }

    public void setMetaDataRowsAfterRow() {
        this.setMetaDataRowsAfterRow("META_DATA");
    }

    public void setMetaDataColumnsAfterColumn() {
        this.setMetaDataColumnsAfterColumn("META_DATA");
    }

    public void setMetaDataRowsAfterRow(String row) {
        ArrayList<String> rows = this.getRows();
        boolean metarow = false;
        for (String r : rows) {
            if (r.equals(row) && !metarow) {
                metarow = true;
            }
            if (!metarow) continue;
            this.markMetaDataRow(r);
        }
    }

    public void setMetaDataColumnsAfterColumn(String column) {
        ArrayList<String> cols = this.getColumns();
        boolean metacolumns = false;
        for (String col : cols) {
            if (col.equals(column) && !metacolumns) {
                metacolumns = true;
            }
            if (!metacolumns) continue;
            this.markMetaDataColumn(col);
        }
    }

    public void setMetaDataColumns(ArrayList<String> metaDataColumns) {
        this.metaDataColumnsHashMap.clear();
        this.markMetaDataColumns(metaDataColumns);
    }

    public void markMetaDataColumns(ArrayList<String> metaDataColumns) {
        for (String column : metaDataColumns) {
            this.metaDataColumnsHashMap.put(column, column);
        }
    }

    public void markMetaDataColumn(String column) {
        this.metaDataColumnsHashMap.put(column, column);
    }

    public boolean isMetaDataColumn(String column) {
        return this.metaDataColumnsHashMap.get(column) != null;
    }

    public boolean isMetaDataRow(String row) {
        return this.metaDataRowsHashMap.get(row) != null;
    }

    public void markMetaDataRow(String row) {
        this.metaDataRowsHashMap.put(row, row);
    }

    public void setMetaDataRows(ArrayList<String> metaDataRows) {
        this.metaDataRowsHashMap.clear();
        for (String row : metaDataRows) {
            this.metaDataRowsHashMap.put(row, row);
        }
    }

    public void hideEmptyRows() throws Exception {
        ArrayList<String> rows = this.getDataRows();
        ArrayList<String> columns = this.getDataColumns();
        for (String row : rows) {
            boolean emptyRow = true;
            for (String column : columns) {
                String value = this.getCell(row, column).trim();
                if (value.length() <= 0) continue;
                emptyRow = false;
                break;
            }
            if (!emptyRow) continue;
            this.hideRow(row, true);
        }
    }

    public void hideEmptyColumns() throws Exception {
        ArrayList<String> rows = this.getDataRows();
        ArrayList<String> columns = this.getDataColumns();
        for (String column : columns) {
            boolean emptyColumn = true;
            for (String row : rows) {
                String value = this.getCell(row, column).trim();
                if (value.length() <= 0) continue;
                emptyColumn = false;
                break;
            }
            if (!emptyColumn) continue;
            this.hideColumn(column, true);
        }
    }

    public void hideRow(String row, boolean hide) {
        HeaderInfo rowInfo = this.rowLookup.get(row);
        rowInfo.setHide(hide);
    }

    public void hideColumn(String column, boolean hide) {
        HeaderInfo colInfo = this.columnLookup.get(column);
        colInfo.setHide(hide);
    }

    public void replaceColumnValues(String column, HashMap<String, String> values) throws Exception {
        for (String row : this.rowLookup.keySet()) {
            String oldValue = this.getCell(row, column);
            String newValue = values.get(oldValue);
            this.addCell(row, column, newValue);
        }
    }

    public void applyColumnFilter(String column, ChangeValue changeValue) throws Exception {
        for (String row : this.rowLookup.keySet()) {
            String oldValue = this.getCell(row, column);
            String newValue = changeValue.change(oldValue);
            this.addCell(row, column, newValue);
        }
    }

    public void addColumn(String column, String defaultValue) {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add(column);
        this.addColumns(columns, defaultValue);
    }

    public void addColumns(ArrayList<String> columns, String defaultValue) {
        CompactCharSequence dv = new CompactCharSequence(defaultValue);
        for (int i = 0; i < this.data.length; ++i) {
            int c;
            CompactCharSequence[] row = this.data[i];
            int oldrowlength = this.data[i].length;
            this.data[i] = (CompactCharSequence[])WorkSheet.resizeArray(row, oldrowlength + columns.size());
            for (c = 0; c < columns.size(); ++c) {
                this.data[i][oldrowlength + c] = dv;
            }
            if (i != 0) continue;
            for (c = 0; c < columns.size(); ++c) {
                String column = columns.get(c);
                this.data[0][oldrowlength + c] = new CompactCharSequence(column);
                this.columnLookup.put(column, new HeaderInfo(oldrowlength + c));
            }
        }
    }

    public void addRow(String row, String defaultValue) {
        ArrayList<String> rows = new ArrayList<String>();
        rows.add(row);
        this.addRows(rows, defaultValue);
    }

    public void addRows(ArrayList<String> rows, String defaultValue) {
        CompactCharSequence dv = new CompactCharSequence(defaultValue);
        int oldlength = this.data.length;
        int numColumns = 0;
        if (this.data.length > 0 && this.data[0] != null) {
            numColumns = this.data[0].length;
        }
        this.data = (CompactCharSequence[][])WorkSheet.resizeArray(this.data, this.data.length + rows.size());
        for (int r = 0; r < rows.size(); ++r) {
            this.data[oldlength + r] = new CompactCharSequence[numColumns];
            for (int c = 0; c < numColumns; ++c) {
                this.data[oldlength + r][c] = dv;
            }
            this.data[oldlength + r][0] = new CompactCharSequence(rows.get(r));
            this.rowLookup.put(rows.get(r), new HeaderInfo(r + oldlength));
        }
    }

    private static Object resizeArray(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        Class<?> elementType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    public void addCell(String row, String col, String value) throws Exception {
        HeaderInfo rowIndex = this.rowLookup.get(row);
        HeaderInfo colIndex = this.columnLookup.get(col);
        if (rowIndex == null) {
            throw new Exception("Row " + row + " not found in worksheet");
        }
        if (colIndex == null) {
            throw new Exception("Column " + col + " not found in worksheet");
        }
        this.data[rowIndex.getIndex().intValue()][colIndex.getIndex().intValue()] = new CompactCharSequence(value);
    }

    public boolean isValidRow(String row) {
        HeaderInfo rowIndex = this.rowLookup.get(row);
        if (rowIndex == null) {
            for (String rowtable : this.rowLookup.keySet()) {
                if (!row.equalsIgnoreCase(rowtable)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isValidColumn(String col) {
        HeaderInfo colIndex = this.columnLookup.get(col);
        if (colIndex == null) {
            for (String coltable : this.columnLookup.keySet()) {
                if (!col.equalsIgnoreCase(coltable)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void setCacheDoubleValues(boolean value) {
        this.cacheDoubleValues = value;
    }

    public Double getCellDouble(String row, String col) throws Exception {
        if (this.cacheDoubleValues) {
            String key = row + ":" + col;
            Double v = this.doubleValues.get(key);
            if (v != null) {
                return v;
            }
            String value = this.getCell(row, col);
            try {
                v = Double.parseDouble(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.doubleValues.put(key, v);
            return v;
        }
        Double v = null;
        String value = this.getCell(row, col);
        try {
            v = Double.parseDouble(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public String getCell(String row, String col) throws Exception {
        CompactCharSequence ccs;
        if (col.equals(this.getIndexColumnName())) {
            return row;
        }
        HeaderInfo rowIndex = this.rowLookup.get(row);
        HeaderInfo colIndex = this.columnLookup.get(col);
        if (rowIndex == null) {
            for (String rowtable : this.rowLookup.keySet()) {
                if (!row.equalsIgnoreCase(rowtable)) continue;
                rowIndex = this.rowLookup.get(rowtable);
                break;
            }
            if (rowIndex == null) {
                throw new Exception("Row " + row + " not found in worksheet");
            }
        }
        if (colIndex == null) {
            for (String coltable : this.columnLookup.keySet()) {
                if (!col.equalsIgnoreCase(coltable)) continue;
                colIndex = this.columnLookup.get(coltable);
                break;
            }
            if (colIndex == null) {
                throw new Exception("Column " + col + " not found in worksheet");
            }
        }
        if ((ccs = this.data[rowIndex.getIndex()][colIndex.getIndex()]) != null) {
            return ccs.toString();
        }
        return "";
    }

    public void changeRowHeader(ChangeValue changeValue) {
        ArrayList<String> rows = new ArrayList<String>(this.rowLookup.keySet());
        for (String row : rows) {
            String newRow = changeValue.change(row);
            HeaderInfo value = this.rowLookup.get(row);
            this.rowLookup.remove(row);
            this.rowLookup.put(newRow, value);
        }
    }

    public void changeColumnHeader(ChangeValue changeValue) {
        ArrayList<String> columns = new ArrayList<String>(this.columnLookup.keySet());
        for (String col : columns) {
            String newCol = changeValue.change(col);
            HeaderInfo value = this.columnLookup.get(col);
            this.columnLookup.remove(col);
            this.columnLookup.put(newCol, value);
        }
    }

    public void changeRowHeader(String row, String newRow) throws Exception {
        HeaderInfo value = this.rowLookup.get(row);
        if (value == null) {
            throw new Exception("Row not found " + row);
        }
        this.rowLookup.remove(row);
        this.rowLookup.put(newRow, value);
        if (this.isMetaDataRow(row)) {
            this.metaDataRowsHashMap.remove(row);
            this.metaDataRowsHashMap.put(newRow, newRow);
        }
    }

    public void changeColumnsHeaders(LinkedHashMap<String, String> newColumnValues) throws Exception {
        for (String oldColumn : newColumnValues.keySet()) {
            String newColumn = newColumnValues.get(oldColumn);
            this.changeColumnHeader(oldColumn, newColumn);
        }
    }

    public void changeColumnHeader(String col, String newCol) throws Exception {
        HeaderInfo value = this.columnLookup.get(col);
        if (value == null) {
            throw new Exception("Column not found " + col);
        }
        this.columnLookup.remove(col);
        this.columnLookup.put(newCol, value);
        if (this.isMetaDataColumn(col)) {
            this.metaDataColumnsHashMap.remove(col);
            this.metaDataColumnsHashMap.put(newCol, newCol);
        }
    }

    public Integer getColumnIndex(String column) throws Exception {
        HeaderInfo headerInfo = this.columnLookup.get(column);
        if (headerInfo == null) {
            throw new Exception("Column " + column + " not found");
        }
        return headerInfo.getIndex();
    }

    public Integer getRowIndex(String row) throws Exception {
        HeaderInfo headerInfo = this.rowLookup.get(row);
        if (headerInfo == null) {
            throw new Exception("Row " + row + " not found");
        }
        return headerInfo.getIndex();
    }

    public ArrayList<String> getRandomDataColumns(int number) {
        ArrayList<String> columns = this.getDataColumns();
        return this.getRandomDataColumns(number, columns);
    }

    public ArrayList<String> getRandomDataColumns(int number, ArrayList<String> columns) {
        ArrayList<String> randomColumns = new ArrayList<String>();
        HashMap<String, String> picked = new HashMap<String, String>();
        while (picked.size() < number) {
            double v = Math.random();
            int index = (int)(v * (double)columns.size());
            if (picked.containsKey(String.valueOf(index))) continue;
            picked.put(String.valueOf(index), String.valueOf(index));
            randomColumns.add(columns.get(index));
        }
        return randomColumns;
    }

    public ArrayList<String> getAllColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        for (String col : this.columnLookup.keySet()) {
            columns.add(col);
        }
        return columns;
    }

    public ArrayList<String> getColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        for (String col : this.columnLookup.keySet()) {
            HeaderInfo hi = this.columnLookup.get(col);
            if (hi.isHide()) continue;
            columns.add(col);
        }
        return columns;
    }

    public ArrayList<String> getDiscreteColumnValues(String column) throws Exception {
        HashMap<String, String> hashMapValues = new HashMap<String, String>();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> rows = this.getDataRows();
        for (String row : rows) {
            String value = this.getCell(row, column);
            if (hashMapValues.containsKey(value)) continue;
            hashMapValues.put(value, value);
            values.add(value);
        }
        return values;
    }

    public ArrayList<String> getDiscreteRowValues(String row) throws Exception {
        HashMap<String, String> hashMapValues = new HashMap<String, String>();
        ArrayList<String> values = new ArrayList<String>();
        for (String column : this.getColumns()) {
            String value = this.getCell(row, column);
            if (hashMapValues.containsKey(value)) continue;
            hashMapValues.put(value, value);
            values.add(value);
        }
        return values;
    }

    public ArrayList<String> getAllRows() {
        ArrayList<String> rows = new ArrayList<String>();
        for (String row : this.rowLookup.keySet()) {
            rows.add(row);
        }
        return rows;
    }

    public ArrayList<String> getRows() {
        ArrayList<String> rows = new ArrayList<String>();
        for (String row : this.rowLookup.keySet()) {
            HeaderInfo hi = this.rowLookup.get(row);
            if (hi.isHide()) continue;
            rows.add(row);
        }
        return rows;
    }

    public ArrayList<String> getDataRows() {
        ArrayList<String> rows = new ArrayList<String>();
        for (String row : this.rowLookup.keySet()) {
            HeaderInfo hi;
            if (this.isMetaDataRow(row) || (hi = this.rowLookup.get(row)).isHide()) continue;
            rows.add(row);
        }
        return rows;
    }

    public WorkSheet getLogScale(double base) throws Exception {
        return this.getLogScale(base, 0.1);
    }

    public WorkSheet getLogScale(double base, double zeroValue) throws Exception {
        WorkSheet workSheet = new WorkSheet(this.getRows(), this.getColumns());
        workSheet.setIndexColumnName(this.getIndexColumnName());
        ArrayList<String> rows = this.getRows();
        ArrayList<String> columns = this.getColumns();
        for (String row : rows) {
            for (String col : columns) {
                String value;
                if (this.isMetaDataColumn(col) || this.isMetaDataRow(row)) {
                    value = this.getCell(row, col);
                    workSheet.addCell(row, col, value);
                    continue;
                }
                value = this.getCell(row, col);
                try {
                    Double d = Double.parseDouble(value);
                    d = d == 0.0 ? Double.valueOf(zeroValue) : Double.valueOf(Math.log(d) / Math.log(base));
                    workSheet.addCell(row, col, d + "");
                }
                catch (Exception e) {
                    workSheet.addCell(row, col, value);
                }
            }
        }
        ArrayList<String> metadataRows = this.getMetaDataRows();
        ArrayList<String> metadataColumns = this.getMetaDataColumns();
        workSheet.setMetaDataColumns(metadataColumns);
        workSheet.setMetaDataRows(metadataRows);
        return workSheet;
    }

    public WorkSheet swapRowAndColumns() throws Exception {
        WorkSheet swappedWorkSheet = new WorkSheet(this.getColumns(), this.getRows());
        for (String row : this.getRows()) {
            for (String col : this.getColumns()) {
                String value = this.getCell(row, col);
                swappedWorkSheet.addCell(col, row, value);
            }
        }
        ArrayList<String> metadataRows = this.getMetaDataRows();
        ArrayList<String> metadataColumns = this.getMetaDataColumns();
        swappedWorkSheet.setMetaDataColumns(metadataRows);
        swappedWorkSheet.setMetaDataRows(metadataColumns);
        return swappedWorkSheet;
    }

    static CompactCharSequence[][] getAllValuesCompactCharSequence(File fileName, char delimiter) throws Exception {
        FileInputStream fi = new FileInputStream(fileName);
        return WorkSheet.getAllValuesCompactCharSequence(fi, delimiter);
    }

    static CompactCharSequence[][] getAllValuesCompactCharSequence(InputStream is, char delimiter) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        ArrayList<CompactCharSequence[]> rows = new ArrayList<CompactCharSequence[]>();
        String line = br.readLine();
        int numcolumns = -1;
        while (line != null) {
            String[] d = line.split(String.valueOf(delimiter));
            if (numcolumns == -1) {
                numcolumns = d.length;
            }
            CompactCharSequence[] ccs = new CompactCharSequence[d.length];
            for (int i = 0; i < d.length; ++i) {
                ccs[i] = new CompactCharSequence(d[i]);
            }
            rows.add(ccs);
            line = br.readLine();
        }
        br.close();
        CompactCharSequence[][] data = new CompactCharSequence[rows.size()][numcolumns];
        for (int i = 0; i < rows.size(); ++i) {
            CompactCharSequence[] row = (CompactCharSequence[])rows.get(i);
            for (int j = 0; j < row.length; ++j) {
                if (row[j].length() > 1 && row[j].charAt(0) == '\"') {
                    row[j] = row[j].length() > 2 ? new CompactCharSequence(row[j].subSequence(1, row[j].length() - 1).toString()) : new CompactCharSequence("");
                }
                if (j >= row.length || j >= data[0].length) continue;
                data[i][j] = row[j];
            }
        }
        return data;
    }

    static String[][] getAllValues(String fileName, char delimiter) throws Exception {
        FileReader reader = new FileReader(fileName);
        BufferedReader br = new BufferedReader(reader);
        ArrayList<String[]> rows = new ArrayList<String[]>();
        String line = br.readLine();
        int numcolumns = -1;
        while (line != null) {
            String[] d = line.split(String.valueOf(delimiter));
            if (numcolumns == -1) {
                numcolumns = d.length;
            }
            rows.add(d);
            line = br.readLine();
        }
        br.close();
        reader.close();
        String[][] data = new String[rows.size()][numcolumns];
        for (int i = 0; i < rows.size(); ++i) {
            String[] row = (String[])rows.get(i);
            for (int j = 0; j < row.length; ++j) {
                if (row[j].startsWith("\"") && row[j].endsWith("\"")) {
                    row[j] = row[j].substring(1, row[j].length() - 1);
                }
                data[i][j] = row[j];
            }
        }
        return data;
    }

    public static WorkSheet unionWorkSheetsRowJoin(String w1FileName, String w2FileName, char delimitter, boolean secondSheetMetaData) throws Exception {
        WorkSheet w1 = WorkSheet.readCSV(w1FileName, delimitter);
        WorkSheet w2 = WorkSheet.readCSV(w2FileName, delimitter);
        return WorkSheet.unionWorkSheetsRowJoin(w1, w2, secondSheetMetaData);
    }

    public static WorkSheet unionWorkSheetsRowJoin(WorkSheet w1, WorkSheet w2, boolean secondSheetMetaData) throws Exception {
        String value;
        ArrayList<String> w1Columns = w1.getColumns();
        ArrayList<String> w2Columns = w2.getColumns();
        ArrayList<String> w1DataColumns = w1.getDataColumns();
        ArrayList<String> w2DataColumns = w2.getDataColumns();
        ArrayList<String> w1MetaDataColumns = w1.getMetaDataColumns();
        ArrayList<String> w2MetaDataColumns = w2.getMetaDataColumns();
        if (secondSheetMetaData && !w1.getColumns().contains("META_DATA")) {
            w1DataColumns.add("META_DATA");
        }
        ArrayList<String> joinedColumns = new ArrayList<String>();
        joinedColumns.addAll(w1DataColumns);
        joinedColumns.addAll(w2DataColumns);
        if (!(joinedColumns.contains("META_DATA") || w1MetaDataColumns.size() <= 0 && w2MetaDataColumns.size() <= 0)) {
            joinedColumns.add("META_DATA");
        }
        for (String column : w1MetaDataColumns) {
            if (joinedColumns.contains(column)) continue;
            joinedColumns.add(column);
        }
        for (String column : w2MetaDataColumns) {
            if (joinedColumns.contains(column)) continue;
            joinedColumns.add(column);
        }
        ArrayList<String> w1Rows = w1.getRows();
        ArrayList<String> w2Rows = w2.getRows();
        ArrayList<String> rows = new ArrayList<String>();
        HashSet<String> w1Key = new HashSet<String>(w1Rows);
        for (String key : w2Rows) {
            if (!w1Key.contains(key)) continue;
            rows.add(key);
        }
        WorkSheet worksheet = new WorkSheet(rows, joinedColumns);
        for (String row : rows) {
            for (String column : w1Columns) {
                if (column.equals("META_DATA")) continue;
                value = w1.getCell(row, column);
                worksheet.addCell(row, column, value);
            }
        }
        for (String row : rows) {
            for (String column : w2Columns) {
                if (column.equals("META_DATA")) continue;
                value = w2.getCell(row, column);
                worksheet.addCell(row, column, value);
            }
        }
        worksheet.setMetaDataColumnsAfterColumn();
        worksheet.setMetaDataRowsAfterRow();
        return worksheet;
    }

    public static WorkSheet readCSV(String fileName, char delimiter) throws Exception {
        return WorkSheet.readCSV(new File(fileName), delimiter);
    }

    public static WorkSheet readCSV(File f, char delimiter) throws Exception {
        return WorkSheet.readCSV(new FileInputStream(f), delimiter);
    }

    public static WorkSheet readCSV(InputStream is, char delimiter) throws Exception {
        CompactCharSequence[][] data = WorkSheet.getAllValuesCompactCharSequence(is, delimiter);
        WorkSheet workSheet = new WorkSheet(data);
        workSheet.setMetaDataColumnsAfterColumn();
        workSheet.setMetaDataRowsAfterRow();
        return workSheet;
    }

    public void saveCSV(String fileName) throws Exception {
        File f = new File(fileName);
        File parentFile = f.getParentFile();
        if (!parentFile.isDirectory()) {
            parentFile.mkdirs();
        }
        FileOutputStream file = new FileOutputStream(fileName);
        BufferedOutputStream bs = new BufferedOutputStream(file);
        this.save(bs, ',', false);
        bs.close();
        file.close();
    }

    public void saveTXT(String fileName) throws Exception {
        File f = new File(fileName);
        File parentFile = f.getParentFile();
        if (!parentFile.isDirectory()) {
            parentFile.mkdirs();
        }
        FileOutputStream file = new FileOutputStream(fileName);
        BufferedOutputStream bs = new BufferedOutputStream(file);
        this.save(bs, '\t', false);
        bs.close();
        file.close();
    }

    public void setRowHeader(String value) {
        this.rowHeader = value;
    }

    public void appendWorkSheetColumns(WorkSheet worksheet) throws Exception {
        ArrayList<String> newColumns = worksheet.getColumns();
        this.addColumns(newColumns, "");
        ArrayList<String> rows = this.getRows();
        for (String row : rows) {
            for (String col : newColumns) {
                if (!worksheet.isValidRow(row)) continue;
                String value = worksheet.getCell(row, col);
                this.addCell(row, col, value);
            }
        }
    }

    public void appendWorkSheetRows(WorkSheet worksheet) throws Exception {
        ArrayList<String> newRows = worksheet.getRows();
        this.addRows(newRows, "");
        for (String col : this.getColumns()) {
            if (!worksheet.isValidColumn(col)) continue;
            for (String row : newRows) {
                if (!worksheet.isValidColumn(col)) continue;
                String value = worksheet.getCell(row, col);
                this.addCell(row, col, value);
            }
        }
    }

    public void save(OutputStream outputStream, char delimitter, boolean quoteit) throws Exception {
        outputStream.write(this.rowHeader.getBytes());
        for (String col : this.getColumns()) {
            outputStream.write(delimitter);
            if (quoteit) {
                outputStream.write(34);
            }
            outputStream.write(col.getBytes());
            if (!quoteit) continue;
            outputStream.write(34);
        }
        outputStream.write("\r\n".getBytes());
        for (String row : this.getRows()) {
            if (quoteit) {
                outputStream.write(34);
            }
            outputStream.write(row.getBytes());
            if (quoteit) {
                outputStream.write(34);
            }
            for (String col : this.getColumns()) {
                String value = this.getCell(row, col);
                outputStream.write(delimitter);
                if (!this.isMetaDataColumn(col) && !this.isMetaDataRow(row)) {
                    if (value == null || value.length() == 0 || value.equalsIgnoreCase("null")) {
                        value = "NaN";
                    }
                } else if (value == null || value.length() == 0 || value.equalsIgnoreCase("null")) {
                    value = "";
                }
                outputStream.write(value.getBytes());
            }
            outputStream.write("\r\n".getBytes());
        }
    }

    public String getIndexColumnName() {
        return this.indexColumnName;
    }

    public void setIndexColumnName(String indexColumnName) {
        this.indexColumnName = indexColumnName;
    }

    public LinkedHashMap<String, HeaderInfo> getColumnLookup() {
        return this.columnLookup;
    }

    public LinkedHashMap<String, HeaderInfo> getRowLookup() {
        return this.rowLookup;
    }

    public LinkedHashMap<String, String> getMetaDataColumnsHashMap() {
        return this.metaDataColumnsHashMap;
    }

    public LinkedHashMap<String, String> getMetaDataRowsHashMap() {
        return this.metaDataRowsHashMap;
    }

    public String getRowHeader() {
        return this.rowHeader;
    }
}

