/*
 * Decompiled with CFR 0.152.
 */
package org.birchframework.ems;

import com.tibco.tibjms.TibjmsXAQueueConnectionFactory;
import com.tibco.tibjms.TibjmsXATopicConnectionFactory;
import com.tibco.tibjms.naming.TibjmsInitialContextFactory;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.birchframework.ems.EMSProperties;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jms.JmsPoolConnectionFactoryFactory;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.listener.MessageListenerContainer;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.JndiDestinationResolver;
import org.springframework.jndi.JndiLocatorDelegate;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration(proxyBeanMethods=false)
@EnableAutoConfiguration
@ConditionalOnClass(name={"javax.jms.ConnectionFactory", "com.tibco.tibjms.TibjmsConnectionFactory"})
@ConditionalOnProperty(prefix="tibco.ems.factory", name={"url"})
@ConditionalOnMissingBean(value={ConnectionFactory.class})
@EnableConfigurationProperties(value={EMSProperties.class, JmsProperties.class})
public class EMSAutoConfiguration {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(EMSAutoConfiguration.class);
    private final @UnknownKeyFor @NonNull @Initialized EMSProperties properties;
    private final @UnknownKeyFor @NonNull @Initialized JmsProperties jmsProperties;
    private final @UnknownKeyFor @NonNull @Initialized ObjectProvider<@UnknownKeyFor @NonNull @Initialized MessageConverter> messageConverter;

    @Bean
    public @UnknownKeyFor @NonNull @Initialized JndiLocatorDelegate jndiLocatorDelegate() {
        PropertyMapper aMapper = PropertyMapper.get();
        EMSProperties.JNDI aJNDI = this.properties.getJndi();
        EMSProperties.SSL anSSL = this.properties.getSsl();
        HashMap<String, String> aMap = new HashMap<String, String>(Map.of("java.naming.factory.initial", TibjmsInitialContextFactory.class.getName(), "java.naming.provider.url", aJNDI.getUrl(), "java.naming.security.principal", aJNDI.getPrincipal(), "com.tibco.tibjms.naming.ssl_enable_verify_host", Boolean.toString(anSSL.isVerifyHost()), "com.tibco.tibjms.naming.ssl_enable_verify_hostname", Boolean.toString(anSSL.isVerifyHostname())));
        aMapper.from(aJNDI::getCredentials).whenNonNull().to(s -> aMap.put("java.naming.security.credentials", (String)s));
        aMapper.from(aJNDI::getProtocol).whenNonNull().to(s -> aMap.put("com.tibco.tibjms.naming.security_protocol", (String)s));
        aMapper.from(aJNDI::getAuthentication).whenNonNull().to(s -> aMap.put("java.naming.security.authentication", (String)s));
        aMapper.from((Object)this.properties.getFactory().getProtocol()).whenNonNull().to(s -> aMap.put("com.tibco.tibjms.naming.security_protocol", (String)s));
        Properties aProperties = new Properties(aMap.size());
        aProperties.putAll((Map<?, ?>)aMap);
        return new EMSJNDILocatorDelegate(aProperties);
    }

    protected @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> buildEMSProperties() {
        PropertyMapper aMapper = PropertyMapper.get();
        HashMap<String, String> aMap = new HashMap<String, String>(Map.of("com.tibco.tibjms.factory.username", this.properties.getFactory().getUsername()));
        aMapper.from((Object)this.properties.getFactory().getPassword()).whenNonNull().to(s -> aMap.put("com.tibco.tibjms.factory.password", (String)s));
        aMapper.from((Object)this.properties.getFactory().getProtocol()).whenNonNull().to(s -> aMap.put("com.tibco.tibjms.naming.security_protocol", (String)s));
        aMap.putAll(Map.of("com.tibco.tibjms.connect.attemptcount", Integer.toString(this.properties.getConnect().getAttemptCount()), "com.tibco.tibjms.connect.attemptdelay", Long.toString(this.properties.getConnect().getAttemptDelay().toMillis()), "com.tibco.tibjms.connect.attempttimeout", Long.toString(this.properties.getConnect().getAttemptTimeout().toMillis()), "com.tibco.tibjms.reconnect.attemptcount", Integer.toString(this.properties.getReconnect().getAttemptCount()), "com.tibco.tibjms.reconnect.attemptdelay", Long.toString(this.properties.getReconnect().getAttemptDelay().toMillis()), "com.tibco.tibjms.reconnect.attempttimeout", Long.toString(this.properties.getReconnect().getAttemptTimeout().toMillis())));
        EMSProperties.SSL anSSL = this.properties.getSsl();
        aMap.putAll(Map.of("com.tibco.tibjms.naming.ssl_enable_verify_host", Boolean.toString(anSSL.isVerifyHost()), "com.tibco.tibjms.naming.ssl_enable_verify_hostname", Boolean.toString(anSSL.isVerifyHostname()), "com.tibco.tibjms.naming.ssl_trace", Boolean.toString(anSSL.isTrace()), "com.tibco.tibjms.naming.ssl_debug_trace", Boolean.toString(anSSL.isDebugTrace()), "com.tibco.tibjms.naming.ssl_auth_only", Boolean.toString(anSSL.isAuthOnly())));
        aMapper.from(anSSL::getVendor).whenNonNull().to(s -> aMap.put("com.tibco.tibjms.naming.ssl_vendor", (String)s));
        aMapper.from(anSSL::getExpectedHostname).whenNonNull().to(s -> aMap.put("com.tibco.tibjms.naming.ssl_expected_hostname", (String)s));
        aMapper.from(anSSL::getHostnameVerifier).whenNonNull().to(s -> aMap.put("com.tibco.tibjms.naming.ssl_hostname_verifier", (String)s));
        aMapper.from(anSSL::getIdentity).whenNonNull().to(s -> aMap.put("com.tibco.tibjms.naming.ssl_identity", (String)s));
        aMapper.from(anSSL::getIdentityEncoding).whenNonNull().to(s -> aMap.put("com.tibco.tibjms.naming.ssl_identity_encoding", (String)s));
        aMapper.from(anSSL::getPassword).whenNonNull().to(s -> aMap.put("com.tibco.tibjms.naming.ssl_password", (String)s));
        aMapper.from(anSSL::getIssuerCertificates).whenNonNull().to(s -> aMap.put("com.tibco.tibjms.naming.ssl_issuer_certs", (String)s));
        aMapper.from(anSSL::getTrustedCertificates).whenNonNull().to(s -> aMap.put("com.tibco.tibjms.naming.ssl_trusted_certs", (String)s));
        aMapper.from(anSSL::getPrivateKey).whenNonNull().to(s -> aMap.put("com.tibco.tibjms.naming.ssl_private_key", (String)s));
        aMapper.from(anSSL::getPrivateKeyEncoding).whenNonNull().to(s -> aMap.put("com.tibco.tibjms.naming.ssl_private_key_encoding", (String)s));
        aMapper.from(anSSL::getCipherSuites).whenNonNull().to(s -> aMap.put("com.tibco.tibjms.naming.ssl_cipher_suites", (String)s));
        return aMap;
    }

    @Bean
    @ConditionalOnMissingBean(value={JmsPoolConnectionFactoryFactory.class})
    @ConditionalOnProperty(prefix="tibco.ems.pool", name={"enabled"})
    protected @UnknownKeyFor @NonNull @Initialized JmsPoolConnectionFactoryFactory jmsPoolConnectionFactoryFactory() {
        return new JmsPoolConnectionFactoryFactory(this.properties.getPool());
    }

    @Bean
    @ConditionalOnMissingBean(value={QueueConnectionFactory.class})
    @ConditionalOnProperty(prefix="tibco.ems", name={"queue-connection-factory-name"})
    protected @UnknownKeyFor @NonNull @Initialized QueueConnectionFactory pooledQueueConnectionFactory(@UnknownKeyFor @NonNull @Initialized JmsPoolConnectionFactoryFactory theFactoryFactory) {
        Map<String, String> aMap = this.buildEMSProperties();
        String aURL = this.properties.getFactory().getUrl();
        QueueConnectionFactoryAdapter aConnectionFactory = new QueueConnectionFactoryAdapter((QueueConnectionFactory)theFactoryFactory.createPooledConnectionFactory((ConnectionFactory)new TibjmsXAQueueConnectionFactory(aURL, null, aMap)));
        log.info("Created {} for URL: {} and properties {}", new Object[]{aConnectionFactory.getClass().getName(), aURL, aMap.toString()});
        return aConnectionFactory;
    }

    @Bean
    @ConditionalOnMissingBean(value={TopicConnectionFactory.class})
    @ConditionalOnProperty(prefix="tibco.ems", name={"topic-connection-factory-name"})
    protected @UnknownKeyFor @NonNull @Initialized TopicConnectionFactory pooledTopicConnectionFactory(@UnknownKeyFor @NonNull @Initialized JmsPoolConnectionFactoryFactory theFactoryFactory) {
        Map<String, String> aMap = this.buildEMSProperties();
        String aURL = this.properties.getFactory().getUrl();
        TopicConnectionFactoryAdapter aConnectionFactory = new TopicConnectionFactoryAdapter((TopicConnectionFactory)theFactoryFactory.createPooledConnectionFactory((ConnectionFactory)new TibjmsXATopicConnectionFactory(aURL, null, aMap)));
        log.info("Created {} for URL: {} and properties {}", new Object[]{aConnectionFactory.getClass().getName(), aURL, aMap.toString()});
        return aConnectionFactory;
    }

    @Bean
    @ConditionalOnMissingBean(value={QueueConnectionFactory.class})
    @ConditionalOnExpression(value="'${tibco.ems.queue-connection-factory-name}' != null and !'${tibco.ems.pool.enabled}'")
    protected @UnknownKeyFor @NonNull @Initialized QueueConnectionFactory queueConnectionFactory() {
        Map<String, String> aMap = this.buildEMSProperties();
        String aURL = this.properties.getFactory().getUrl();
        QueueConnectionFactoryAdapter aConnectionFactory = new QueueConnectionFactoryAdapter((QueueConnectionFactory)new TibjmsXAQueueConnectionFactory(aURL, null, aMap));
        log.info("Created {} for URL: {} and properties {}", new Object[]{aConnectionFactory.getClass().getName(), aURL, aMap.toString()});
        return aConnectionFactory;
    }

    @Bean
    @ConditionalOnMissingBean(value={TopicConnectionFactory.class})
    @ConditionalOnExpression(value="'${tibco.ems.topic-connection-factory-name}' != null and !'${tibco.ems.pool.enabled}'")
    protected @UnknownKeyFor @NonNull @Initialized TopicConnectionFactory topicConnectionFactory() {
        Map<String, String> aMap = this.buildEMSProperties();
        String aURL = this.properties.getFactory().getUrl();
        TopicConnectionFactoryAdapter aConnectionFactory = new TopicConnectionFactoryAdapter((TopicConnectionFactory)new TibjmsXATopicConnectionFactory(aURL, null, aMap));
        log.info("Created {} for URL: {} and properties {}", new Object[]{aConnectionFactory.getClass().getName(), aURL, aMap.toString()});
        return aConnectionFactory;
    }

    @Bean
    @ConditionalOnClass(value={DestinationResolver.class})
    @ConditionalOnMissingBean(value={DestinationResolver.class})
    protected @UnknownKeyFor @NonNull @Initialized DestinationResolver destinationResolvers(@UnknownKeyFor @NonNull @Initialized JndiLocatorDelegate theJNDILocatorDelegate) {
        JndiDestinationResolver aReturnValue = new JndiDestinationResolver();
        aReturnValue.setCache(true);
        aReturnValue.setJndiTemplate(theJNDILocatorDelegate.getJndiTemplate());
        return aReturnValue;
    }

    @Bean
    @ConditionalOnClass(value={JmsListenerContainerFactory.class})
    @ConditionalOnMissingBean(name={"queueListenerContainerFactory"})
    @ConditionalOnBean(value={QueueConnectionFactory.class})
    @ConditionalOnProperty(prefix="spring.jms", name={"listener"})
    protected @UnknownKeyFor @NonNull @Initialized JmsListenerContainerFactory<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized MessageListenerContainer> queueListenerContainerFactory(@Qualifier(value="kafkaTransactionManager") @UnknownKeyFor @NonNull @Initialized PlatformTransactionManager theTransactionManager, @UnknownKeyFor @NonNull @Initialized QueueConnectionFactory theConnectionFactory, @UnknownKeyFor @NonNull @Initialized ObjectProvider<@UnknownKeyFor @NonNull @Initialized DestinationResolver> theDestinationResolver) {
        return this.newJMSListenerContainerFactory(theTransactionManager, (ConnectionFactory)theConnectionFactory, theDestinationResolver);
    }

    @Bean
    @ConditionalOnClass(value={JmsListenerContainerFactory.class})
    @ConditionalOnMissingBean(name={"topicListenerContainerFactory"})
    @ConditionalOnBean(value={TopicConnectionFactory.class})
    @ConditionalOnProperty(prefix="spring.jms", name={"listener"})
    protected @UnknownKeyFor @NonNull @Initialized JmsListenerContainerFactory<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized MessageListenerContainer> topicListenerContainerFactory(@Qualifier(value="kafkaTransactionManager") @UnknownKeyFor @NonNull @Initialized PlatformTransactionManager theTransactionManager, @UnknownKeyFor @NonNull @Initialized TopicConnectionFactory theConnectionFactory, @UnknownKeyFor @NonNull @Initialized ObjectProvider<@UnknownKeyFor @NonNull @Initialized DestinationResolver> theDestinationResolver) {
        return this.newJMSListenerContainerFactory(theTransactionManager, (ConnectionFactory)theConnectionFactory, theDestinationResolver);
    }

    protected @UnknownKeyFor @NonNull @Initialized JmsListenerContainerFactory<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized MessageListenerContainer> newJMSListenerContainerFactory(@UnknownKeyFor @NonNull @Initialized PlatformTransactionManager theTransactionManager, @UnknownKeyFor @NonNull @Initialized ConnectionFactory theConnectionFactory, @UnknownKeyFor @NonNull @Initialized ObjectProvider<@UnknownKeyFor @NonNull @Initialized DestinationResolver> theDestinationResolver) {
        DefaultJmsListenerContainerFactory aFactory = new DefaultJmsListenerContainerFactory();
        PropertyMapper aMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        JmsProperties aJMSProperties = this.jmsProperties;
        aMapper.from((Object)theConnectionFactory).to(arg_0 -> ((DefaultJmsListenerContainerFactory)aFactory).setConnectionFactory(arg_0));
        aMapper.from((Object)theTransactionManager).to(arg_0 -> ((DefaultJmsListenerContainerFactory)aFactory).setTransactionManager(arg_0));
        aMapper.from((Object)theTransactionManager).as(Objects::nonNull).whenTrue().to(arg_0 -> ((DefaultJmsListenerContainerFactory)aFactory).setSessionTransacted(arg_0));
        aMapper.from(() -> theDestinationResolver.getIfUnique()).to(arg_0 -> ((DefaultJmsListenerContainerFactory)aFactory).setDestinationResolver(arg_0));
        aMapper.from(() -> this.messageConverter.getIfUnique()).to(arg_0 -> ((DefaultJmsListenerContainerFactory)aFactory).setMessageConverter(arg_0));
        aMapper.from(() -> ((JmsProperties.Listener)aJMSProperties.getListener()).isAutoStartup()).to(arg_0 -> ((DefaultJmsListenerContainerFactory)aFactory).setAutoStartup(arg_0));
        aMapper.from(() -> ((JmsProperties.Listener)aJMSProperties.getListener()).getAcknowledgeMode()).as(JmsProperties.AcknowledgeMode::getMode).to(arg_0 -> ((DefaultJmsListenerContainerFactory)aFactory).setSessionAcknowledgeMode(arg_0));
        aMapper.from(() -> ((JmsProperties.Listener)aJMSProperties.getListener()).formatConcurrency()).to(arg_0 -> ((DefaultJmsListenerContainerFactory)aFactory).setConcurrency(arg_0));
        aMapper.from(() -> ((JmsProperties.Listener)aJMSProperties.getListener()).getReceiveTimeout()).as(Duration::toMillis).to(arg_0 -> ((DefaultJmsListenerContainerFactory)aFactory).setReceiveTimeout(arg_0));
        aMapper.from(() -> ((JmsProperties.Cache)aJMSProperties.getCache()).getSessionCacheSize()).to(scs -> aFactory.setCacheLevel(Integer.valueOf(scs == null || scs <= 0 ? 1 : 2)));
        aMapper.from(() -> ((JmsProperties.Cache)aJMSProperties.getCache()).isConsumers()).whenTrue().toCall(() -> aFactory.setCacheLevel(Integer.valueOf(3)));
        aMapper.from((Object)(theConnectionFactory instanceof TopicConnectionFactory)).to(arg_0 -> ((DefaultJmsListenerContainerFactory)aFactory).setPubSubDomain(arg_0));
        return aFactory;
    }

    public EMSAutoConfiguration(@UnknownKeyFor @NonNull @Initialized EMSProperties properties, @UnknownKeyFor @NonNull @Initialized JmsProperties jmsProperties, @UnknownKeyFor @NonNull @Initialized ObjectProvider<@UnknownKeyFor @NonNull @Initialized MessageConverter> messageConverter) {
        this.properties = properties;
        this.jmsProperties = jmsProperties;
        this.messageConverter = messageConverter;
    }

    protected static class TopicConnectionFactoryAdapter
    extends AbstractConnectionFactoryAdapter
    implements TopicConnectionFactory {
        public TopicConnectionFactoryAdapter(@UnknownKeyFor @NonNull @Initialized TopicConnectionFactory theFactory) {
            super((ConnectionFactory)theFactory);
        }

        public @UnknownKeyFor @NonNull @Initialized TopicConnection createTopicConnection() throws @UnknownKeyFor @NonNull @Initialized JMSException {
            return ((TopicConnectionFactory)this.factory).createTopicConnection();
        }

        public @UnknownKeyFor @NonNull @Initialized TopicConnection createTopicConnection(@UnknownKeyFor @NonNull @Initialized String theUserName, @UnknownKeyFor @NonNull @Initialized String thePassword) throws @UnknownKeyFor @NonNull @Initialized JMSException {
            return ((TopicConnectionFactory)this.factory).createTopicConnection(theUserName, thePassword);
        }
    }

    protected static class QueueConnectionFactoryAdapter
    extends AbstractConnectionFactoryAdapter
    implements QueueConnectionFactory {
        public QueueConnectionFactoryAdapter(@UnknownKeyFor @NonNull @Initialized QueueConnectionFactory theFactory) {
            super((ConnectionFactory)theFactory);
        }

        public @UnknownKeyFor @NonNull @Initialized QueueConnection createQueueConnection() throws @UnknownKeyFor @NonNull @Initialized JMSException {
            return ((QueueConnectionFactory)this.factory).createQueueConnection();
        }

        public @UnknownKeyFor @NonNull @Initialized QueueConnection createQueueConnection(@UnknownKeyFor @NonNull @Initialized String theUserName, @UnknownKeyFor @NonNull @Initialized String thePassword) throws @UnknownKeyFor @NonNull @Initialized JMSException {
            return ((QueueConnectionFactory)this.factory).createQueueConnection(theUserName, thePassword);
        }
    }

    protected static abstract class AbstractConnectionFactoryAdapter
    implements ConnectionFactory {
        protected final @UnknownKeyFor @NonNull @Initialized ConnectionFactory factory;

        public AbstractConnectionFactoryAdapter(@UnknownKeyFor @NonNull @Initialized ConnectionFactory factory) {
            this.factory = factory;
        }

        public @UnknownKeyFor @NonNull @Initialized Connection createConnection() throws @UnknownKeyFor @NonNull @Initialized JMSException {
            return this.factory.createConnection();
        }

        public @UnknownKeyFor @NonNull @Initialized Connection createConnection(@UnknownKeyFor @NonNull @Initialized String arg0, @UnknownKeyFor @NonNull @Initialized String arg1) throws @UnknownKeyFor @NonNull @Initialized JMSException {
            return this.factory.createConnection(arg0, arg1);
        }

        public @UnknownKeyFor @NonNull @Initialized JMSContext createContext() {
            return this.factory.createContext();
        }

        public @UnknownKeyFor @NonNull @Initialized JMSContext createContext(@UnknownKeyFor @NonNull @Initialized int arg0) {
            return this.factory.createContext(arg0);
        }

        public @UnknownKeyFor @NonNull @Initialized JMSContext createContext(@UnknownKeyFor @NonNull @Initialized String arg0, @UnknownKeyFor @NonNull @Initialized String arg1) {
            return this.factory.createContext(arg0, arg1);
        }

        public @UnknownKeyFor @NonNull @Initialized JMSContext createContext(@UnknownKeyFor @NonNull @Initialized String arg0, @UnknownKeyFor @NonNull @Initialized String arg1, @UnknownKeyFor @NonNull @Initialized int arg2) {
            return this.factory.createContext(arg0, arg1, arg2);
        }
    }

    protected static class EMSJNDILocatorDelegate
    extends JndiLocatorDelegate {
        public EMSJNDILocatorDelegate(@UnknownKeyFor @NonNull @Initialized Properties theJndiProperties) {
            this.setJndiEnvironment(theJndiProperties);
        }
    }
}

