/*
 * Decompiled with CFR 0.152.
 */
package org.birchframework.ems;

import java.time.Duration;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.springframework.boot.autoconfigure.jms.JmsPoolConnectionFactoryProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="tibco.ems")
public class EMSProperties {
    private final @UnknownKeyFor @NonNull @Initialized Factory factory = new Factory();
    private final @UnknownKeyFor @NonNull @Initialized JNDI jndi = new JNDI();
    private final @UnknownKeyFor @NonNull @Initialized SSL ssl = new SSL();
    private final @UnknownKeyFor @NonNull @Initialized ConnectionParameters connect;
    private final @UnknownKeyFor @NonNull @Initialized ConnectionParameters reconnect;
    private @UnknownKeyFor @NonNull @Initialized String queueConnectionFactoryName = null;
    private @UnknownKeyFor @NonNull @Initialized String topicConnectionFactoryName = null;
    @NestedConfigurationProperty
    private final @UnknownKeyFor @NonNull @Initialized JmsPoolConnectionFactoryProperties pool = new JmsPoolConnectionFactoryProperties();

    public EMSProperties() {
        this.connect = new ConnectionParameters(10, Duration.ofSeconds(1L), Duration.ofSeconds(1L));
        this.reconnect = new ConnectionParameters(20, Duration.ofSeconds(2L), Duration.ofSeconds(2L));
    }

    public void setQueueConnectionFactoryName(@UnknownKeyFor @NonNull @Initialized String queueConnectionFactoryName) {
        this.queueConnectionFactoryName = queueConnectionFactoryName;
    }

    public void setTopicConnectionFactoryName(@UnknownKeyFor @NonNull @Initialized String topicConnectionFactoryName) {
        this.topicConnectionFactoryName = topicConnectionFactoryName;
    }

    public @UnknownKeyFor @NonNull @Initialized Factory getFactory() {
        return this.factory;
    }

    public @UnknownKeyFor @NonNull @Initialized JNDI getJndi() {
        return this.jndi;
    }

    public @UnknownKeyFor @NonNull @Initialized SSL getSsl() {
        return this.ssl;
    }

    public @UnknownKeyFor @NonNull @Initialized ConnectionParameters getConnect() {
        return this.connect;
    }

    public @UnknownKeyFor @NonNull @Initialized ConnectionParameters getReconnect() {
        return this.reconnect;
    }

    public @UnknownKeyFor @NonNull @Initialized String getQueueConnectionFactoryName() {
        return this.queueConnectionFactoryName;
    }

    public @UnknownKeyFor @NonNull @Initialized String getTopicConnectionFactoryName() {
        return this.topicConnectionFactoryName;
    }

    public @UnknownKeyFor @NonNull @Initialized JmsPoolConnectionFactoryProperties getPool() {
        return this.pool;
    }

    public static class ConnectionParameters {
        private @UnknownKeyFor @NonNull @Initialized int attemptCount;
        private @UnknownKeyFor @NonNull @Initialized Duration attemptDelay;
        private @UnknownKeyFor @NonNull @Initialized Duration attemptTimeout;

        public void setAttemptCount(@UnknownKeyFor @NonNull @Initialized int attemptCount) {
            this.attemptCount = attemptCount;
        }

        public void setAttemptDelay(@UnknownKeyFor @NonNull @Initialized Duration attemptDelay) {
            this.attemptDelay = attemptDelay;
        }

        public void setAttemptTimeout(@UnknownKeyFor @NonNull @Initialized Duration attemptTimeout) {
            this.attemptTimeout = attemptTimeout;
        }

        public @UnknownKeyFor @NonNull @Initialized int getAttemptCount() {
            return this.attemptCount;
        }

        public @UnknownKeyFor @NonNull @Initialized Duration getAttemptDelay() {
            return this.attemptDelay;
        }

        public @UnknownKeyFor @NonNull @Initialized Duration getAttemptTimeout() {
            return this.attemptTimeout;
        }

        public ConnectionParameters(@UnknownKeyFor @NonNull @Initialized int attemptCount, @UnknownKeyFor @NonNull @Initialized Duration attemptDelay, @UnknownKeyFor @NonNull @Initialized Duration attemptTimeout) {
            this.attemptCount = attemptCount;
            this.attemptDelay = attemptDelay;
            this.attemptTimeout = attemptTimeout;
        }
    }

    public static class SSL {
        private @UnknownKeyFor @NonNull @Initialized String vendor;
        private @UnknownKeyFor @NonNull @Initialized boolean verifyHost = true;
        private @UnknownKeyFor @NonNull @Initialized boolean verifyHostname = true;
        private @UnknownKeyFor @NonNull @Initialized boolean trace = false;
        private @UnknownKeyFor @NonNull @Initialized boolean debugTrace = false;
        private @UnknownKeyFor @NonNull @Initialized boolean authOnly = false;
        private @UnknownKeyFor @NonNull @Initialized String expectedHostname;
        private @UnknownKeyFor @NonNull @Initialized String hostnameVerifier;
        private @UnknownKeyFor @NonNull @Initialized String identity;
        private @UnknownKeyFor @NonNull @Initialized String identityEncoding;
        private @UnknownKeyFor @NonNull @Initialized String password;
        private @UnknownKeyFor @NonNull @Initialized String issuerCertificates;
        private @UnknownKeyFor @NonNull @Initialized String trustedCertificates;
        private @UnknownKeyFor @NonNull @Initialized String privateKey;
        private @UnknownKeyFor @NonNull @Initialized String privateKeyEncoding;
        private @UnknownKeyFor @NonNull @Initialized String cipherSuites;

        public void setVendor(@UnknownKeyFor @NonNull @Initialized String vendor) {
            this.vendor = vendor;
        }

        public void setVerifyHost(@UnknownKeyFor @NonNull @Initialized boolean verifyHost) {
            this.verifyHost = verifyHost;
        }

        public void setVerifyHostname(@UnknownKeyFor @NonNull @Initialized boolean verifyHostname) {
            this.verifyHostname = verifyHostname;
        }

        public void setTrace(@UnknownKeyFor @NonNull @Initialized boolean trace) {
            this.trace = trace;
        }

        public void setDebugTrace(@UnknownKeyFor @NonNull @Initialized boolean debugTrace) {
            this.debugTrace = debugTrace;
        }

        public void setAuthOnly(@UnknownKeyFor @NonNull @Initialized boolean authOnly) {
            this.authOnly = authOnly;
        }

        public void setExpectedHostname(@UnknownKeyFor @NonNull @Initialized String expectedHostname) {
            this.expectedHostname = expectedHostname;
        }

        public void setHostnameVerifier(@UnknownKeyFor @NonNull @Initialized String hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
        }

        public void setIdentity(@UnknownKeyFor @NonNull @Initialized String identity) {
            this.identity = identity;
        }

        public void setIdentityEncoding(@UnknownKeyFor @NonNull @Initialized String identityEncoding) {
            this.identityEncoding = identityEncoding;
        }

        public void setPassword(@UnknownKeyFor @NonNull @Initialized String password) {
            this.password = password;
        }

        public void setIssuerCertificates(@UnknownKeyFor @NonNull @Initialized String issuerCertificates) {
            this.issuerCertificates = issuerCertificates;
        }

        public void setTrustedCertificates(@UnknownKeyFor @NonNull @Initialized String trustedCertificates) {
            this.trustedCertificates = trustedCertificates;
        }

        public void setPrivateKey(@UnknownKeyFor @NonNull @Initialized String privateKey) {
            this.privateKey = privateKey;
        }

        public void setPrivateKeyEncoding(@UnknownKeyFor @NonNull @Initialized String privateKeyEncoding) {
            this.privateKeyEncoding = privateKeyEncoding;
        }

        public void setCipherSuites(@UnknownKeyFor @NonNull @Initialized String cipherSuites) {
            this.cipherSuites = cipherSuites;
        }

        public @UnknownKeyFor @NonNull @Initialized String getVendor() {
            return this.vendor;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isVerifyHost() {
            return this.verifyHost;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isVerifyHostname() {
            return this.verifyHostname;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isTrace() {
            return this.trace;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isDebugTrace() {
            return this.debugTrace;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isAuthOnly() {
            return this.authOnly;
        }

        public @UnknownKeyFor @NonNull @Initialized String getExpectedHostname() {
            return this.expectedHostname;
        }

        public @UnknownKeyFor @NonNull @Initialized String getHostnameVerifier() {
            return this.hostnameVerifier;
        }

        public @UnknownKeyFor @NonNull @Initialized String getIdentity() {
            return this.identity;
        }

        public @UnknownKeyFor @NonNull @Initialized String getIdentityEncoding() {
            return this.identityEncoding;
        }

        public @UnknownKeyFor @NonNull @Initialized String getPassword() {
            return this.password;
        }

        public @UnknownKeyFor @NonNull @Initialized String getIssuerCertificates() {
            return this.issuerCertificates;
        }

        public @UnknownKeyFor @NonNull @Initialized String getTrustedCertificates() {
            return this.trustedCertificates;
        }

        public @UnknownKeyFor @NonNull @Initialized String getPrivateKey() {
            return this.privateKey;
        }

        public @UnknownKeyFor @NonNull @Initialized String getPrivateKeyEncoding() {
            return this.privateKeyEncoding;
        }

        public @UnknownKeyFor @NonNull @Initialized String getCipherSuites() {
            return this.cipherSuites;
        }
    }

    public static class JNDI {
        private @UnknownKeyFor @NonNull @Initialized String url;
        private @UnknownKeyFor @NonNull @Initialized String principal;
        private @UnknownKeyFor @NonNull @Initialized String credentials;
        private @UnknownKeyFor @NonNull @Initialized String protocol;
        private @UnknownKeyFor @NonNull @Initialized String authentication;

        public void setUrl(@UnknownKeyFor @NonNull @Initialized String url) {
            this.url = url;
        }

        public void setPrincipal(@UnknownKeyFor @NonNull @Initialized String principal) {
            this.principal = principal;
        }

        public void setCredentials(@UnknownKeyFor @NonNull @Initialized String credentials) {
            this.credentials = credentials;
        }

        public void setProtocol(@UnknownKeyFor @NonNull @Initialized String protocol) {
            this.protocol = protocol;
        }

        public void setAuthentication(@UnknownKeyFor @NonNull @Initialized String authentication) {
            this.authentication = authentication;
        }

        public @UnknownKeyFor @NonNull @Initialized String getUrl() {
            return this.url;
        }

        public @UnknownKeyFor @NonNull @Initialized String getPrincipal() {
            return this.principal;
        }

        public @UnknownKeyFor @NonNull @Initialized String getCredentials() {
            return this.credentials;
        }

        public @UnknownKeyFor @NonNull @Initialized String getProtocol() {
            return this.protocol;
        }

        public @UnknownKeyFor @NonNull @Initialized String getAuthentication() {
            return this.authentication;
        }
    }

    public static class Factory {
        private @UnknownKeyFor @NonNull @Initialized String url;
        private @UnknownKeyFor @NonNull @Initialized String username;
        private @UnknownKeyFor @NonNull @Initialized String password;
        private @UnknownKeyFor @NonNull @Initialized String protocol;
        private @UnknownKeyFor @NonNull @Initialized String sslPassword;

        public void setUrl(@UnknownKeyFor @NonNull @Initialized String url) {
            this.url = url;
        }

        public void setUsername(@UnknownKeyFor @NonNull @Initialized String username) {
            this.username = username;
        }

        public void setPassword(@UnknownKeyFor @NonNull @Initialized String password) {
            this.password = password;
        }

        public void setProtocol(@UnknownKeyFor @NonNull @Initialized String protocol) {
            this.protocol = protocol;
        }

        public void setSslPassword(@UnknownKeyFor @NonNull @Initialized String sslPassword) {
            this.sslPassword = sslPassword;
        }

        public @UnknownKeyFor @NonNull @Initialized String getUrl() {
            return this.url;
        }

        public @UnknownKeyFor @NonNull @Initialized String getUsername() {
            return this.username;
        }

        public @UnknownKeyFor @NonNull @Initialized String getPassword() {
            return this.password;
        }

        public @UnknownKeyFor @NonNull @Initialized String getProtocol() {
            return this.protocol;
        }

        public @UnknownKeyFor @NonNull @Initialized String getSslPassword() {
            return this.sslPassword;
        }
    }
}

