/*
 * Decompiled with CFR 0.152.
 */
package org.birchframework.resource;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.birchframework.framework.kafka.KafkaAdminUtils;
import org.birchframework.resource.KafkaAdminUtilsResource;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnClass(value={Response.class, Jackson2ObjectMapperBuilder.class})
@ConditionalOnBean(value={KafkaAdminUtils.class})
@OpenAPIDefinition(info=@Info(title="Kafka Admin Utilities", version="1", description="APIs for programmatic access to Kafka admin utilities"))
public class KafkaAdminUtilsResourceImpl
implements KafkaAdminUtilsResource {
    private static final @UnknownKeyFor @NonNull @Initialized ObjectMapper objectMapper = Jackson2ObjectMapperBuilder.json().build();
    private final @UnknownKeyFor @NonNull @Initialized KafkaAdminUtils kafkaAdminUtils;

    @Override
    @Operation(summary="Returns topic to consumer lag mappings", responses={@ApiResponse(description="Topic/Lag mappings", content={@Content(array=@ArraySchema(arraySchema=@Schema(implementation=Map.class, description="Topic/Lag mappings"), schema=@Schema(implementation=Map.Entry.class, description="Tuple: {topic,lag}"), uniqueItems=true))})})
    public @UnknownKeyFor @NonNull @Initialized Response topicLags() {
        StreamingOutput aStream = output -> objectMapper.writeValue(output, this.kafkaAdminUtils.topicLags());
        return Response.ok((Object)aStream).build();
    }

    public KafkaAdminUtilsResourceImpl(@UnknownKeyFor @NonNull @Initialized KafkaAdminUtils kafkaAdminUtils) {
        this.kafkaAdminUtils = kafkaAdminUtils;
    }
}

