/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.charlbrink.cloud.sleuth.instrument.camel;

import org.apache.camel.Exchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanTextMap;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapExtractor;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapInjector;
import org.springframework.cloud.sleuth.util.SpanNameUtil;

abstract class AbstractTraceExchangeInterceptor {
    private static final Log log = LogFactory.getLog(AbstractTraceExchangeInterceptor.class);
    protected static final String MESSAGE_COMPONENT = "message";
    private final Tracer tracer;
    private final TraceKeys traceKeys;
    private final MessagingSpanTextMapExtractor spanExtractor;
    private final MessagingSpanTextMapInjector spanInjector;

    @Autowired
    protected AbstractTraceExchangeInterceptor(Tracer tracer, TraceKeys traceKeys, MessagingSpanTextMapExtractor spanExtractor, MessagingSpanTextMapInjector spanInjector) {
        this.tracer = tracer;
        this.traceKeys = traceKeys;
        this.spanExtractor = spanExtractor;
        this.spanInjector = spanInjector;
    }

    protected Tracer getTracer() {
        return this.tracer;
    }

    protected TraceKeys getTraceKeys() {
        return this.traceKeys;
    }

    protected MessagingSpanTextMapInjector getSpanInjector() {
        return this.spanInjector;
    }

    protected Span buildSpan(SpanTextMap carrier) {
        try {
            return this.spanExtractor.joinTrace((Object)carrier);
        }
        catch (Exception e) {
            log.error((Object)"Exception occurred while trying to extract span from carrier", (Throwable)e);
            return null;
        }
    }

    String getExchangeName(Exchange exchange) {
        return exchange.getContext().getName();
    }

    String getMessageExchangeName(Exchange exchange) {
        return SpanNameUtil.shorten((String)("message:" + this.getExchangeName(exchange)));
    }
}

