/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.charlbrink.cloud.sleuth.instrument.camel;

import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.bitbucket.charlbrink.cloud.sleuth.instrument.camel.TraceFromExchangeInterceptor;
import org.bitbucket.charlbrink.cloud.sleuth.instrument.camel.TraceToExchangeInterceptor;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SleuthCamelRouteAspect {
    private static final String ANY = "*";
    private TraceFromExchangeInterceptor traceFromExchangeInterceptor;
    private TraceToExchangeInterceptor traceToExchangeInterceptor;

    public SleuthCamelRouteAspect(TraceFromExchangeInterceptor traceFromExchangeInterceptor, TraceToExchangeInterceptor traceToExchangeInterceptor) {
        this.traceFromExchangeInterceptor = traceFromExchangeInterceptor;
        this.traceToExchangeInterceptor = traceToExchangeInterceptor;
    }

    @Before(value="execution(* org.apache.camel.builder.RouteBuilder.addRoutesToCamelContext(..))")
    public void configureCamelExchangeInterceptors(JoinPoint joinPoint) {
        RouteBuilder targetRouteBuilder = (RouteBuilder)joinPoint.getTarget();
        targetRouteBuilder.interceptFrom().process((Processor)this.traceFromExchangeInterceptor);
        targetRouteBuilder.interceptSendToEndpoint(ANY).process((Processor)this.traceToExchangeInterceptor);
    }
}

