/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.charlbrink.cloud.sleuth.instrument.camel;

import org.apache.camel.Message;
import org.bitbucket.charlbrink.cloud.sleuth.instrument.camel.SleuthCamelProperties;
import org.bitbucket.charlbrink.cloud.sleuth.instrument.camel.SleuthCamelRouteAspect;
import org.bitbucket.charlbrink.cloud.sleuth.instrument.camel.TraceFromExchangeInterceptor;
import org.bitbucket.charlbrink.cloud.sleuth.instrument.camel.TraceToExchangeInterceptor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.messaging.HeaderBasedMessagingExtractor;
import org.springframework.cloud.sleuth.instrument.messaging.HeaderBasedMessagingInjector;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapExtractor;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapInjector;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnClass(value={Message.class})
@AutoConfigureAfter(value={TraceAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.sleuth.camel.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={TraceKeys.class, SleuthCamelProperties.class})
public class TraceCamelAutoConfiguration {
    @Bean
    public SleuthCamelRouteAspect sleuthCamelRouteAspect(TraceFromExchangeInterceptor traceFromChannelInterceptor, TraceToExchangeInterceptor traceToChannelInterceptor) {
        return new SleuthCamelRouteAspect(traceFromChannelInterceptor, traceToChannelInterceptor);
    }

    @Bean
    @ConditionalOnMissingBean
    public TraceFromExchangeInterceptor traceFromChannelInterceptor(Tracer tracer, TraceKeys traceKeys, MessagingSpanTextMapExtractor spanExtractor, MessagingSpanTextMapInjector spanInjector) {
        return new TraceFromExchangeInterceptor(tracer, traceKeys, spanExtractor, spanInjector);
    }

    @Bean
    @ConditionalOnMissingBean
    public TraceToExchangeInterceptor traceToChannelInterceptor(Tracer tracer, TraceKeys traceKeys, MessagingSpanTextMapExtractor spanExtractor, MessagingSpanTextMapInjector spanInjector) {
        return new TraceToExchangeInterceptor(tracer, traceKeys, spanExtractor, spanInjector);
    }

    @Bean
    @ConditionalOnMissingBean
    public MessagingSpanTextMapExtractor messagingSpanExtractor() {
        return new HeaderBasedMessagingExtractor();
    }

    @Bean
    @ConditionalOnMissingBean
    public MessagingSpanTextMapInjector messagingSpanInjector(TraceKeys traceKeys) {
        return new HeaderBasedMessagingInjector(traceKeys);
    }
}

