/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.charlbrink.cloud.sleuth.instrument.camel;

import java.util.Iterator;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bitbucket.charlbrink.cloud.sleuth.instrument.camel.AbstractTraceExchangeInterceptor;
import org.bitbucket.charlbrink.cloud.sleuth.instrument.camel.MessagingTextMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.Sampler;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapExtractor;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapInjector;
import org.springframework.cloud.sleuth.sampler.NeverSampler;

public class TraceFromExchangeInterceptor
extends AbstractTraceExchangeInterceptor
implements Processor {
    private static final Log log = LogFactory.getLog(TraceFromExchangeInterceptor.class);

    @Autowired
    public TraceFromExchangeInterceptor(Tracer tracer, TraceKeys traceKeys, MessagingSpanTextMapExtractor spanExtractor, MessagingSpanTextMapInjector spanInjector) {
        super(tracer, traceKeys, spanExtractor, spanInjector);
    }

    public void process(Exchange exchange) {
        Message inboundMessage = exchange.getIn();
        log.trace((Object)String.format("TraceFromExchange intercepted started Headers: %s %s %s %s", inboundMessage.getHeaders().toString(), this.getTracer(), this.getTracer().isTracing(), inboundMessage.getHeader("CamelInterceptedEndpoint")));
        if (this.getTracer().isTracing()) {
            this.getTracer().detach(this.getTracer().getCurrentSpan());
        }
        Span parentSpan = this.buildSpan(new MessagingTextMap(inboundMessage));
        MessagingTextMap spanTextMap = new MessagingTextMap(inboundMessage);
        this.getSpanInjector().inject(parentSpan, (Object)spanTextMap);
        String name = this.getMessageExchangeName(exchange);
        Span currentSpan = this.startSpan(parentSpan, name, inboundMessage);
        Iterator iterator = spanTextMap.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            inboundMessage.setHeader((String)entry.getKey(), entry.getValue());
        }
        log.trace((Object)String.format("TraceFromExchange intercepted ending %s %s", this.getTracer().isTracing(), inboundMessage.getHeader("CamelInterceptedEndpoint")));
    }

    private Span startSpan(Span span, String name, Message message) {
        if (span != null) {
            return this.getTracer().createSpan(name, span);
        }
        if ("0".equals(message.getHeaders().get("spanSampled"))) {
            return this.getTracer().createSpan(name, (Sampler)NeverSampler.INSTANCE);
        }
        return this.getTracer().createSpan(name);
    }
}

