package org.bitbucket.mcmichailidis.sqlitedbhandler.models;

import org.bitbucket.mcmichailidis.sqlitedbhandler.enumerations.RuleSymbol;

/**
 * @author KuroiKage.
 */
public class BasicRule {
    private final ColumnInfo columnInfo;
    private final String value;
    private final RuleSymbol ruleSymbol;

    public BasicRule(ColumnInfo columnInfo, String value, RuleSymbol ruleSymbol) {
        this.columnInfo = columnInfo;
        this.value = value;
        this.ruleSymbol = ruleSymbol;
    }

    public String toRule(){
        return columnInfo.getName() + ruleSymbol.getValue() + value;
    }
}
