package org.bitbucket.mcmichailidis.sqlitedbhandler.models;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author KuroiKage.
 */
public class Row {
    class ColumnData {
        private final String column;
        private final String data;

        ColumnData(String column, String data) {
            this.column = column;
            this.data = data;
        }

        String getColumn() {
            return column;
        }

        String getData() {
            return data;
        }

        @Override
        public String toString() {
            return "ColumnData{" +
                    "column='" + column + '\'' +
                    ", data='" + data + '\'' +
                    '}';
        }
    }

    private final List<ColumnData> data = new ArrayList<>();

    private void insertData(ColumnData cd) {
        data.add(cd);
    }

    public void insertData(String column, String data) {
        insertData(new ColumnData(column, data));
    }

    public List<String> getDataByColumn(ColumnInfo columnInfo) {
        return data
                .stream()
                .filter(row -> row.getColumn().equals(columnInfo.getName()))
                .map(ColumnData::getData)
                .collect(Collectors.toList());
    }

    @Override
    public String toString() {
        return "Row{" +
                "data=" + data +
                '}';
    }
}
