/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.pshirshov.izumitk.akka.http.auth.jwt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.security.Key;
import org.bitbucket.pshirshov.izumitk.akka.http.auth.jwt.JwtSupport;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.util.Try;
import scala.util.Try$;

public abstract class JwtSupport$class {
    public static String createJwt(JwtSupport $this, String keyId, String payload) {
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(payload);
        PublicJsonWebKey key = $this.getKey(keyId);
        jws.setKey((Key)key.getPrivateKey());
        jws.setKeyIdHeaderValue(key.getKeyId());
        jws.setAlgorithmHeaderValue("RS256");
        return jws.getCompactSerialization();
    }

    public static String createJwt(JwtSupport $this, String keyId, JsonNode payload) {
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload($this.jwtMapper().writeValueAsString((Object)payload));
        PublicJsonWebKey key = $this.getKey(keyId);
        jws.setKey((Key)key.getPrivateKey());
        jws.setKeyIdHeaderValue(key.getKeyId());
        jws.setAlgorithmHeaderValue("RS256");
        return jws.getCompactSerialization();
    }

    public static Try readJwt(JwtSupport $this, String keyId, String token) {
        JwtConsumerBuilder consumerBuilder = $this.createConsumerBuilder().setVerificationKey($this.getKey(keyId).getKey());
        return Try$.MODULE$.apply((Function0)new Serializable($this, consumerBuilder, token){
            public static final long serialVersionUID = 0L;
            private final JwtConsumerBuilder consumerBuilder$1;
            private final String token$1;

            public final JwtClaims apply() {
                return this.consumerBuilder$1.build().processToClaims(this.token$1);
            }
            {
                this.consumerBuilder$1 = consumerBuilder$1;
                this.token$1 = token$1;
            }
        });
    }

    public static JwtConsumerBuilder createConsumerBuilder(JwtSupport $this) {
        return new JwtConsumerBuilder().setRequireExpirationTime().setRequireSubject();
    }

    public static ObjectNode createJwtPayload(JwtSupport $this, Function1 claimsHandler) {
        JwtClaims claims = new JwtClaims();
        claims.setGeneratedJwtId();
        claims.setIssuedAtToNow();
        claimsHandler.apply((Object)claims);
        return (ObjectNode)$this.jwtMapper().readTree(claims.toJson());
    }

    public static void $init$(JwtSupport $this) {
    }
}

