/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.pshirshov.izumitk.akka.http.modules;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.MembersInjector;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Scope;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matcher;
import com.google.inject.name.Named;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.math.BigInteger;
import java.security.Key;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import net.codingwell.scalaguice.InternalModule;
import net.codingwell.scalaguice.ScalaModule;
import org.aopalliance.intercept.MethodInterceptor;
import org.bitbucket.pshirshov.izumitk.akka.http.auth.jwt.JwtKeyId;
import org.bitbucket.pshirshov.izumitk.akka.http.auth.jwt.KeyPair;
import org.bitbucket.pshirshov.izumitk.akka.http.modules.SecurityKeys$;
import org.jose4j.jwk.EllipticCurveJsonWebKey;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.OctetSequenceJsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.keys.BigEndianBigInteger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001}4A!\u0001\u0002\u0003#\tI!j\u001e;N_\u0012,H.\u001a\u0006\u0003\u0007\u0011\tq!\\8ek2,7O\u0003\u0002\u0006\r\u0005!\u0001\u000e\u001e;q\u0015\t9\u0001\"\u0001\u0003bW.\f'BA\u0005\u000b\u0003\u001dI'0^7ji.T!a\u0003\u0007\u0002\u0013A\u001c\b.\u001b:tQ>4(BA\u0007\u000f\u0003%\u0011\u0017\u000e\u001e2vG.,GOC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\u0011\u0001!\u0003\b\u0014\u0011\u0005MQR\"\u0001\u000b\u000b\u0005U1\u0012AB5oU\u0016\u001cGO\u0003\u0002\u00181\u00051qm\\8hY\u0016T\u0011!G\u0001\u0004G>l\u0017BA\u000e\u0015\u00059\t%m\u001d;sC\u000e$Xj\u001c3vY\u0016\u0004\"!\b\u0013\u000e\u0003yQ!a\b\u0011\u0002\u0015M\u001c\u0017\r\\1hk&\u001cWM\u0003\u0002\"E\u0005Q1m\u001c3j]\u001e<X\r\u001c7\u000b\u0003\r\n1A\\3u\u0013\t)cDA\u0006TG\u0006d\u0017-T8ek2,\u0007CA\u0014-\u001b\u0005A#BA\u0015+\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tY\u0003$\u0001\u0005usB,7/\u00194f\u0013\ti\u0003FA\u0007TiJL7\r\u001e'pO\u001eLgn\u001a\u0005\u0006_\u0001!\t\u0001M\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0002\"A\r\u0001\u000e\u0003\tAQ\u0001\u000e\u0001\u0005BU\n\u0011bY8oM&<WO]3\u0015\u0003Y\u0002\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u0012A!\u00168ji\")Q\b\u0001C\u0001}\u00051!n\u001e;LKf$\"aP+\u0011\t\u0001;%J\u0015\b\u0003\u0003\u0016\u0003\"A\u0011\u001d\u000e\u0003\rS!\u0001\u0012\t\u0002\rq\u0012xn\u001c;?\u0013\t1\u0005(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011&\u00131!T1q\u0015\t1\u0005\b\u0005\u0002L!6\tAJ\u0003\u0002N\u001d\u0006\u0019!n\u001e;\u000b\u0005=#\u0011\u0001B1vi\"L!!\u0015'\u0003\u0011);HoS3z\u0013\u0012\u0004\"aS*\n\u0005Qc%aB&fsB\u000b\u0017N\u001d\u0005\u0006-r\u0002\raV\u0001\bU^$8*Z=t!\tA6,D\u0001Z\u0015\tQ&&\u0001\u0004d_:4\u0017nZ\u0005\u00039f\u0013aaQ8oM&<\u0007\u0006B+_I\u0016\u0004\"a\u00182\u000e\u0003\u0001T!!\u0019\u000b\u0002\t9\fW.Z\u0005\u0003G\u0002\u0014QAT1nK\u0012\fQA^1mk\u0016\f\u0013AZ\u0001\u0010\u0001*<HO\f6xi6ZW-_:/U!\u0012A\b\u001b\t\u0003'%L!A\u001b\u000b\u0003\u0013MKgn\u001a7fi>t\u0007F\u0001\u001fm!\t\u0019R.\u0003\u0002o)\tA\u0001K]8wS\u0012,7\u000fC\u0003q\u0001\u0011%\u0011/\u0001\u0004m_\u001e\\U-\u001f\u000b\u0005mI4\b\u0010C\u0003b_\u0002\u00071\u000f\u0005\u0002Ai&\u0011Q/\u0013\u0002\u0007'R\u0014\u0018N\\4\t\u000b]|\u0007\u0019A,\u0002\u0013-,\u0017pQ8oM&<\u0007\"B=p\u0001\u0004\u0011\u0016aA6fs\")1\u0010\u0001C\u0005y\u0006IA-Z2pI\u0016\\U-\u001f\u000b\u0004%vt\b\"B1{\u0001\u0004\u0019\b\"B<{\u0001\u00049\u0006")
public final class JwtModule
extends AbstractModule
implements ScalaModule,
StrictLogging {
    private final Logger logger;

    public /* synthetic */ Binder net$codingwell$scalaguice$ScalaModule$$super$binder() {
        return super.binder();
    }

    public Binder binderAccess() {
        return ScalaModule.binderAccess$((ScalaModule)this);
    }

    public <T> InternalModule.BindingBuilder<T> bind(Manifest<T> evidence$2) {
        return InternalModule.bind$((InternalModule)this, evidence$2);
    }

    public <I extends MethodInterceptor> void bindInterceptor(Matcher<? super Class<?>> classMatcher, Matcher<? super AnnotatedElement> methodMatcher, Manifest<I> evidence$3) {
        InternalModule.bindInterceptor$((InternalModule)this, classMatcher, methodMatcher, evidence$3);
    }

    public <A extends Annotation> Matcher<AnnotatedElement> annotatedWith(Manifest<A> evidence$4) {
        return InternalModule.annotatedWith$((InternalModule)this, evidence$4);
    }

    public <T extends Annotation> void bindScope(Scope scope, Manifest<T> evidence$5) {
        InternalModule.bindScope$((InternalModule)this, (Scope)scope, evidence$5);
    }

    public <T> void requestStaticInjection(Manifest<T> evidence$6) {
        InternalModule.requestStaticInjection$((InternalModule)this, evidence$6);
    }

    public <T> Provider<T> getProvider(Manifest<T> evidence$7) {
        return InternalModule.getProvider$((InternalModule)this, evidence$7);
    }

    public <T> MembersInjector<T> getMembersInjector(Manifest<T> evidence$8) {
        return InternalModule.getMembersInjector$((InternalModule)this, evidence$8);
    }

    public <I extends MethodInterceptor> Matcher<? super Class<?>> bindInterceptor$default$1() {
        return InternalModule.bindInterceptor$default$1$((InternalModule)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void configure() {
    }

    @Provides
    @Singleton
    public scala.collection.immutable.Map<JwtKeyId, KeyPair> jwtKey(@Named(value="@jwt.jwt-keys.*") Config jwtKeys) {
        Config values = jwtKeys;
        return ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(values.root().entrySet()).asScala()).map((Function1 & Serializable & scala.Serializable)v -> {
            String name = (String)v.getKey();
            Config keyConfig = this.deref$1(((ConfigObject)v.getValue()).toConfig(), values);
            KeyPair key = this.decodeKey(name, keyConfig);
            this.logKey(name, keyConfig, key);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new JwtKeyId(name)), (Object)key);
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private void logKey(String name, Config keyConfig, KeyPair key2) {
        if (keyConfig.hasPath("ref")) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded security key `", "` as reference to `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, keyConfig.getString("ref")})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded security key `", "`:\n           |- JWT Algorithm   : ", "\n           |- Encryption Key  : ", "\n           |- Verification Key: ", "\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, key2.algorithmIdentifier(), key2.encryption().fold((Function0 & Serializable & scala.Serializable)() -> "N/A", (Function1 & Serializable & scala.Serializable)key -> SecurityKeys$.MODULE$.keyInfo((Key)key)), SecurityKeys$.MODULE$.keyInfo(key2.verification())})))).stripMargin());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Key key3 = key2.verification();
            if (key3 instanceof RSAKey) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Key `", "` is RSA key. Below are key details:\n               | - Public Key fingerprint: ", "\n               | - Public Key as PEM:\n               | ", "\n            "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, SecurityKeys$.MODULE$.publicKeyFingerprint(key2.verification()), SecurityKeys$.MODULE$.writePublicPemKey(key2.verification())})))).stripMargin());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit2;
            } else {
                BoxedUnit boxedUnit4;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Key `", "` is of type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, key3.getAlgorithm()})));
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit5 = boxedUnit4;
            }
        }
    }

    private KeyPair decodeKey(String name, Config keyConfig) {
        KeyPair keyPair;
        JsonWebKey key;
        JsonWebKey jsonWebKey;
        String keyString = keyConfig.getString("key");
        String algo = keyConfig.getString("algorithm");
        if (keyString.contains("BEGIN")) {
            PublicJsonWebKey publicJsonWebKey;
            Key key2 = SecurityKeys$.MODULE$.readPemKey(keyString);
            if (key2 instanceof PublicKey) {
                PublicKey publicKey = (PublicKey)key2;
                publicJsonWebKey = PublicJsonWebKey.Factory.newPublicJwk((Key)publicKey);
            } else if (key2 instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key2;
                scala.collection.immutable.Map params = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)BigEndianBigInteger.toBase64Url((BigInteger)rSAPrivateCrtKey.getModulus())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"e"), (Object)BigEndianBigInteger.toBase64Url((BigInteger)rSAPrivateCrtKey.getPublicExponent())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)BigEndianBigInteger.toBase64Url((BigInteger)rSAPrivateCrtKey.getPrivateExponent())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kty"), (Object)"RSA")}));
                publicJsonWebKey = JsonWebKey.Factory.newJwk((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)params).asJava()));
            } else {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key2})));
            }
            jsonWebKey = publicJsonWebKey;
        } else {
            jsonWebKey = JsonWebKey.Factory.newJwk((String)keyString);
        }
        JsonWebKey jsonWebKey2 = key = jsonWebKey;
        if (jsonWebKey2 instanceof RsaJsonWebKey) {
            RsaJsonWebKey rsaJsonWebKey = (RsaJsonWebKey)jsonWebKey2;
            keyPair = new KeyPair(algo, (Option<Key>)Option$.MODULE$.apply((Object)rsaJsonWebKey.getRsaPrivateKey()), rsaJsonWebKey.getRsaPublicKey());
        } else if (jsonWebKey2 instanceof EllipticCurveJsonWebKey) {
            EllipticCurveJsonWebKey ellipticCurveJsonWebKey = (EllipticCurveJsonWebKey)jsonWebKey2;
            keyPair = new KeyPair(algo, (Option<Key>)Option$.MODULE$.apply((Object)ellipticCurveJsonWebKey.getEcPrivateKey()), ellipticCurveJsonWebKey.getECPublicKey());
        } else if (jsonWebKey2 instanceof PublicKey) {
            JsonWebKey jsonWebKey3 = jsonWebKey2;
            keyPair = new KeyPair(algo, (Option<Key>)None$.MODULE$, (Key)jsonWebKey3);
        } else if (jsonWebKey2 instanceof OctetSequenceJsonWebKey) {
            OctetSequenceJsonWebKey octetSequenceJsonWebKey = (OctetSequenceJsonWebKey)jsonWebKey2;
            keyPair = new KeyPair(algo, (Option<Key>)new Some((Object)octetSequenceJsonWebKey.getKey()), octetSequenceJsonWebKey.getKey());
        } else {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported key type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
        }
        return keyPair;
    }

    private final Config deref$1(Config keyConfig, Config values$1) {
        while (keyConfig.hasPath("ref")) {
            keyConfig = values$1.getConfig(keyConfig.getString("ref"));
        }
        return keyConfig;
    }

    public JwtModule() {
        InternalModule.$init$((InternalModule)this);
        ScalaModule.$init$((ScalaModule)this);
        StrictLogging.$init$((StrictLogging)this);
    }
}

