/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.pshirshov.izumitk.akka.http.modules;

import com.google.common.base.Splitter;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;
import resource.Resource$;
import resource.package$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.ClassTag$;
import scala.reflect.OptManifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sun.security.rsa.RSAPublicKeyImpl;

public final class SecurityKeys$ {
    public static SecurityKeys$ MODULE$;

    static {
        new SecurityKeys$();
    }

    public Key readPemKey(String keystr) {
        this.initBouncyCastle();
        return (Key)package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> new StringReader(keystr.trim()), Resource$.MODULE$.closeableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(StringReader.class)).map((Function1 & Serializable & scala.Serializable)r -> new PEMReader((Reader)r)).map((Function1 & Serializable & scala.Serializable)reader -> {
            Key key;
            Object object = reader.readObject();
            if (object instanceof Key) {
                Key key2;
                key = key2 = (Key)object;
            } else if (object instanceof KeyPair) {
                KeyPair keyPair = (KeyPair)object;
                key = keyPair.getPrivate();
            } else {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{object})));
            }
            return key;
        }).acquireAndGet((Function1 & Serializable & scala.Serializable)b -> b);
    }

    public String writePemKey(Key key) {
        return (String)package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> new StringWriter(), Resource$.MODULE$.closeableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(StringWriter.class)).acquireAndGet((Function1 & Serializable & scala.Serializable)out -> {
            package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> new PEMWriter((Writer)out), Resource$.MODULE$.closeableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(PEMWriter.class)).acquireAndGet((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.writeObject((Object)key);
                return BoxedUnit.UNIT;
            });
            return out.toString();
        });
    }

    public String writePublicPemKey(Key key) {
        String string;
        Key key2 = key;
        if (key2 instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key2;
            string = this.writePemKey(rSAPublicKey);
        } else if (key2 instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key2;
            string = this.writePemKey(new RSAPublicKeyImpl(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent()));
        } else {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key2})));
        }
        return string;
    }

    public String publicKeyFingerprint(Key key) {
        String string;
        Key key2 = key;
        if (key2 instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key2;
            string = this.fingerprint(rSAPublicKey);
        } else if (key2 instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key2;
            string = this.fingerprint(rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getModulus());
        } else {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key2})));
        }
        return string;
    }

    public String keyInfo(Key key) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key.getAlgorithm(), key.getClass().getSimpleName()}));
    }

    private String fingerprint(RSAPublicKey key) {
        return this.fingerprint(key.getPublicExponent(), key.getModulus());
    }

    private String fingerprint(BigInteger publicExponent, BigInteger modulus) {
        byte[] blob = this.keyBlob(publicExponent, modulus);
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MD5:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hexColonDelimited(Hashing.md5().hashBytes(blob))}));
    }

    private byte[] keyBlob(BigInteger publicExponent, BigInteger modulus) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeLengthFirst("ssh-rsa".getBytes(), out);
        this.writeLengthFirst(publicExponent.toByteArray(), out);
        this.writeLengthFirst(modulus.toByteArray(), out);
        return out.toByteArray();
    }

    private void writeLengthFirst(byte[] array, ByteArrayOutputStream out) {
        out.write(array.length >>> 24 & 0xFF);
        out.write(array.length >>> 16 & 0xFF);
        out.write(array.length >>> 8 & 0xFF);
        out.write(array.length >>> 0 & 0xFF);
        if (array.length == 1 && array[0] == (byte)0) {
            out.write((byte[])Array$.MODULE$.ofDim(0, ClassTag$.MODULE$.Byte()));
        } else {
            out.write(array);
        }
    }

    private String hexColonDelimited(HashCode hc) {
        return ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(Splitter.fixedLength((int)2).split((CharSequence)BaseEncoding.base16().lowerCase().encode(hc.asBytes()))).asScala()).mkString(":");
    }

    private void initBouncyCastle() {
        SecurityKeys$ securityKeys$ = this;
        synchronized (securityKeys$) {
            Object object = Option$.MODULE$.apply((Object)Security.getProvider(BouncyCastleProvider.PROVIDER_NAME)).isEmpty() ? BoxesRunTime.boxToInteger((int)Security.addProvider((Provider)new BouncyCastleProvider())) : BoxedUnit.UNIT;
        }
    }

    private SecurityKeys$() {
        MODULE$ = this;
    }
}

