/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.pshirshov.izumitk.akka.http.util.logging;

import akka.event.Logging$;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.server.Rejection;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.directives.LogEntry;
import akka.http.scaladsl.server.directives.LogEntry$;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import org.bitbucket.pshirshov.izumitk.akka.http.util.logging.HttpDebugDirectives;
import org.bitbucket.pshirshov.izumitk.akka.http.util.logging.HttpDebugLogHandler;
import org.bitbucket.pshirshov.izumitk.akka.http.util.logging.HttpRequestContext;
import org.bitbucket.pshirshov.izumitk.akka.http.util.logging.HttpRequestFormatter;
import org.bitbucket.pshirshov.izumitk.json.JacksonMapper;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Future;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@Singleton
@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\u0001M\u0011q\u0003\u0013;ua\u0012+'-^4ESJ,7\r^5wKNLU\u000e\u001d7\u000b\u0005\r!\u0011a\u00027pO\u001eLgn\u001a\u0006\u0003\u000b\u0019\tA!\u001e;jY*\u0011q\u0001C\u0001\u0005QR$\bO\u0003\u0002\n\u0015\u0005!\u0011m[6b\u0015\tYA\"A\u0004juVl\u0017\u000e^6\u000b\u00055q\u0011!\u00039tQ&\u00148\u000f[8w\u0015\ty\u0001#A\u0005cSR\u0014WoY6fi*\t\u0011#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001)i\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0007CA\u000e\u001d\u001b\u0005\u0011\u0011BA\u000f\u0003\u0005MAE\u000f\u001e9EK\n,x\rR5sK\u000e$\u0018N^3t\u0011!y\u0002A!b\u0001\n\u0003\u0002\u0013AF5t%\u0016\fX/Z:ug\u0012+'-^4F]\u0006\u0014G.\u001a3\u0016\u0003\u0005\u0002\"!\u0006\u0012\n\u0005\r2\"a\u0002\"p_2,\u0017M\u001c\u0005\tK\u0001\u0011\t\u0011)A\u0005C\u00059\u0012n\u001d*fcV,7\u000f^:EK\n,x-\u00128bE2,G\r\t\u0005\tO\u0001\u0011\t\u0011)A\u0005C\u0005yA-\u001a2vOJ+'.Z2uS>t7\u000f\u000b\u0003'SU2\u0004C\u0001\u00164\u001b\u0005Y#B\u0001\u0017.\u0003\u0011q\u0017-\\3\u000b\u00059z\u0013AB5oU\u0016\u001cGO\u0003\u00021c\u00051qm\\8hY\u0016T\u0011AM\u0001\u0004G>l\u0017B\u0001\u001b,\u0005\u0015q\u0015-\\3e\u0003\u00151\u0018\r\\;fC\u00059\u0014A\u0006!iiR\u0004h\u0006Z3ck\u001et#/\u001a6fGRLwN\\:\t\u0011e\u0002!\u0011!Q\u0001\ni\nA\u0003\u001b;uaJ+\u0017/^3ti\u001a{'/\\1ui\u0016\u0014\bCA\u000e<\u0013\ta$A\u0001\u000bIiR\u0004(+Z9vKN$hi\u001c:nCR$XM\u001d\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f\u0005\u0019\u0002\u000e\u001e;q\t\u0016\u0014Wo\u001a'pO\"\u000bg\u000e\u001a7feB\u00111\u0004Q\u0005\u0003\u0003\n\u00111\u0003\u0013;ua\u0012+'-^4M_\u001eD\u0015M\u001c3mKJD\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001R\u0001\u0007[\u0006\u0004\b/\u001a:\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001dS\u0011\u0001\u00026t_:L!!\u0013$\u0003\u001b)\u000b7m[:p]6\u000b\u0007\u000f]3sQ\u0011\u0011\u0015&N&\"\u00031\u000bA\u0002^=qS:<W*\u00199qKJDQA\u0014\u0001\u0005\u0002=\u000ba\u0001P5oSRtDC\u0002)R+^C\u0016\f\u0005\u0002\u001c\u0001!)q$\u0014a\u0001C!\"\u0011+K\u001bTC\u0005!\u0016\u0001\u0006!iiR\u0004h\u0006Z3ck\u001et#/Z9vKN$8\u000fC\u0003(\u001b\u0002\u0007\u0011\u0005\u000b\u0003VSU2\u0004\"B\u001dN\u0001\u0004Q\u0004\"\u0002 N\u0001\u0004y\u0004\"B\"N\u0001\u0004!\u0005\u0006B-*k-C#!\u0014/\u0011\u0005usV\"A\u0017\n\u0005}k#AB%oU\u0016\u001cG\u000fC\u0004b\u0001\t\u0007I\u0011\u00032\u0002\u00191|wmZ5oO2+g/\u001a7\u0016\u0003\r\u0004\"\u0001Z6\u000f\u0005\u0015LW\"\u00014\u000b\u0005\u001dD\u0017!B3wK:$(\"A\u0005\n\u0005)4\u0017a\u0002'pO\u001eLgnZ\u0005\u0003Y6\u0014\u0001\u0002T8h\u0019\u00164X\r\u001c\u0006\u0003U\u001aDaa\u001c\u0001!\u0002\u0013\u0019\u0017!\u00047pO\u001eLgn\u001a'fm\u0016d\u0007\u0005C\u0004r\u0001\t\u0007I\u0011\u0003:\u0002\u0017\u0011,'-^4NCJ\\WM]\u000b\u0002gB\u0011Ao\u001f\b\u0003kf\u0004\"A\u001e\f\u000e\u0003]T!\u0001\u001f\n\u0002\rq\u0012xn\u001c;?\u0013\tQh#\u0001\u0004Qe\u0016$WMZ\u0005\u0003yv\u0014aa\u0015;sS:<'B\u0001>\u0017\u0011\u0019y\b\u0001)A\u0005g\u0006aA-\u001a2vO6\u000b'o[3sA!9\u00111\u0001\u0001\u0005R\u0005\u0015\u0011aD2p]R,\u0007\u0010\u001e+p'R\u0014\u0018N\\4\u0015\u0007M\f9\u0001\u0003\u0005\u0002\n\u0005\u0005\u0001\u0019AA\u0006\u0003\u001d\u0019wN\u001c;fqR\u00042aGA\u0007\u0013\r\tyA\u0001\u0002\u0013\u0011R$\bOU3rk\u0016\u001cHoQ8oi\u0016DH\u000fC\u0004\u0002\u0014\u0001!\t&!\u0006\u0002\u001fM$(/\u001b8h)>\u001cuN\u001c;fqR$B!a\u0003\u0002\u0018!9\u0011\u0011DA\t\u0001\u0004\u0019\u0018AB:ue&tw\rC\u0004\u0002\u001e\u0001!\t&a\b\u0002%I,\u0017/^3tiJ+7\u000f]8og\u0016dun\u001a\u000b\t\u0003C\ti$!\u0014\u0002ZA)Q#a\t\u0002(%\u0019\u0011Q\u0005\f\u0003\r=\u0003H/[8o!\u0011\tI#!\u000f\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\t!\u0002Z5sK\u000e$\u0018N^3t\u0015\u0011\t\t$a\r\u0002\rM,'O^3s\u0015\u0011\t)$a\u000e\u0002\u0011M\u001c\u0017\r\\1eg2T!a\u00025\n\t\u0005m\u00121\u0006\u0002\t\u0019><WI\u001c;ss\"A\u0011qHA\u000e\u0001\u0004\t\t%A\u0004sKF,Xm\u001d;\u0011\t\u0005\r\u0013\u0011J\u0007\u0003\u0003\u000bRA!a\u0012\u00024\u0005)Qn\u001c3fY&!\u00111JA#\u0005-AE\u000f\u001e9SKF,Xm\u001d;\t\u0011\u0005=\u00131\u0004a\u0001\u0003#\naA]3tk2$\b\u0003BA*\u0003+j!!a\f\n\t\u0005]\u0013q\u0006\u0002\f%>,H/\u001a*fgVdG\u000f\u0003\u0005\u0002\n\u0005m\u0001\u0019AA\u0006Q\r\u0001\u0011Q\f\t\u0004;\u0006}\u0013bAA1[\tI1+\u001b8hY\u0016$xN\u001c")
public class HttpDebugDirectivesImpl
implements HttpDebugDirectives {
    private final boolean isRequestsDebugEnabled;
    @Named(value="@http.debug.rejections")
    private final boolean debugRejections;
    private final HttpRequestFormatter httpRequestFormatter;
    private final HttpDebugLogHandler httpDebugLogHandler;
    @Named(value="typingMapper")
    private final JacksonMapper mapper;
    private final int loggingLevel;
    private final String debugMarker;

    @Override
    public Function1<RequestContext, Future<RouteResult>> withDebug(Function1<RequestContext, Future<RouteResult>> route) {
        return HttpDebugDirectives.withDebug$(this, route);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> withDebugContext(HttpRequestContext context, Function1<RequestContext, Future<RouteResult>> route) {
        return HttpDebugDirectives.withDebugContext$(this, context, route);
    }

    @Override
    public Function1<HttpRequest, Function1<RouteResult, Option<LogEntry>>> show() {
        return HttpDebugDirectives.show$(this);
    }

    @Override
    public boolean isRequestsDebugEnabled() {
        return this.isRequestsDebugEnabled;
    }

    public int loggingLevel() {
        return this.loggingLevel;
    }

    public String debugMarker() {
        return this.debugMarker;
    }

    @Override
    public String contextToString(HttpRequestContext context) {
        return this.mapper.writeValueAsString((Object)context);
    }

    @Override
    public HttpRequestContext stringToContext(String string) {
        return (HttpRequestContext)this.mapper.readValue(string, ManifestFactory$.MODULE$.classType(HttpRequestContext.class));
    }

    @Override
    public Option<LogEntry> requestResponseLog(HttpRequest request, RouteResult result, HttpRequestContext context) {
        None$ none$;
        Some out;
        Some some;
        RouteResult routeResult = result;
        if (routeResult instanceof RouteResult.Complete) {
            RouteResult.Complete complete = (RouteResult.Complete)routeResult;
            some = new Some((Object)this.httpRequestFormatter.requestResponsePairToString(request, complete.response()));
        } else if (routeResult instanceof RouteResult.Rejected) {
            RouteResult.Rejected rejected = (RouteResult.Rejected)routeResult;
            Seq rejections = rejected.rejections();
            some = this.debugRejections && this.httpDebugLogHandler.accepts((Seq<Rejection>)rejections) ? new Some((Object)this.httpRequestFormatter.requestRejectionPairToString(request, (Seq<Rejection>)rejections)) : None$.MODULE$;
        } else {
            throw new MatchError((Object)routeResult);
        }
        Some some2 = out = some;
        if (some2 instanceof Some) {
            Some some3 = some2;
            String repr = (String)some3.value();
            String shifted = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])repr.split("\n"))).mkString("\n    ");
            LogEntry entry = LogEntry$.MODULE$.apply((Object)shifted, this.debugMarker(), this.loggingLevel());
            this.httpDebugLogHandler.handleLog(entry, context);
            none$ = new Some((Object)entry);
        } else if (None$.MODULE$.equals(some2)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)some2);
        }
        return none$;
    }

    @Inject
    public HttpDebugDirectivesImpl(@Named(value="@http.debug.requests") boolean isRequestsDebugEnabled, @Named(value="@http.debug.rejections") boolean debugRejections, HttpRequestFormatter httpRequestFormatter, HttpDebugLogHandler httpDebugLogHandler, @Named(value="typingMapper") JacksonMapper mapper) {
        this.isRequestsDebugEnabled = isRequestsDebugEnabled;
        this.debugRejections = debugRejections;
        this.httpRequestFormatter = httpRequestFormatter;
        this.httpDebugLogHandler = httpDebugLogHandler;
        this.mapper = mapper;
        HttpDebugDirectives.$init$(this);
        this.loggingLevel = Logging$.MODULE$.InfoLevel();
        this.debugMarker = "HTTP-API";
    }
}

