/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.pshirshov.izumitk.akka.http.util.logging;

import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.server.Rejection;
import akka.stream.Materializer;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.bitbucket.pshirshov.izumitk.akka.http.util.logging.ExceptionCause$;
import org.bitbucket.pshirshov.izumitk.akka.http.util.logging.HttpRequestFormatter;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Singleton
@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0001M\u0011\u0001\u0004\u0013;uaJ+\u0017/^3ti\u001a{'/\\1ui\u0016\u0014\u0018*\u001c9m\u0015\t\u0019A!A\u0004m_\u001e<\u0017N\\4\u000b\u0005\u00151\u0011\u0001B;uS2T!a\u0002\u0005\u0002\t!$H\u000f\u001d\u0006\u0003\u0013)\tA!Y6lC*\u00111\u0002D\u0001\bSj,X.\u001b;l\u0015\tia\"A\u0005qg\"L'o\u001d5pm*\u0011q\u0002E\u0001\nE&$(-^2lKRT\u0011!E\u0001\u0004_J<7\u0001A\n\u0004\u0001QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u001c95\t!!\u0003\u0002\u001e\u0005\t!\u0002\n\u001e;q%\u0016\fX/Z:u\r>\u0014X.\u0019;uKJD\u0001b\b\u0001\u0003\u0006\u0004%\u0019\u0002I\u0001\r[\u0006$XM]5bY&TXM]\u000b\u0002CA\u0011!EJ\u0007\u0002G)\u0011A%J\u0001\u0007gR\u0014X-Y7\u000b\u0003%I!aJ\u0012\u0003\u00195\u000bG/\u001a:jC2L'0\u001a:\t\u0011%\u0002!\u0011!Q\u0001\n\u0005\nQ\"\\1uKJL\u0017\r\\5{KJ\u0004\u0003\"B\u0016\u0001\t\u0003a\u0013A\u0002\u001fj]&$h\bF\u0001.)\tqs\u0006\u0005\u0002\u001c\u0001!)qD\u000ba\u0002C!\u0012!&\r\t\u0003eej\u0011a\r\u0006\u0003iU\na!\u001b8kK\u000e$(B\u0001\u001c8\u0003\u00199wn\\4mK*\t\u0001(A\u0002d_6L!AO\u001a\u0003\r%s'.Z2u\u0011\u001da\u0004A1A\u0005\u0012u\n!#\\1sg\"\fG\u000e\\5oORKW.Z8viV\ta\b\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u0006AA-\u001e:bi&|gN\u0003\u0002D-\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u0015\u0003%A\u0004$j]&$X\rR;sCRLwN\u001c\u0005\u0007\u000f\u0002\u0001\u000b\u0011\u0002 \u0002'5\f'o\u001d5bY2Lgn\u001a+j[\u0016|W\u000f\u001e\u0011\t\u000f%\u0003!\u0019!C\u0005\u0015\u0006a1\u000f\u001d7jiR,'oU5{KV\t1\n\u0005\u0002\u0016\u0019&\u0011QJ\u0006\u0002\u0004\u0013:$\bBB(\u0001A\u0003%1*A\u0007ta2LG\u000f^3s'&TX\r\t\u0005\u0006#\u0002!\tAU\u0001\u001ce\u0016\fX/Z:u%\u0016\u001c\bo\u001c8tKB\u000b\u0017N\u001d+p'R\u0014\u0018N\\4\u0015\u0007Ms\u0016\u000e\u0005\u0002U7:\u0011Q+\u0017\t\u0003-Zi\u0011a\u0016\u0006\u00031J\ta\u0001\u0010:p_Rt\u0014B\u0001.\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011A,\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i3\u0002\"B0Q\u0001\u0004\u0001\u0017a\u0002:fcV,7\u000f\u001e\t\u0003C\u001el\u0011A\u0019\u0006\u0003G\u0012\fQ!\\8eK2T!!\u001a4\u0002\u0011M\u001c\u0017\r\\1eg2T!aB\u0013\n\u0005!\u0014'a\u0003%uiB\u0014V-];fgRDQA\u001b)A\u0002-\f\u0001B]3ta>t7/\u001a\t\u0003C2L!!\u001c2\u0003\u0019!#H\u000f\u001d*fgB|gn]3\t\u000b=\u0004A\u0011\u00019\u00029I,\u0017/^3tiJ+'.Z2uS>t\u0007+Y5s)>\u001cFO]5oOR\u00191+\u001d:\t\u000b}s\u0007\u0019\u00011\t\u000bMt\u0007\u0019\u0001;\u0002\u0015I,'.Z2uS>t7\u000fE\u0002vurl\u0011A\u001e\u0006\u0003ob\f\u0011\"[7nkR\f'\r\\3\u000b\u0005e4\u0012AC2pY2,7\r^5p]&\u00111P\u001e\u0002\u0004'\u0016\f\bcA?\u0002\u00025\taP\u0003\u0002\u0000I\u000611/\u001a:wKJL1!a\u0001\u007f\u0005%\u0011VM[3di&|g\u000eC\u0004\u0002\b\u0001!I!!\u0003\u0002\u001d\u0019|'/\\1u%\u0016\u001c\bo\u001c8tKR\u00191+a\u0003\t\r)\f)\u00011\u0001l\u0011\u001d\ty\u0001\u0001C\u0005\u0003#\tQBZ8s[\u0006$(+Z9vKN$HcA*\u0002\u0014!1q,!\u0004A\u0002\u0001Dq!a\u0006\u0001\t\u0013\tI\"\u0001\bf]RLG/\u001f+p'R\u0014\u0018N\\4\u0015\r\u0005m\u0011\u0011FA\u001a!\u0011\ti\"a\n\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\tA\u0001\\1oO*\u0011\u0011QE\u0001\u0005U\u00064\u0018-C\u0002]\u0003?A\u0001\"a\u000b\u0002\u0016\u0001\u0007\u0011QF\u0001\u0007K:$\u0018\u000e^=\u0011\u0007\u0005\fy#C\u0002\u00022\t\u0014!\u0002\u0013;ua\u0016sG/\u001b;z\u0011\u001d\t)$!\u0006A\u0002M\u000b\u0001\"\\8sK\u0012\u000bG/\u0019\u0005\b\u0003s\u0001A\u0011BA\u001e\u0003)\tG\rZ'fgN\fw-\u001a\u000b\t\u0003{\tI%!\u0018\u0002bA!\u0011qHA#\u001b\t\t\tEC\u0002\u0002Da\fq!\\;uC\ndW-\u0003\u0003\u0002H\u0005\u0005#!D*ue&twMQ;jY\u0012,'\u000f\u0003\u0005\u0002L\u0005]\u0002\u0019AA'\u00035\u0019HO]5oO\n+\u0018\u000e\u001c3feB!\u0011qJA-\u001d\u0011\t\t&!\u0016\u000f\u0007Y\u000b\u0019&C\u0001\u0018\u0013\r\t9FF\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9%a\u0017\u000b\u0007\u0005]c\u0003C\u0004\u0002`\u0005]\u0002\u0019A*\u0002\u000f5,7o]1hK\"A\u00111MA\u001c\u0001\u0004\t)'\u0001\u0004gS2dWM\u001d\t\u0004+\u0005\u001d\u0014bAA5-\t!1\t[1s\u0011\u001d\ti\u0007\u0001C\u0005\u0003_\nqBZ8s[\u0006$(+\u001a6fGRLwN\u001c\u000b\u0004'\u0006E\u0004BB:\u0002l\u0001\u0007A\u000fK\u0002\u0001\u0003k\u00022AMA<\u0013\r\tIh\r\u0002\n'&tw\r\\3u_:\u0004")
public class HttpRequestFormatterImpl
implements HttpRequestFormatter {
    private final Materializer materializer;
    private final FiniteDuration marshallingTimeout;
    private final int splitterSize;

    public Materializer materializer() {
        return this.materializer;
    }

    public FiniteDuration marshallingTimeout() {
        return this.marshallingTimeout;
    }

    private int splitterSize() {
        return this.splitterSize;
    }

    @Override
    public String requestResponsePairToString(HttpRequest request, HttpResponse response) {
        return this.formatRequest(request) + this.formatResponse(response);
    }

    @Override
    public String requestRejectionPairToString(HttpRequest request, scala.collection.immutable.Seq<Rejection> rejections) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.formatRequest(request));
        this.addMessage(stringBuilder, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RESPONSE (REJECTION)"})).s((Seq)Nil$.MODULE$), '-');
        stringBuilder.append('\n');
        stringBuilder.append(this.formatRejection(rejections));
        stringBuilder.append('\n');
        stringBuilder.append(new StringOps(Predef$.MODULE$.augmentString("=")).$times(this.splitterSize()));
        return stringBuilder.toString();
    }

    private String formatResponse(HttpResponse response) {
        BoxedUnit boxedUnit;
        StringBuilder stringBuilder = new StringBuilder();
        this.addMessage(stringBuilder, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RESPONSE"})).s((Seq)Nil$.MODULE$), '-');
        stringBuilder.append('\n');
        if (response.headers().nonEmpty()) {
            stringBuilder.append(((TraversableOnce)response.headers().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.renderInResponses()))).mkString("\n"));
            boxedUnit = stringBuilder.append('\n');
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        stringBuilder.append('\n');
        stringBuilder.append(this.entityToString((HttpEntity)response.entity(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"code: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response.status()}))));
        stringBuilder.append('\n');
        stringBuilder.append(new StringOps(Predef$.MODULE$.augmentString("=")).$times(this.splitterSize()));
        return stringBuilder.toString();
    }

    private String formatRequest(HttpRequest request) {
        BoxedUnit boxedUnit;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\n');
        this.addMessage(stringBuilder, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REQUEST"})).s((Seq)Nil$.MODULE$), '=');
        stringBuilder.append('\n');
        stringBuilder.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.method().name(), request.uri()})));
        stringBuilder.append('\n');
        if (request.headers().nonEmpty()) {
            stringBuilder.append(((TraversableOnce)request.headers().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.renderInRequests()))).mkString("\n"));
            boxedUnit = stringBuilder.append('\n');
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        stringBuilder.append('\n');
        stringBuilder.append(this.entityToString((HttpEntity)request.entity(), ""));
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    private String entityToString(HttpEntity entity, String moreData) {
        BoxedUnit boxedUnit;
        HttpEntity.Strict strict = (HttpEntity.Strict)Await$.MODULE$.result((Awaitable)entity.toStrict(this.marshallingTimeout(), this.materializer()), (Duration)this.marshallingTimeout());
        String asString = strict.getData().utf8String();
        StringBuilder stringBuilder = new StringBuilder();
        if (new StringOps(Predef$.MODULE$.augmentString(asString)).nonEmpty()) {
            stringBuilder.append(asString);
            boxedUnit = stringBuilder.append('\n');
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.addMessage(stringBuilder, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "content type: ", ", size: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{moreData, entity.contentType(), BoxesRunTime.boxToInteger((int)asString.length())})), '-');
        return stringBuilder.toString();
    }

    private StringBuilder addMessage(StringBuilder stringBuilder, String message, char filler) {
        int fillersSize = (this.splitterSize() - message.length() - 2) / 2;
        stringBuilder.append(new StringOps(Predef$.MODULE$.augmentString(((Object)BoxesRunTime.boxToCharacter((char)filler)).toString())).$times(fillersSize));
        stringBuilder.append(' ');
        stringBuilder.append(message);
        stringBuilder.append(' ');
        return stringBuilder.append(new StringOps(Predef$.MODULE$.augmentString(((Object)BoxesRunTime.boxToCharacter((char)filler)).toString())).$times(fillersSize));
    }

    private String formatRejection(scala.collection.immutable.Seq<Rejection> rejections) {
        return ((TraversableOnce)rejections.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            Rejection rejection = x0$1;
            Option<Object> option = ExceptionCause$.MODULE$.unapply(rejection);
            if (!option.isEmpty()) {
                Object t = option.get();
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"==> Rejection caused by Exception: ", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rejection, t}));
            } else {
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"==> Rejection: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rejection}));
            }
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    @Inject
    public HttpRequestFormatterImpl(Materializer materializer) {
        this.materializer = materializer;
        this.marshallingTimeout = FiniteDuration$.MODULE$.apply(5L, TimeUnit.SECONDS);
        this.splitterSize = 120;
    }
}

