/*
 * Decompiled with CFR 0.152.
 */
package org.swat.cache.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ExpiryCache<K, V> {
    private final int millis;
    private final Map<K, ExpiryBean<V>> cache = new ConcurrentHashMap<K, ExpiryBean<V>>();

    public ExpiryCache(int expiryMillis) {
        this.millis = expiryMillis;
    }

    public V put(K key, V value) {
        return this.put(key, value, this.millis);
    }

    public V put(K key, V value, int millis) {
        if (key == null) {
            return null;
        }
        ExpiryBean bean = this.cache.put(key, new ExpiryBean(value, millis));
        if (bean == null || bean.expireAt < System.currentTimeMillis()) {
            return null;
        }
        return (V)bean.value;
    }

    public int size() {
        return this.cache.size();
    }

    public void removeExpired() {
        for (K key : this.cache.keySet()) {
            this.get(key);
        }
    }

    public V get(K key) {
        if (key == null) {
            return null;
        }
        ExpiryBean<V> bean = this.cache.get(key);
        if (bean == null || ((ExpiryBean)bean).expireAt < System.currentTimeMillis()) {
            this.cache.remove(key);
            return null;
        }
        return (V)((ExpiryBean)bean).value;
    }

    public boolean contains(K key) {
        return this.get(key) != null;
    }

    private class ExpiryBean<T> {
        private final long expireAt;
        private final T value;

        private ExpiryBean(T value, int millis) {
            this.value = value;
            this.expireAt = System.currentTimeMillis() + (long)millis;
        }
    }
}

