/*
 * Decompiled with CFR 0.152.
 */
package org.swat.cache.utils;

import org.junit.Assert;
import org.junit.Test;
import org.swat.cache.utils.CacheAware;
import org.swat.cache.utils.ExpiryCache;

public class ExpiryCacheTest {
    @Test
    public void getPut() throws Exception {
        ExpiryCache expiryCache = new ExpiryCache(1000);
        expiryCache.put(null, null);
        Assert.assertEquals(null, (Object)expiryCache.get(null));
        expiryCache.put(null, (Object)"abc");
        Assert.assertEquals(null, (Object)expiryCache.get(null));
        expiryCache.put((Object)"name", null);
        Assert.assertEquals(null, (Object)expiryCache.get((Object)"name"));
        expiryCache.put((Object)"name", (Object)"abc");
        Assert.assertEquals((Object)"abc", (Object)expiryCache.get((Object)"name"));
        Thread.sleep(1001L);
        Assert.assertEquals(null, (Object)expiryCache.get((Object)"name"));
    }

    @Test
    public void put() throws Exception {
        ExpiryCache expiryCache = new ExpiryCache(1000);
        expiryCache.put((Object)"name", (Object)"abc");
        Assert.assertEquals((Object)"abc", (Object)expiryCache.put((Object)"name", (Object)"xyz"));
        Thread.sleep(1001L);
        Assert.assertEquals(null, (Object)expiryCache.put((Object)"name", (Object)"rst"));
    }

    @Test
    public void removeExpired() throws Exception {
        ExpiryCache expiryCache = new ExpiryCache(1000);
        expiryCache.put((Object)"name", (Object)"abc");
        Assert.assertEquals((long)1L, (long)expiryCache.size());
        Assert.assertTrue((boolean)expiryCache.contains((Object)"name"));
        Thread.sleep(1001L);
        expiryCache.removeExpired();
        Assert.assertFalse((boolean)expiryCache.contains((Object)"name"));
        Assert.assertEquals((long)0L, (long)expiryCache.size());
    }

    @Test
    public void nullValue() throws Exception {
        ExpiryCache expiryCache = new ExpiryCache(1000);
        expiryCache.put((Object)"name", null);
        Assert.assertEquals((long)1L, (long)expiryCache.size());
        Assert.assertTrue((boolean)expiryCache.contains((Object)"name"));
        Thread.sleep(1001L);
        expiryCache.removeExpired();
        Assert.assertFalse((boolean)expiryCache.contains((Object)"name"));
        Assert.assertEquals((long)0L, (long)expiryCache.size());
    }

    @Test
    public void clearAll() {
        ExpiryCache expiryCache = new ExpiryCache(1000);
        expiryCache.put((Object)"name", (Object)"Swat");
        Assert.assertEquals((Object)"Swat", (Object)expiryCache.get((Object)"name"));
        CacheAware.clearAll();
        Assert.assertNull((Object)expiryCache.get((Object)"name"));
    }
}

