/*
 * Decompiled with CFR 0.152.
 */
package org.swat.mongo.dao;

import com.mongodb.WriteResult;
import java.util.List;
import java.util.UUID;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.mongodb.InvalidMongoDbApiUsageException;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.swat.core.utils.CoreInterceptor;
import org.swat.datastore.base.RequestContext;
import org.swat.mongo.dao.AbstractEntity;
import org.swat.mongo.dao.AbstractEntityDao;
import org.swat.mongo.dao.DirectEntityDaoImpl;
import org.swat.mongo.dao.TenantAwareQuery;

public abstract class AbstractEntityDaoImpl<T extends AbstractEntity>
implements AbstractEntityDao<T> {
    private static final FindAndModifyOptions UPDATE_NEW = FindAndModifyOptions.options().returnNew(true);
    private static final FindAndModifyOptions UPSERT_NEW = FindAndModifyOptions.options().returnNew(true).upsert(true);
    private static final FindAndModifyOptions UPSERT_OLD = FindAndModifyOptions.options().returnNew(false).upsert(true);
    public final Class<T> clazz;
    public final String tenantKey;
    private final String defaultCollectionName;

    protected AbstractEntityDaoImpl(Class<T> clazz) {
        this(clazz, "tenantId");
    }

    protected AbstractEntityDaoImpl(Class<T> clazz, String tenantKey) {
        this.clazz = clazz;
        this.tenantKey = tenantKey;
        if (clazz != null) {
            String name = clazz.getSimpleName();
            this.defaultCollectionName = name = StringUtils.uncapitalize((String)name.substring(0, 1)) + name.substring(1);
        } else {
            this.defaultCollectionName = null;
        }
    }

    protected String getEntityId(T entity) {
        throw new UnsupportedOperationException("This method is not implemented");
    }

    protected MatchOperation getMatchOperation() {
        return Aggregation.match((Criteria)this.getCriteria());
    }

    protected Criteria getCriteria() {
        Criteria criteria = new Criteria();
        if (StringUtils.isNotBlank((CharSequence)this.tenantKey)) {
            criteria.and(this.tenantKey).is(RequestContext.getTenantId());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getDeletedKey())) {
            criteria.and(this.getDeletedKey()).is((Object)false);
        }
        return criteria;
    }

    protected String getDeletedKey() {
        return null;
    }

    @Override
    public T findAndRemove(Query query) {
        return (T)((AbstractEntity)this.getMongoTemplate().findAndRemove(this.getTenantQuery(query), this.clazz, this.getCollectionName()));
    }

    @Override
    public final int removeAll(Query query) {
        WriteResult result = this.getMongoTemplate().remove(this.getTenantQuery(query), this.getCollectionName());
        return result.getN();
    }

    protected abstract MongoTemplate getMongoTemplate();

    protected Query getTenantQuery(Query query) {
        if (query == null) {
            query = new Query();
        }
        if (StringUtils.isNotBlank((CharSequence)this.tenantKey)) {
            this.addCriteria(query, this.tenantKey, RequestContext.getTenantId());
        }
        this.addCriteria(query, this.getDeletedKey(), false);
        return query;
    }

    protected String getCollectionName() {
        return this.defaultCollectionName;
    }

    void addCriteria(Query query, String key, Object value) {
        block3: {
            if (StringUtils.isNotBlank((CharSequence)key)) {
                try {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)key).is(value));
                }
                catch (InvalidMongoDbApiUsageException e) {
                    String message = e.getMessage();
                    if (message.contains("Query already contains") && message.contains(String.valueOf(value))) break block3;
                    throw e;
                }
            }
        }
    }

    @Override
    public AbstractEntityDao<T> withDirect() {
        return new DirectEntityDaoImpl<T>(this, this.clazz, this.tenantKey, true, true);
    }

    @Override
    public AbstractEntityDao<T> withDirectQuery() {
        return new DirectEntityDaoImpl<T>(this, this.clazz, this.tenantKey, true, false);
    }

    @Override
    public AbstractEntityDao<T> withDirectUpdate() {
        return new DirectEntityDaoImpl<T>(this, this.clazz, this.tenantKey, false, true);
    }

    protected Update setValues(Update update) {
        if (StringUtils.isNotBlank((CharSequence)this.getCreatedKey())) {
            update.setOnInsert(this.getCreatedKey(), this.getNow());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getCreatedByKey())) {
            update.setOnInsert(this.getCreatedByKey(), RequestContext.getUserId());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getUpdatedKey())) {
            update.set(this.getUpdatedKey(), this.getNow());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getUpdatedByKey())) {
            update.set(this.getUpdatedByKey(), RequestContext.getUserId());
        }
        if (StringUtils.isNotBlank((CharSequence)this.tenantKey)) {
            update.set(this.tenantKey, RequestContext.getTenantId());
        }
        return update;
    }

    protected String getCreatedKey() {
        return null;
    }

    protected Object getNow() {
        return System.currentTimeMillis();
    }

    protected String getCreatedByKey() {
        return null;
    }

    protected String getUpdatedKey() {
        return null;
    }

    protected String getUpdatedByKey() {
        return null;
    }

    @Override
    public BulkOperations bulkOperations(BulkOperations.BulkMode bulkMode) {
        BulkOperations bulkOperations = this.getMongoTemplate().bulkOps(bulkMode, this.clazz, this.getCollectionName());
        return (BulkOperations)CoreInterceptor.intercept((Object)bulkOperations, (MethodInterceptor)new BulkOperationInterceptor());
    }

    @Override
    public T findById(String id) {
        Query query = TenantAwareQuery.query(this.tenantKey, (CriteriaDefinition)Criteria.where((String)"_id").is((Object)id));
        return this.findOne(query);
    }

    @Override
    public T findOne(Query query) {
        return (T)((AbstractEntity)this.getMongoTemplate().findOne(this.getTenantQuery(query), this.clazz, this.getCollectionName()));
    }

    @Override
    public T insert(T entity) {
        this.setValuesOnInsert(entity);
        this.getMongoTemplate().insert(entity, this.getCollectionName());
        return entity;
    }

    private void setValuesOnInsert(T entity) {
        String id = UUID.randomUUID().toString();
        this.setEntityId(entity, id);
        if (StringUtils.isNotBlank((CharSequence)this.getCreatedKey())) {
            entity.createdAt(this.getNow());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getCreatedByKey())) {
            entity.createdBy(RequestContext.getUserId());
        }
        this.setValuesOnUpdate(entity);
    }

    protected abstract void setEntityId(T var1, String var2);

    private void setValuesOnUpdate(T entity) {
        if (StringUtils.isNotBlank((CharSequence)this.getUpdatedKey())) {
            entity.updatedAt(this.getNow());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getUpdatedByKey())) {
            entity.updatedBy(RequestContext.getUserId());
        }
        this.setTenantId(entity, RequestContext.getTenantId());
    }

    protected final void setTenantId(T entity, Object tenantId) {
        if (StringUtils.isNotBlank((CharSequence)this.tenantKey)) {
            entity.tenantId(tenantId);
        }
    }

    @Override
    public T save(T entity) {
        if (StringUtils.isBlank((CharSequence)this.getEntityId(entity))) {
            this.setValuesOnInsert(entity);
        } else {
            this.setValuesOnUpdate(entity);
        }
        this.getMongoTemplate().save(entity, this.getCollectionName());
        return entity;
    }

    @Override
    public List<T> findAll() {
        return this.findAll(null);
    }

    @Override
    public List<T> findAll(Query query) {
        return this.getMongoTemplate().find(this.getTenantQuery(query), this.clazz, this.getCollectionName());
    }

    @Override
    public T findAndModify(Query query, Update update) {
        this.setValues(update);
        return (T)((AbstractEntity)this.getMongoTemplate().findAndModify(this.getTenantQuery(query), update, this.clazz, this.getCollectionName()));
    }

    @Override
    public T updateById(String id, Update update) {
        Query query = TenantAwareQuery.query(this.tenantKey, (CriteriaDefinition)Criteria.where((String)"_id").is((Object)id));
        return this.modifyAndFind(query, update);
    }

    @Override
    public T modifyAndFind(Query query, Update update) {
        this.setValues(update);
        return (T)((AbstractEntity)this.getMongoTemplate().findAndModify(this.getTenantQuery(query), update, UPDATE_NEW, this.clazz, this.getCollectionName()));
    }

    @Override
    public T upsert(Query query, Update update) {
        this.setValues(update);
        return (T)((AbstractEntity)this.getMongoTemplate().findAndModify(this.getTenantQuery(query), update, UPSERT_NEW, this.clazz, this.getCollectionName()));
    }

    @Override
    public T upsertReturnOld(Query query, Update update) {
        this.setValues(update);
        return (T)((AbstractEntity)this.getMongoTemplate().findAndModify(this.getTenantQuery(query), update, UPSERT_OLD, this.clazz, this.getCollectionName()));
    }

    @Override
    public T removeAndInsert(Query query, T entity) {
        this.setValuesOnInsert(entity);
        T oldEntity = this.findAndRemove(this.getTenantQuery(query));
        if (oldEntity != null) {
            if (StringUtils.isNotBlank((CharSequence)this.getCreatedKey())) {
                entity.createdAt(oldEntity.createdAt());
            }
            if (StringUtils.isNotBlank((CharSequence)this.getCreatedByKey())) {
                entity.createdBy(oldEntity.createdBy());
            }
            this.setEntityId(entity, this.getEntityId(oldEntity));
        }
        this.getMongoTemplate().insert(entity, this.getCollectionName());
        return entity;
    }

    @Override
    public T deleteById(String id) {
        Query query = TenantAwareQuery.query(this.tenantKey, (CriteriaDefinition)Criteria.where((String)"_id").is((Object)id));
        return this.findAndRemove(this.getTenantQuery(query));
    }

    @Override
    public void updateMulti(Query query, Update update) {
        this.setValues(update);
        this.getMongoTemplate().updateMulti(this.getTenantQuery(query), update, this.clazz, this.getCollectionName());
    }

    @Override
    public <R> List<R> distinct(String fieldName, Query query) {
        query = this.getTenantQuery(query);
        query.fields().include(fieldName);
        return this.getMongoTemplate().getCollection(this.getCollectionName()).distinct(fieldName, query.getQueryObject());
    }

    private class BulkOperationInterceptor
    implements MethodInterceptor {
        private BulkOperationInterceptor() {
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            Object[] params = methodInvocation.getArguments();
            if (params != null) {
                for (Object object : params) {
                    if (object == null) continue;
                    if (object instanceof Query) {
                        AbstractEntityDaoImpl.this.getTenantQuery((Query)object);
                        continue;
                    }
                    if (object instanceof Update) {
                        AbstractEntityDaoImpl.this.setValues((Update)object);
                        continue;
                    }
                    if (!methodInvocation.getMethod().getName().contains("insert") || !AbstractEntityDaoImpl.this.clazz.isAssignableFrom(object.getClass())) continue;
                    AbstractEntityDaoImpl.this.setValuesOnInsert((AbstractEntity)object);
                }
            }
            return methodInvocation.proceed();
        }
    }
}

