/*
 * Decompiled with CFR 0.152.
 */
package org.swat.mongo.dao;

import org.apache.commons.lang3.StringUtils;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.swat.datastore.base.RequestContext;

public class TenantAwareQuery
extends Query {
    private static final String DEFAULT_TENANT_KEY = "tenantId";

    public TenantAwareQuery() {
        this(DEFAULT_TENANT_KEY);
    }

    public TenantAwareQuery(String tenantKey) {
        if (StringUtils.isNotBlank((CharSequence)tenantKey)) {
            this.addCriteria((CriteriaDefinition)Criteria.where((String)tenantKey).is(RequestContext.getTenantId()));
        }
    }

    public static Query query(CriteriaDefinition criteriaDefinition) {
        return TenantAwareQuery.query(DEFAULT_TENANT_KEY, criteriaDefinition);
    }

    public static Query query(String tenantKey, CriteriaDefinition criteriaDefinition) {
        TenantAwareQuery query = new TenantAwareQuery(tenantKey);
        query.addCriteria(criteriaDefinition);
        return query;
    }
}

