/*
 * Decompiled with CFR 0.152.
 */
package org.swat.mongo.utils;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ReadConcern;
import com.mongodb.ReadConcernLevel;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.swat.core.utils.PropertyUtils;

public class MongoUtils {
    public static final String DESCRIPTION = "description";
    public static final String MIN_CONNECTIONS_PER_HOST = "minConnectionsPerHost";
    public static final String CONNECTIONS_PER_HOST = "connectionsPerHost";
    public static final String THREADS_ALLOWED_TO_BLOCK_FOR_CONNECTION_MULTIPLIER = "threadsAllowedToBlockForConnectionMultiplier";
    public static final String SERVER_SELECTION_TIMEOUT = "serverSelectionTimeout";
    public static final String MAX_WAIT_TIME = "maxWaitTime";
    public static final String MAX_CONNECTION_IDLE_TIME = "maxConnectionIdleTime";
    public static final String MAX_CONNECTION_LIFE_TIME = "maxConnectionLifeTime";
    public static final String CONNECT_TIMEOUT = "connectTimeout";
    public static final String SOCKET_TIMEOUT = "socketTimeout";
    @Deprecated
    public static final String SOCKET_KEEP_ALIVE = "socketKeepAlive";
    public static final String SSL_ENABLED = "sslEnabled";
    public static final String SSL_INVALID_HOST_NAME_ALLOWED = "sslInvalidHostNameAllowed";
    public static final String ALWAYS_USE_M_BEANS = "alwaysUseMBeans";
    public static final String HEARTBEAT_FREQUENCY = "heartbeatFrequency";
    public static final String MIN_HEARTBEAT_FREQUENCY = "minHeartbeatFrequency";
    public static final String HEARTBEAT_CONNECT_TIMEOUT = "heartbeatConnectTimeout";
    public static final String HEARTBEAT_SOCKET_TIMEOUT = "heartbeatSocketTimeout";
    public static final String LOCAL_THRESHOLD = "localThreshold";
    public static final String REQUIRED_REPLICA_SET_NAME = "requiredReplicaSetName";
    public static final String CURSOR_FINALIZER_ENABLED = "cursorFinalizerEnabled";
    public static final String APPLICATION_NAME = "applicationName";
    public static final String READ_PREFERENCE = "readPreference";
    public static final String WRITE_CONCERN = "writeConcern";
    public static final String READ_CONCERN = "readConcern";
    public static final String HOST_URL = "hostUrl";
    public static final String DB_NAME = "dbName";
    public static final String AUTH_DB_NAME = "authDbName";
    public static final String USER_NAME = "userName";
    public static final String PASSWORD = "password";
    private static final String[] KEYS = new String[]{"description", "minConnectionsPerHost", "connectionsPerHost", "threadsAllowedToBlockForConnectionMultiplier", "serverSelectionTimeout", "maxWaitTime", "maxConnectionIdleTime", "maxConnectionLifeTime", "connectTimeout", "socketTimeout", "socketKeepAlive", "sslEnabled", "sslInvalidHostNameAllowed", "alwaysUseMBeans", "heartbeatFrequency", "minHeartbeatFrequency", "heartbeatConnectTimeout", "heartbeatSocketTimeout", "localThreshold", "requiredReplicaSetName", "cursorFinalizerEnabled", "applicationName", "readPreference", "writeConcern", "readConcern", "hostUrl", "authDbName", "dbName", "userName", "password"};

    public static MongoClient getClient(Properties properties, String ... prefixes) {
        Properties props = MongoUtils.getMongoProperties(properties, prefixes);
        MongoClientOptions options = MongoUtils.getOptionsBuilder(props).build();
        ArrayList<MongoCredential> mongoCredentials = new ArrayList<MongoCredential>();
        String userName = props.getProperty(USER_NAME);
        String password = props.getProperty(PASSWORD);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{userName, password})) {
            String authDbName = props.getProperty(AUTH_DB_NAME);
            if (StringUtils.isBlank((CharSequence)authDbName)) {
                authDbName = props.getProperty(DB_NAME);
            }
            MongoCredential mongoCredential = MongoCredential.createCredential((String)userName, (String)authDbName, (char[])password.toCharArray());
            mongoCredentials.add(mongoCredential);
        }
        ArrayList<ServerAddress> servers = new ArrayList<ServerAddress>();
        String hostUrls = props.getProperty(HOST_URL);
        if (StringUtils.isBlank((CharSequence)hostUrls)) {
            hostUrls = "127.0.0.1";
        }
        for (String hostUrl : hostUrls.split(",")) {
            String host;
            int index = hostUrl.indexOf(58);
            int port = 27017;
            if (index == -1) {
                host = hostUrl;
            } else {
                host = hostUrl.substring(0, index);
                port = NumberUtils.toInt((String)hostUrl.substring(index + 1), (int)port);
            }
            ServerAddress server = new ServerAddress(host, port);
            servers.add(server);
        }
        return new MongoClient(servers, mongoCredentials, options);
    }

    public static Properties getMongoProperties(Properties properties, String ... prefixes) {
        return PropertyUtils.getProperties((Properties)properties, (String[])KEYS, (String[])prefixes);
    }

    public static MongoClientOptions.Builder getOptionsBuilder(Properties p) {
        MongoClientOptions.Builder builder = MongoClientOptions.builder();
        if (PropertyUtils.isConfigured((Properties)p, (String)DESCRIPTION)) {
            builder.description(PropertyUtils.getString((Properties)p, (String)DESCRIPTION));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)MIN_CONNECTIONS_PER_HOST)) {
            builder.minConnectionsPerHost(PropertyUtils.getInt((Properties)p, (String)MIN_CONNECTIONS_PER_HOST));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)CONNECTIONS_PER_HOST)) {
            builder.connectionsPerHost(PropertyUtils.getInt((Properties)p, (String)CONNECTIONS_PER_HOST));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)THREADS_ALLOWED_TO_BLOCK_FOR_CONNECTION_MULTIPLIER)) {
            builder.threadsAllowedToBlockForConnectionMultiplier(PropertyUtils.getInt((Properties)p, (String)THREADS_ALLOWED_TO_BLOCK_FOR_CONNECTION_MULTIPLIER));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)SERVER_SELECTION_TIMEOUT)) {
            builder.serverSelectionTimeout(PropertyUtils.getInt((Properties)p, (String)SERVER_SELECTION_TIMEOUT));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)MAX_WAIT_TIME)) {
            builder.maxWaitTime(PropertyUtils.getInt((Properties)p, (String)MAX_WAIT_TIME));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)MAX_CONNECTION_IDLE_TIME)) {
            builder.maxConnectionIdleTime(PropertyUtils.getInt((Properties)p, (String)MAX_CONNECTION_IDLE_TIME));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)MAX_CONNECTION_LIFE_TIME)) {
            builder.maxConnectionLifeTime(PropertyUtils.getInt((Properties)p, (String)MAX_CONNECTION_LIFE_TIME));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)CONNECT_TIMEOUT)) {
            builder.connectTimeout(PropertyUtils.getInt((Properties)p, (String)CONNECT_TIMEOUT));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)SOCKET_TIMEOUT)) {
            builder.socketTimeout(PropertyUtils.getInt((Properties)p, (String)SOCKET_TIMEOUT));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)SOCKET_KEEP_ALIVE)) {
            builder.socketKeepAlive(PropertyUtils.getBoolean((Properties)p, (String)SOCKET_KEEP_ALIVE));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)SSL_ENABLED)) {
            builder.sslEnabled(PropertyUtils.getBoolean((Properties)p, (String)SSL_ENABLED));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)SSL_INVALID_HOST_NAME_ALLOWED)) {
            builder.sslInvalidHostNameAllowed(PropertyUtils.getBoolean((Properties)p, (String)SSL_INVALID_HOST_NAME_ALLOWED));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)ALWAYS_USE_M_BEANS)) {
            builder.alwaysUseMBeans(PropertyUtils.getBoolean((Properties)p, (String)ALWAYS_USE_M_BEANS));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)HEARTBEAT_FREQUENCY)) {
            builder.heartbeatFrequency(PropertyUtils.getInt((Properties)p, (String)HEARTBEAT_FREQUENCY));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)MIN_HEARTBEAT_FREQUENCY)) {
            builder.minHeartbeatFrequency(PropertyUtils.getInt((Properties)p, (String)MIN_HEARTBEAT_FREQUENCY));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)HEARTBEAT_CONNECT_TIMEOUT)) {
            builder.heartbeatConnectTimeout(PropertyUtils.getInt((Properties)p, (String)HEARTBEAT_CONNECT_TIMEOUT));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)HEARTBEAT_SOCKET_TIMEOUT)) {
            builder.heartbeatSocketTimeout(PropertyUtils.getInt((Properties)p, (String)HEARTBEAT_SOCKET_TIMEOUT));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)LOCAL_THRESHOLD)) {
            builder.localThreshold(PropertyUtils.getInt((Properties)p, (String)LOCAL_THRESHOLD));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)REQUIRED_REPLICA_SET_NAME)) {
            builder.requiredReplicaSetName(PropertyUtils.getString((Properties)p, (String)REQUIRED_REPLICA_SET_NAME));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)CURSOR_FINALIZER_ENABLED)) {
            builder.cursorFinalizerEnabled(PropertyUtils.getBoolean((Properties)p, (String)CURSOR_FINALIZER_ENABLED));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)APPLICATION_NAME)) {
            builder.applicationName(PropertyUtils.getString((Properties)p, (String)APPLICATION_NAME));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)READ_PREFERENCE)) {
            builder.readPreference(ReadPreference.valueOf((String)PropertyUtils.getString((Properties)p, (String)READ_PREFERENCE)));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)WRITE_CONCERN)) {
            builder.writeConcern(WriteConcern.valueOf((String)PropertyUtils.getString((Properties)p, (String)WRITE_CONCERN)));
        }
        if (PropertyUtils.isConfigured((Properties)p, (String)READ_CONCERN)) {
            ReadConcernLevel level = ReadConcernLevel.valueOf((String)PropertyUtils.getString((Properties)p, (String)READ_CONCERN));
            builder.readConcern(new ReadConcern(level));
        }
        return builder;
    }

    public static MongoClientOptions.Builder getOptionsBuilder(Properties properties, String ... prefixes) {
        return MongoUtils.getOptionsBuilder(MongoUtils.getMongoProperties(properties, prefixes));
    }
}

