/*
 * Decompiled with CFR 0.152.
 */
package org.swat.mongo.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.swat.mongo.dao.AbstractEntity;
import org.swat.mongo.dao.AbstractEntityDaoImpl;
import org.swat.mongo.dao.MapEntity;

public abstract class AbstractReadOnlyEntityDaoImpl<T extends AbstractEntity>
extends AbstractEntityDaoImpl<T> {
    private final MapEntityDaoImpl mapEntityDao;
    private final String defaultCollectionName;
    public final Class<T> clazz;

    protected AbstractReadOnlyEntityDaoImpl(Class<T> clazz) {
        this(clazz, "tenantId");
    }

    protected AbstractReadOnlyEntityDaoImpl(Class<T> clazz, String tenantKey) {
        super(null, tenantKey);
        this.clazz = clazz;
        this.mapEntityDao = new MapEntityDaoImpl(MapEntity.class, tenantKey);
        String name = clazz.getSimpleName();
        this.defaultCollectionName = name = StringUtils.uncapitalize((String)name.substring(0, 1)) + name.substring(1);
    }

    @Override
    protected void setEntityId(T entity, String id) {
        throw new UnsupportedOperationException("Read Only collection");
    }

    @Override
    protected String getCollectionName() {
        return this.defaultCollectionName;
    }

    @Override
    public T findById(String id) {
        MapEntity mapEntity = (MapEntity)this.mapEntityDao.findById(id);
        return this.convert(mapEntity);
    }

    private T convert(MapEntity mapEntity) {
        if (mapEntity == null) {
            return null;
        }
        return this.convertMap(mapEntity);
    }

    protected abstract T convertMap(Map var1);

    @Override
    public T findOne(Query query) {
        MapEntity mapEntity = (MapEntity)this.mapEntityDao.findOne(query);
        return this.convert(mapEntity);
    }

    @Override
    public List<T> findAll() {
        ArrayList<T> list = new ArrayList<T>();
        List mapEntities = this.mapEntityDao.findAll();
        for (MapEntity mapEntity : mapEntities) {
            list.add(this.convert(mapEntity));
        }
        return list;
    }

    @Override
    public List<T> findAll(Query query) {
        ArrayList<T> list = new ArrayList<T>();
        List mapEntities = this.mapEntityDao.findAll(query);
        for (MapEntity mapEntity : mapEntities) {
            list.add(this.convert(mapEntity));
        }
        return list;
    }

    @Override
    public final T findAndRemove(Query query) {
        throw new UnsupportedOperationException("Read Only collection");
    }

    @Override
    public final T insert(T entity) {
        throw new UnsupportedOperationException("Read Only collection");
    }

    @Override
    public final T save(T entity) {
        throw new UnsupportedOperationException("Read Only collection");
    }

    @Override
    public final T findAndModify(Query query, Update update) {
        throw new UnsupportedOperationException("Read Only collection");
    }

    @Override
    public final T updateById(String id, Update update) {
        throw new UnsupportedOperationException("Read Only collection");
    }

    @Override
    public final T modifyAndFind(Query query, Update update) {
        throw new UnsupportedOperationException("Read Only collection");
    }

    @Override
    public final T upsert(Query query, Update update) {
        throw new UnsupportedOperationException("Read Only collection");
    }

    @Override
    public final T upsertReturnOld(Query query, Update update) {
        throw new UnsupportedOperationException("Read Only collection");
    }

    @Override
    public final T removeAndInsert(Query query, T entity) {
        throw new UnsupportedOperationException("Read Only collection");
    }

    @Override
    public final T deleteById(String id) {
        throw new UnsupportedOperationException("Read Only collection");
    }

    @Override
    public final void updateMulti(Query query, Update update) {
        throw new UnsupportedOperationException("Read Only collection");
    }

    private class MapEntityDaoImpl
    extends AbstractEntityDaoImpl<MapEntity> {
        protected MapEntityDaoImpl(Class<MapEntity> clazz, String tenantKey) {
            super(clazz, tenantKey);
        }

        @Override
        protected MongoTemplate getMongoTemplate() {
            return AbstractReadOnlyEntityDaoImpl.this.getMongoTemplate();
        }

        @Override
        protected void setEntityId(MapEntity entity, String id) {
            throw new UnsupportedOperationException("Read Only collection");
        }

        @Override
        protected String getCollectionName() {
            return AbstractReadOnlyEntityDaoImpl.this.getCollectionName();
        }

        @Override
        protected String getDeletedKey() {
            return AbstractReadOnlyEntityDaoImpl.this.getDeletedKey();
        }
    }
}

