/*
 * Decompiled with CFR 0.152.
 */
package org.swat.mongo.dao;

import com.mongodb.annotations.Beta;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.swat.mongo.dao.AbstractEntity;
import org.swat.mongo.dao.AbstractEntityDaoImpl;

@Beta
public class DirectEntityDaoImpl<T extends AbstractEntity>
extends AbstractEntityDaoImpl<T> {
    private final AbstractEntityDaoImpl<T> entityDao;
    private final boolean directQuery;
    private final boolean directUpdate;

    protected DirectEntityDaoImpl(AbstractEntityDaoImpl<T> entityDao, Class<T> clazz, String tenantKey, boolean directQuery, boolean directUpdate) {
        super(clazz, tenantKey);
        this.entityDao = entityDao;
        this.directQuery = directQuery;
        this.directUpdate = directUpdate;
    }

    @Override
    protected String getEntityId(T entity) {
        return this.entityDao.getEntityId(entity);
    }

    @Override
    protected Criteria getCriteria() {
        if (this.directQuery) {
            return new Criteria();
        }
        return this.entityDao.getCriteria();
    }

    @Override
    protected String getDeletedKey() {
        return this.entityDao.getDeletedKey();
    }

    @Override
    protected MongoTemplate getMongoTemplate() {
        return this.entityDao.getMongoTemplate();
    }

    @Override
    protected Query getTenantQuery(Query query) {
        if (this.directQuery) {
            if (query == null) {
                query = new Query();
            }
            return query;
        }
        return this.entityDao.getTenantQuery(query);
    }

    @Override
    protected String getCollectionName() {
        return this.entityDao.getCollectionName();
    }

    @Override
    protected Update setValues(Update update) {
        if (this.directUpdate) {
            return update;
        }
        return this.entityDao.setValues(update);
    }

    @Override
    protected String getCreatedKey() {
        return this.entityDao.getCreatedKey();
    }

    @Override
    protected Object getNow() {
        return this.entityDao.getNow();
    }

    @Override
    protected String getCreatedByKey() {
        return this.entityDao.getCreatedByKey();
    }

    @Override
    protected String getUpdatedKey() {
        return this.entityDao.getUpdatedKey();
    }

    @Override
    protected String getUpdatedByKey() {
        return this.entityDao.getUpdatedByKey();
    }

    @Override
    protected void setEntityId(T entity, String id) {
        this.entityDao.setEntityId(entity, id);
    }
}

