/*
 * Decompiled with CFR 0.152.
 */
package org.swat.csv.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.junit.Test;
import org.swat.csv.utils.CellFormatter;
import org.swat.csv.utils.DateCellFormatter;
import org.swat.csv.utils.XlsWriter;
import org.swat.excel.utils.ExcelUtils;
import org.swat.json.utils.CustomFieldAware;

public class XlsWriterTest
implements CustomFieldAware {
    private String name;
    private Date date;
    private double salary;
    private CellType cellType;
    private final Map<String, Object> customFields = new LinkedHashMap<String, Object>();

    @Test
    public void test() throws Exception {
        XSSFWorkbook workbook = new XSSFWorkbook();
        DateCellFormatter cellFormatter = new DateCellFormatter((Workbook)workbook, "dd/MM/yyyy");
        Sheet sheet = workbook.createSheet("Person");
        XlsWriter xsvWriter = new XlsWriter(XlsWriterTest.class, sheet);
        xsvWriter.setDefaultCellFormatter((CellFormatter)cellFormatter);
        XlsWriterTest test = new XlsWriterTest();
        test.name = "Swat";
        test.putCustomField("myAge", 46);
        test.date = new Date();
        test.salary = 9.223372036854776E18;
        test.cellType = CellType.BOOLEAN;
        xsvWriter.write((Object)test);
        ExcelUtils.autoSizeColumns((Workbook)workbook);
        workbook.write((OutputStream)new FileOutputStream(new File("abc.xlsx")));
    }

    public Map<String, Object> customFields() {
        return this.customFields;
    }

    public String getName() {
        return this.name;
    }

    public Date getDate() {
        return this.date;
    }

    public double getSalary() {
        return this.salary;
    }

    public CellType getCellType() {
        return this.cellType;
    }

    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }
}

