/*
 * Decompiled with CFR 0.152.
 */
package org.swat.csv.utils;

import com.opencsv.CSVWriterBuilder;
import com.opencsv.ICSVWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.Month;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.swat.csv.utils.Period;
import org.swat.csv.utils.XsvWriter;
import org.swat.json.utils.CustomFieldAware;

public class XsvWriterTest
implements CustomFieldAware {
    private String name;
    private Period period;
    private final Map<String, Object> customFields = new LinkedHashMap<String, Object>();

    @Test
    public void test() throws Exception {
        StringWriter writer = new StringWriter();
        ICSVWriter csvWriter = new CSVWriterBuilder((Writer)writer).withQuoteChar('\'').build();
        XsvWriter xsvWriter = new XsvWriter(XsvWriterTest.class, csvWriter, 2);
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(2);
        xsvWriter.addFields(new String[]{"name", "period.from", "period.to"});
        xsvWriter.addHeader("period.from", "Period From");
        xsvWriter.setIncludeCustomFields(true);
        xsvWriter.addFormatter((bean, field, isCustom, value) -> numberFormat.format(value), new String[]{"salary"});
        XsvWriterTest test = new XsvWriterTest();
        test.period = new Period();
        test.period.setFrom(LocalDate.of(2019, Month.NOVEMBER, 1));
        test.period.setTo(LocalDate.of(2019, Month.NOVEMBER, 30));
        test.name = "Swat";
        test.putCustomField("myAge", 46);
        test.putCustomField("salary", 1000);
        xsvWriter.write((Object)test);
        xsvWriter.close();
        Assert.assertEquals((Object)"'Name','Period From','To','My Age','Salary'\n'Swat','2019-11-01','2019-11-30','46','1,000.00'\n", (Object)writer.toString());
    }

    public Map<String, Object> customFields() {
        return this.customFields;
    }

    public String getName() {
        return this.name;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }
}

