/*
 * Copyright © 2018 Gainsight. All rights reserved.
 */

package org.swat.json.utils;

import org.swat.core.utils.CoreRtException;

import java.io.InputStream;
import java.util.List;
import java.util.Map;

public interface JsonUtil {
  <T> T readObject(InputStream jsonStream, Class<T> clazz) throws CoreRtException;

  <T> List<T> readList(InputStream stream, Class<T> clazz) throws CoreRtException;

  <T> List<T> readList(String json, Class<T> clazz) throws CoreRtException;

  <K, V> Map<K, V> readMap(String json, Class<K> keyClass, Class<V> valueClass) throws CoreRtException;

  String toJsonString(Object object) throws CoreRtException;

  <T> T readObject(String json, Class<T> clazz) throws CoreRtException;

  String pretty(Object object) throws CoreRtException;
}
