/*
 * Decompiled with CFR 0.152.
 */
package org.swat.json.utils;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public interface CustomFieldAware {
    @JsonAnyGetter
    @org.codehaus.jackson.annotate.JsonAnyGetter
    default public Map<String, Object> anyGetters() {
        return this.customFields();
    }

    public Map<String, Object> customFields();

    default public boolean addToSet(String name, Object value) {
        if (value == null) {
            return false;
        }
        LinkedHashSet obj = this.customFields().get(name);
        if (!(obj instanceof Collection)) {
            obj = new LinkedHashSet();
            this.customFields().put(name, obj);
        }
        Collection collection = obj;
        return collection.add(value);
    }

    default public void addToList(String name, Object value) {
        if (value == null) {
            return;
        }
        ArrayList obj = this.customFields().get(name);
        if (!(obj instanceof Collection)) {
            obj = new ArrayList();
            this.customFields().put(name, obj);
        }
        Collection collection = obj;
        collection.add(value);
    }

    default public int addAndGet(String key, int delta) {
        Object value = this.customField(key);
        if (!(value instanceof AtomicInteger)) {
            value = new AtomicInteger(0);
            this.putCustomField(key, value);
        }
        return ((AtomicInteger)value).addAndGet(delta);
    }

    default public <T> T customField(String key) {
        return (T)this.customFields().get(key);
    }

    @JsonAnySetter
    @org.codehaus.jackson.annotate.JsonAnySetter
    default public void putCustomField(String name, Object value) {
        this.customFields().put(name, value);
    }
}

