/*
 * Decompiled with CFR 0.152.
 */
package org.swat.json.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;
import org.swat.core.utils.CoreRtException;
import org.swat.json.utils.JsonUtil;

public class JsonUtilCH
implements JsonUtil {
    private final ObjectMapper OBJECT_MAPPER;

    public JsonUtilCH() {
        this(new ObjectMapper());
    }

    public JsonUtilCH(ObjectMapper objectMapper) {
        this.OBJECT_MAPPER = objectMapper;
    }

    @Override
    public <T> T readObject(InputStream jsonStream, Class<T> clazz) throws CoreRtException {
        try {
            return (T)this.OBJECT_MAPPER.readValue(jsonStream, clazz);
        }
        catch (IOException e) {
            throw new CoreRtException((Throwable)e);
        }
    }

    @Override
    public <T> List<T> readList(InputStream stream, Class<T> clazz) throws CoreRtException {
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        CollectionType collectionType = typeFactory.constructCollectionType(ArrayList.class, clazz);
        try {
            return (List)this.OBJECT_MAPPER.readValue(stream, (JavaType)collectionType);
        }
        catch (IOException e) {
            throw new CoreRtException((Throwable)e);
        }
    }

    @Override
    public <T> List<T> readList(String json, Class<T> clazz) throws CoreRtException {
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        CollectionType collectionType = typeFactory.constructCollectionType(ArrayList.class, clazz);
        try {
            return (List)this.OBJECT_MAPPER.readValue(json, (JavaType)collectionType);
        }
        catch (IOException e) {
            throw new CoreRtException((Throwable)e);
        }
    }

    @Override
    public <K, V> Map<K, V> readMap(String json, Class<K> keyClass, Class<V> valueClass) throws CoreRtException {
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        MapType mapType = typeFactory.constructMapType(HashMap.class, keyClass, valueClass);
        try {
            return (Map)this.OBJECT_MAPPER.readValue(json, (JavaType)mapType);
        }
        catch (IOException e) {
            throw new CoreRtException((Throwable)e);
        }
    }

    @Override
    public String toJsonString(Object object) throws CoreRtException {
        try {
            return this.OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new CoreRtException((Throwable)e);
        }
    }

    @Override
    public <T> T readObject(String json, Class<T> clazz) throws CoreRtException {
        try {
            return (T)this.OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new CoreRtException((Throwable)e);
        }
    }

    @Override
    public String pretty(Object object) throws CoreRtException {
        try {
            return this.OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (IOException e) {
            throw new CoreRtException((Throwable)e);
        }
    }
}

