/*
 * Decompiled with CFR 0.152.
 */
package org.swat.json.utils;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.swat.core.utils.CoreInterceptor;
import org.swat.json.utils.JsonConstants;
import org.swat.json.utils.JsonUtil;
import org.swat.json.utils.Person;

public class JsonUtilTest {
    private JsonUtil JSON_SILENT = (JsonUtil)CoreInterceptor.silent((Object)JsonConstants.JSON_UTIL);

    @Test
    public void asObject() throws Exception {
        String json = "{\"name\":\"Agrawal\",\"age\":44}";
        Person person = (Person)this.JSON_SILENT.readObject(json, Person.class);
        Assert.assertNotNull((Object)person);
        Assert.assertEquals((Object)"Agrawal", (Object)person.getName());
        Assert.assertEquals((long)44L, (long)person.getAge());
    }

    @Test
    public void asList() throws Exception {
        String json = "[{\"name\":\"Agrawal\",\"age\":44}]";
        List persons = this.JSON_SILENT.readList(json, Person.class);
        Assert.assertNotNull((Object)persons);
        Person person = (Person)persons.get(0);
        Assert.assertNotNull((Object)person);
        Assert.assertEquals((Object)"Agrawal", (Object)person.getName());
        Assert.assertEquals((long)44L, (long)person.getAge());
    }

    @Test
    public void asMap() throws Exception {
        String json = "{\"person\":{\"name\":\"Agrawal\",\"age\":44}}";
        Map personMap = this.JSON_SILENT.readMap(json, String.class, Person.class);
        Assert.assertNotNull((Object)personMap);
        Person person = (Person)personMap.get("person");
        Assert.assertNotNull((Object)person);
        Assert.assertEquals((Object)"Agrawal", (Object)person.getName());
        Assert.assertEquals((long)44L, (long)person.getAge());
    }

    @Test
    public void anyGetterSetter() {
        Person person = new Person();
        person.setName("Agrawal");
        person.set("Address", "Hyderabad");
        person.setDate(new Date());
        person.setIgnored("Yes");
        String json = this.JSON_SILENT.toJsonString((Object)person);
        Map map = this.JSON_SILENT.readMap(json, String.class, Object.class);
        Assert.assertEquals((Object)"Agrawal", map.get("name"));
        Assert.assertEquals((Object)"Hyderabad", map.get("Address"));
        Assert.assertFalse((boolean)map.containsKey("ignored"));
        person = (Person)this.JSON_SILENT.readObject(json, Person.class);
        Assert.assertNotNull(person.getInfo());
        Assert.assertEquals((Object)"Hyderabad", (Object)person.getInfo().get("Address"));
        Assert.assertNull((Object)person.getIgnored());
    }
}

