/*
 * Decompiled with CFR 0.152.
 */
package org.swat.json.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.swat.core.utils.CoreRtException;
import org.swat.json.utils.JsonUtil;

public class JsonUtilFX
implements JsonUtil {
    private final ObjectMapper OBJECT_MAPPER;

    public JsonUtilFX() {
        this.OBJECT_MAPPER = new ObjectMapper();
    }

    public JsonUtilFX(ObjectMapper objectMapper) {
        this.OBJECT_MAPPER = objectMapper.copy();
    }

    public JsonUtilFX configure(SerializationFeature serializationFeature, boolean state) {
        JsonUtilFX jsonUtil = new JsonUtilFX(this.OBJECT_MAPPER);
        jsonUtil.OBJECT_MAPPER.configure(serializationFeature, state);
        return jsonUtil;
    }

    public JsonUtilFX setSerializationInclusion(JsonInclude.Include inclusion) {
        JsonUtilFX jsonUtil = new JsonUtilFX(this.OBJECT_MAPPER);
        jsonUtil.OBJECT_MAPPER.setSerializationInclusion(inclusion);
        return jsonUtil;
    }

    public JsonUtil registerModules(Module ... modules) {
        JsonUtilFX jsonUtil = new JsonUtilFX(this.OBJECT_MAPPER);
        jsonUtil.OBJECT_MAPPER.registerModules(modules);
        return jsonUtil;
    }

    @Override
    public <T> T readObject(InputStream jsonStream, Class<T> clazz) throws CoreRtException {
        try {
            return (T)this.OBJECT_MAPPER.readValue(jsonStream, clazz);
        }
        catch (IOException e) {
            throw new CoreRtException((Throwable)e);
        }
    }

    @Override
    public <T> List<T> readList(InputStream stream, Class<T> clazz) throws CoreRtException {
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        CollectionType collectionType = typeFactory.constructCollectionType(ArrayList.class, clazz);
        try {
            return (List)this.OBJECT_MAPPER.readValue(stream, (JavaType)collectionType);
        }
        catch (IOException e) {
            throw new CoreRtException((Throwable)e);
        }
    }

    public ObjectMapper getOBJECT_MAPPER() {
        return this.OBJECT_MAPPER.copy();
    }

    @Override
    public <T> List<T> readList(String json, Class<T> clazz) throws CoreRtException {
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        CollectionType collectionType = typeFactory.constructCollectionType(ArrayList.class, clazz);
        try {
            return (List)this.OBJECT_MAPPER.readValue(json, (JavaType)collectionType);
        }
        catch (IOException e) {
            throw new CoreRtException((Throwable)e);
        }
    }

    @Override
    public <K, V> Map<K, V> readMap(String json, Class<K> keyClass, Class<V> valueClass) throws CoreRtException {
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        MapType mapType = typeFactory.constructMapType(HashMap.class, keyClass, valueClass);
        try {
            return (Map)this.OBJECT_MAPPER.readValue(json, (JavaType)mapType);
        }
        catch (IOException e) {
            throw new CoreRtException((Throwable)e);
        }
    }

    @Override
    public String toJsonString(Object object) throws CoreRtException {
        try {
            return this.OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new CoreRtException((Throwable)e);
        }
    }

    @Override
    public <T> T readObject(String json, Class<T> clazz) throws CoreRtException {
        try {
            return (T)this.OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new CoreRtException((Throwable)e);
        }
    }

    @Override
    public String pretty(Object object) throws CoreRtException {
        try {
            return this.OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new CoreRtException((Throwable)e);
        }
    }
}

