/*
 * Decompiled with CFR 0.152.
 */
package org.swat.json.utils;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;
import org.swat.json.utils.CustomPojo;
import org.swat.json.utils.CustomPojoSkip;

public class CustomFieldsTest {
    @Test
    public void checkSuccess() throws Exception {
        String json = "{'color':'RED'}";
        json = json.replace('\'', '\"');
        ObjectMapper mapper = new ObjectMapper();
        CustomPojo pojo = (CustomPojo)((Object)mapper.readValue(json, CustomPojo.class));
        Assert.assertEquals((Object)"RED", (Object)pojo.customField("color"));
        json = mapper.writeValueAsString((Object)pojo);
        json = json.replace('\"', '\'');
        Assert.assertEquals((Object)"{'color':'RED'}", (Object)json);
    }

    @Test(expected=JsonMappingException.class)
    public void serializeFailure() throws Exception {
        String json = "{'colour':'RED'}";
        json = json.replace('\'', '\"');
        ObjectMapper mapper = new ObjectMapper();
        mapper.readValue(json, CustomPojo.class);
    }

    @Test(expected=JsonMappingException.class)
    public void deserializeFailure() throws Exception {
        CustomPojo pojo = new CustomPojo();
        pojo.customFields().put("colour", "BLUE");
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValueAsString((Object)pojo);
    }

    @Test
    public void serializeSkip() throws Exception {
        String json = "{'colour':'BLUE', 'color':'RED'}";
        json = json.replace('\'', '\"');
        ObjectMapper mapper = new ObjectMapper();
        CustomPojoSkip pojo = (CustomPojoSkip)((Object)mapper.readValue(json, CustomPojoSkip.class));
        Assert.assertNull((Object)pojo.customField("colour"));
        Assert.assertEquals((Object)"RED", (Object)pojo.customField("color"));
    }

    @Test
    public void deserializeSkip() throws Exception {
        CustomPojoSkip pojo = new CustomPojoSkip();
        pojo.customFields().put("colour", "BLUE");
        pojo.customFields().put("color", "RED");
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString((Object)pojo);
        json = json.replace('\"', '\'');
        Assert.assertEquals((Object)"{'color':'RED'}", (Object)json);
    }

    @Test
    public void addToSet() throws Exception {
        CustomPojoSkip pojo = new CustomPojoSkip();
        String key = "key";
        pojo.addToSet(key, "one");
        Assert.assertNull((Object)pojo.customField(key));
    }
}

