/*
 * Decompiled with CFR 0.152.
 */
package org.swat.json.utils;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.jackson.annotate.JsonAnySetter;
import org.swat.core.utils.CoreRtException;
import org.swat.core.utils.ObjectUtil;

public interface CustomFieldAware {
    @JsonAnyGetter
    @org.codehaus.jackson.annotate.JsonAnyGetter
    default public Map<String, Object> anyGetters() {
        Map<String, Object> customFields = this.customFields();
        for (String key : new HashSet<String>(customFields.keySet())) {
            if (this.isValid(key)) continue;
            customFields.remove(key);
        }
        return customFields;
    }

    public Map<String, Object> customFields();

    default public boolean addToSet(String key, Object value) {
        if (!this.isValid(key) || value == null) {
            return false;
        }
        LinkedHashSet obj = this.customFields().get(key);
        if (!(obj instanceof Collection)) {
            obj = new LinkedHashSet();
            this.customFields().put(key, obj);
        }
        Collection collection = (Collection)ObjectUtil.cast((Object)obj);
        return collection.add(value);
    }

    default public void addToList(String key, Object value) {
        if (!this.isValid(key) || value == null) {
            return;
        }
        ArrayList obj = this.customFields().get(key);
        if (!(obj instanceof Collection)) {
            obj = new ArrayList();
            this.customFields().put(key, obj);
        }
        Collection collection = (Collection)ObjectUtil.cast((Object)obj);
        collection.add(value);
    }

    default public int addAndGet(String key, int delta) {
        if (!this.isValid(key)) {
            return 0;
        }
        Object value = this.customField(key);
        if (!(value instanceof AtomicInteger)) {
            value = new AtomicInteger(0);
            this.putCustomField(key, value);
        }
        return ((AtomicInteger)value).addAndGet(delta);
    }

    default public <T> T customField(String key) {
        if (this.isValid(key)) {
            return (T)ObjectUtil.cast((Object)this.customFields().get(key));
        }
        return null;
    }

    @com.fasterxml.jackson.annotation.JsonAnySetter
    @JsonAnySetter
    default public void putCustomField(String key, Object value) {
        if (this.isValid(key)) {
            this.customFields().put(key, value);
        }
    }

    default public boolean isValid(String key) {
        if (this.supportedKeys() != null && !this.supportedKeys().contains(key)) {
            throw new CoreRtException(key + " is not supported.");
        }
        return true;
    }

    default public Set<String> supportedKeys() {
        return null;
    }
}

