/*
 * Decompiled with CFR 0.152.
 */
package org.swat.spring;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RestController;
import org.swat.spring.IgnoredInstance;

public class SingletonVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingletonVerifier.class);
    private final String[] basePackages;
    private final Comparator<Field> CLASS_THEN_NAME = new Comparator<Field>(){

        @Override
        public int compare(Field dis, Field dat) {
            int status = dis.getDeclaringClass().getName().compareTo(dat.getDeclaringClass().getName());
            if (status != 0) {
                return status;
            }
            return dis.getName().compareTo(dat.getName());
        }
    };

    public SingletonVerifier(String ... basePackages) {
        this.basePackages = basePackages;
    }

    protected Collection<Class<? extends Annotation>> getAnnotations() {
        return new ArrayList<Class<? extends Annotation>>(Arrays.asList(Component.class, Controller.class, Repository.class, Service.class, RestController.class));
    }

    public void failOnInstanceFields() {
        Set<Field> instanceFields = this.getInstanceFields();
        if (!instanceFields.isEmpty()) {
            System.out.println("=============================");
            System.out.println("Instance level fields are defined in a Singleton Object");
            int counter = 0;
            for (Field field : instanceFields) {
                System.out.println(++counter + "\t" + field);
            }
            System.out.println("=============================");
            System.out.println("Instance variables found in Singleton Objects. Check above logs.");
        }
        assert (instanceFields.isEmpty());
    }

    public Set<Field> getInstanceFields() {
        TreeSet<Field> instanceFields = new TreeSet<Field>(this.CLASS_THEN_NAME);
        HashSet services = new HashSet();
        for (Class<? extends Annotation> clazz : this.getAnnotations()) {
            for (String basePackage : this.basePackages) {
                services.addAll(new Reflections(basePackage, new Scanner[0]).getTypesAnnotatedWith(clazz));
            }
        }
        for (Class<Annotation> service : services) {
            instanceFields.addAll(this.getInstanceFields(service));
        }
        return instanceFields;
    }

    public static boolean isTestClass(Class<?> service) {
        File file = new File(".");
        String fileName = service.getName();
        return SingletonVerifier.isTestClass(file, fileName, 2);
    }

    public static boolean isTestClass(File folder, String fileName, int depth) {
        if (depth < 0) {
            return false;
        }
        if (!folder.isDirectory()) {
            return false;
        }
        if (new File(folder, fileName).exists()) {
            return true;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            return false;
        }
        for (File file : files) {
            if (!SingletonVerifier.isTestClass(file, fileName, depth - 1)) continue;
            return true;
        }
        return false;
    }

    public static void populateFields(Class<?> clazz, Set<Field> fields) {
        if (clazz == null || clazz == Object.class) {
            return;
        }
        Field[] declaredFields = clazz.getDeclaredFields();
        if (declaredFields != null) {
            Collections.addAll(fields, declaredFields);
        }
        SingletonVerifier.populateFields(clazz.getSuperclass(), fields);
    }

    public static boolean isServiceInterface(String[] basePackages, Class<?> type) {
        if (SingletonVerifier.isTestClass(type)) {
            return true;
        }
        HashSet allSubTypes = new HashSet();
        for (String basePackage : basePackages) {
            Set subTypes = new Reflections(basePackage, new Scanner[0]).getSubTypesOf(type);
            if (subTypes == null) continue;
            allSubTypes.addAll(subTypes);
        }
        Iterator iterator = allSubTypes.iterator();
        while (iterator.hasNext()) {
            if (!SingletonVerifier.isTestClass((Class)iterator.next())) continue;
            iterator.remove();
        }
        return allSubTypes.size() == 1;
    }

    public Set<Field> getInstanceFields(Class<?> service) {
        TreeSet<Field> instanceFields = new TreeSet<Field>(this.CLASS_THEN_NAME);
        try {
            if (SingletonVerifier.isTestClass(service)) {
                return instanceFields;
            }
            Scope scope = service.getAnnotation(Scope.class);
            if (scope != null && !scope.scopeName().equalsIgnoreCase("singleton")) {
                return instanceFields;
            }
            HashSet<Field> allFields = new HashSet<Field>();
            SingletonVerifier.populateFields(service, allFields);
            for (Field field : allFields) {
                if (Modifier.isFinal(field.getModifiers()) || field.isAnnotationPresent(IgnoredInstance.class) || field.isAnnotationPresent(Autowired.class) || field.isAnnotationPresent(Value.class) || SingletonVerifier.isServiceInterface(this.basePackages, field.getType()) || this.isJacocoField(field) || !this.isInstance(field)) continue;
                instanceFields.add(field);
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Exception in service class[{}] - {}", service, (Object)e.getMessage());
        }
        return instanceFields;
    }

    private boolean isJacocoField(Field field) {
        int modifiers = field.getModifiers();
        if (!Modifier.isStatic(modifiers)) {
            return false;
        }
        if (!Modifier.isTransient(modifiers)) {
            return false;
        }
        if (!Modifier.isPrivate(modifiers)) {
            return false;
        }
        if (!field.getName().equalsIgnoreCase("$jacocoData")) {
            return false;
        }
        return field.getType() == boolean[].class;
    }

    protected boolean isInstance(Field field) {
        return true;
    }
}

