/*
 * Decompiled with CFR 0.152.
 */
package org.swat.spring.context;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.swat.context.utils.ContextAware;
import org.swat.spring.context.ServletInfo;

public class ServletContext
extends ContextAware {
    private static final ThreadLocal<ServletInfo> CONTEXT = new ThreadLocal();

    public void remove() {
        CONTEXT.remove();
    }

    public static void setContext(ServletInfo servletInfo) {
        CONTEXT.set(servletInfo);
    }

    public static ServletInfo context() {
        ServletInfo info = CONTEXT.get();
        if (info == null) {
            info = new ServletInfo();
            ServletContext.setContext(info);
        }
        return info;
    }

    public static String getParameter(String key) {
        String[] values = ServletContext.context().getParams().get(key);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public static String getValue(String key) {
        List<String> values = ServletContext.getValues(key);
        if (values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public static List<String> getValues(String key) {
        String[] values = ServletContext.context().getParams().get(key);
        if (values == null || values.length == 0) {
            Object value = ServletContext.getAttribute(key);
            if (value instanceof String) {
                values = new String[]{(String)value};
            } else if (value instanceof String[]) {
                values = (String[])value;
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        if (values != null) {
            for (String value : values) {
                list.add(StringUtils.trim((String)value));
            }
        }
        return list;
    }

    public static void setAttribute(String key, Object value) {
        ServletContext.context().getAttributes().put(key, value);
    }

    public static Object getAttribute(String key) {
        return ServletContext.context().getAttributes().get(key);
    }

    static {
        ServletContext.register((ContextAware)new ServletContext());
    }
}

