/*
 * Decompiled with CFR 0.152.
 */
package org.swat.spring.mvc.interceptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.swat.spring.mvc.base.AuthType;
import org.swat.spring.mvc.base.Auths;
import org.swat.spring.mvc.interceptor.MethodInfo;

public class BaseInterceptor
implements HandlerInterceptor {
    private static final Map<String, MethodInfo> interceptorMap = new ConcurrentHashMap<String, MethodInfo>(10);

    public final boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws Exception {
        HandlerMethod handlerMethod;
        MethodInfo methodInfo;
        if (object instanceof HandlerMethod && (methodInfo = this.getInterceptorClasses(handlerMethod = (HandlerMethod)object)) != null && methodInfo.contains(this.getClass())) {
            return this.doPreHandle(httpServletRequest, httpServletResponse, object, methodInfo.getAuths());
        }
        return true;
    }

    public final void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, ModelAndView modelAndView) {
        HandlerMethod handlerMethod;
        MethodInfo methodInfo;
        if (object instanceof HandlerMethod && (methodInfo = interceptorMap.get(this.getKey(handlerMethod = (HandlerMethod)object))) != null && methodInfo.contains(this.getClass())) {
            this.doPostHandle(httpServletRequest, httpServletResponse, object, modelAndView, methodInfo.getAuths());
        }
    }

    public final void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, Exception e) throws Exception {
        HandlerMethod handlerMethod;
        MethodInfo methodInfo;
        if (object instanceof HandlerMethod && (methodInfo = interceptorMap.get(this.getKey(handlerMethod = (HandlerMethod)object))) != null && methodInfo.contains(this.getClass())) {
            this.doAfterCompletion(httpServletRequest, httpServletResponse, object, e, methodInfo.getAuths());
        }
    }

    public void doAfterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, Exception e, Auths auths) throws Exception {
    }

    private String getKey(HandlerMethod handlerMethod) {
        Class beanType = handlerMethod.getBeanType();
        Method method = handlerMethod.getMethod();
        return beanType + " - " + method;
    }

    public void doPostHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, ModelAndView modelAndView, Auths auths) {
    }

    public boolean doPreHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, Auths auths) throws Exception {
        return true;
    }

    protected MethodInfo getInterceptorClasses(HandlerMethod handlerMethod) {
        String key = this.getKey(handlerMethod);
        MethodInfo methodInfo = interceptorMap.get(key);
        if (methodInfo == null) {
            Method method = handlerMethod.getMethod();
            Auths auths = method.getAnnotation(Auths.class);
            if (auths == null) {
                auths = this.getAnnotation(handlerMethod.getBeanType(), Auths.class);
            }
            methodInfo = new MethodInfo(auths);
            this.addDefaultInterceptors(methodInfo);
            if (auths != null) {
                for (AuthType authType : auths.auths()) {
                    methodInfo.addClasses(authType.getInterceptors());
                }
                this.addConditionalInterceptors(methodInfo, auths);
            }
            interceptorMap.put(key, methodInfo);
        }
        return methodInfo;
    }

    protected void addDefaultInterceptors(MethodInfo methodInfo) {
    }

    protected void addConditionalInterceptors(MethodInfo methodInfo, Auths auths) {
    }

    private <A extends Annotation> A getAnnotation(Class clazz, Class<A> annClazz) {
        if (clazz == null || clazz == Object.class || annClazz == null) {
            return null;
        }
        A a = clazz.getAnnotation(annClazz);
        if (a == null) {
            return this.getAnnotation(clazz.getSuperclass(), annClazz);
        }
        return a;
    }
}

