/*
 * Decompiled with CFR 0.152.
 */
package org.bitstrings.test.junit.runner;

import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.bitstrings.test.junit.runner.ClptrExclude;
import org.bitstrings.test.junit.runner.NamedRunner;
import org.bitstrings.test.junit.runner.TestClassLoader;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.internal.runners.statements.Fail;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class ClassLoaderPerTestRunner
extends NamedRunner {
    private static final Logger LOG = Logger.getLogger(ClassLoaderPerTestRunner.class.getName());
    private String classPath;
    private boolean classPathDetermined = false;
    private TestClass testClassFromClassLoader;
    private Object beforeFromClassLoader;
    private Object afterFromClassLoader;
    private Object ruleFromClassLoader;
    private ClassLoader originalCl = Thread.currentThread().getContextClassLoader();

    public ClassLoaderPerTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected synchronized Object createTest() throws Exception {
        return this.testClassFromClassLoader.getJavaClass().newInstance();
    }

    private void loadClassesWithCustomClassLoader(FrameworkMethod method) throws ClassNotFoundException {
        String testPath = this.getClassPath();
        TestClassLoader classLoader = testPath == null ? new TestClassLoader() : new TestClassLoader(testPath);
        ClptrExclude clptrExclude = (ClptrExclude)this.getTestClass().getAnnotation(ClptrExclude.class);
        if (clptrExclude != null) {
            classLoader.addExcludes(clptrExclude.value());
        }
        if ((clptrExclude = (ClptrExclude)method.getAnnotation(ClptrExclude.class)) != null) {
            classLoader.addExcludes(clptrExclude.value());
        }
        Thread.currentThread().setContextClassLoader(classLoader);
        this.testClassFromClassLoader = new TestClass(classLoader.loadClass(this.getTestClass().getJavaClass().getName()));
        this.beforeFromClassLoader = classLoader.loadClass(Before.class.getName());
        this.afterFromClassLoader = classLoader.loadClass(After.class.getName());
        this.ruleFromClassLoader = classLoader.loadClass(Rule.class.getName());
    }

    protected synchronized Statement methodBlock(FrameworkMethod method) {
        FrameworkMethod newMethod = null;
        try {
            this.loadClassesWithCustomClassLoader(method);
            newMethod = new FrameworkMethod(this.testClassFromClassLoader.getJavaClass().getMethod(method.getName(), new Class[0]));
        }
        catch (Exception e) {
            return new Fail((Throwable)e);
        }
        return super.methodBlock(newMethod);
    }

    protected synchronized Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        List afters = this.testClassFromClassLoader.getAnnotatedMethods((Class)this.afterFromClassLoader);
        return new RunAfters(statement, afters, target);
    }

    protected synchronized Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        List befores = this.testClassFromClassLoader.getAnnotatedMethods((Class)this.beforeFromClassLoader);
        return new RunBefores(statement, befores, target);
    }

    protected synchronized List<TestRule> getTestRules(Object target) {
        List result = this.testClassFromClassLoader.getAnnotatedMethodValues(target, (Class)this.ruleFromClassLoader, TestRule.class);
        result.addAll(this.testClassFromClassLoader.getAnnotatedFieldValues(target, (Class)this.ruleFromClassLoader, TestRule.class));
        return result;
    }

    protected synchronized List<MethodRule> rules(Object target) {
        List rules = this.testClassFromClassLoader.getAnnotatedMethodValues(target, (Class)this.ruleFromClassLoader, MethodRule.class);
        rules.addAll(this.testClassFromClassLoader.getAnnotatedFieldValues(target, (Class)this.ruleFromClassLoader, MethodRule.class));
        return rules;
    }

    private String getClassPath() {
        if (this.classPathDetermined) {
            return this.classPath;
        }
        this.classPathDetermined = true;
        this.classPath = System.getProperty("surefire.test.class.path");
        if (this.classPath != null) {
            return this.classPath;
        }
        String booterClassPath = System.getProperty("java.class.path");
        Vector<String> pathItems = null;
        if (booterClassPath != null) {
            pathItems = ClassLoaderPerTestRunner.scanPath(booterClassPath);
        }
        if (pathItems != null && pathItems.size() == 1 && ClassLoaderPerTestRunner.isJar(pathItems.get(0))) {
            this.classPath = ClassLoaderPerTestRunner.loadJarManifestClassPath(pathItems.get(0), "META-INF/MANIFEST.MF");
        }
        return this.classPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadJarManifestClassPath(String path, String fileName) {
        File archive = new File(path);
        if (!archive.exists()) {
            return null;
        }
        try (ZipFile zipFile = new ZipFile(archive);){
            ZipEntry entry = zipFile.getEntry(fileName);
            if (entry == null) {
                String string2 = null;
                return string2;
            }
            Manifest mf = new Manifest();
            mf.read(zipFile.getInputStream(entry));
            String string = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH).replaceAll(" ", System.getProperty("path.separator")).replaceAll("file:/", "");
            return string;
        }
        catch (Exception e) {
            LOG.throwing("ClassLoaderTestSuite", "loadJarManifestClassPath", e);
            return null;
        }
    }

    private static boolean isJar(String pathEntry) {
        return pathEntry.endsWith(".jar") || pathEntry.endsWith(".zip");
    }

    private static Vector<String> scanPath(String classPath) {
        String separator = System.getProperty("path.separator");
        Vector<String> pathItems = new Vector<String>(10);
        StringTokenizer st = new StringTokenizer(classPath, separator);
        while (st.hasMoreTokens()) {
            pathItems.addElement(st.nextToken());
        }
        return pathItems;
    }

    @Override
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        super.runChild(method, notifier);
        Thread.currentThread().setContextClassLoader(this.originalCl);
    }
}

