/*
 * Decompiled with CFR 0.152.
 */
package org.bitstrings.test.junit.runner;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class TestClassLoader
extends ClassLoader {
    private final List<String> fPathItems = new ArrayList<String>();
    private static final String EXCLUDED_FILE = "clptr-excludes.properties";
    private final List<String> fExcluded = new ArrayList<String>();
    public static final String SYSTEM_PROP_BASE_NAME = TestClassLoader.class.getName();
    public static final String SYSTEM_PROP_EXCLUDES_NAME = SYSTEM_PROP_BASE_NAME + ".excludes";

    public TestClassLoader() {
        this(System.getProperty("java.class.path"));
    }

    public TestClassLoader(String classPath) {
        this.scanPath(classPath);
        this.readInternalExcludes();
        this.readUserExcludes();
    }

    private void scanPath(String classPath) {
        StringTokenizer st = new StringTokenizer(classPath, System.getProperty("path.separator"));
        while (st.hasMoreTokens()) {
            this.fPathItems.add(st.nextToken());
        }
    }

    @Override
    public URL getResource(String name) {
        return ClassLoader.getSystemResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return ClassLoader.getSystemResourceAsStream(name);
    }

    public boolean isExcluded(String name) {
        for (String excluded : this.fExcluded) {
            if (!name.startsWith(excluded)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (this.isExcluded(name)) {
            try {
                c = this.findSystemClass(name);
                return c;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (c == null) {
            byte[] data = this.lookupClassData(name);
            if (data == null) {
                throw new ClassNotFoundException();
            }
            c = this.defineClass(name, data, 0, data.length);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private byte[] lookupClassData(String className) throws ClassNotFoundException {
        byte[] data = null;
        for (int i = 0; i < this.fPathItems.size(); ++i) {
            String path = this.fPathItems.get(i);
            String fileName = className.replace('.', '/') + ".class";
            data = this.isJar(path) ? this.loadJarData(path, fileName) : this.loadFileData(path, fileName);
            if (data == null) continue;
            return data;
        }
        throw new ClassNotFoundException(className);
    }

    boolean isJar(String pathEntry) {
        return pathEntry.endsWith(".jar") || pathEntry.endsWith(".zip");
    }

    private byte[] loadFileData(String path, String fileName) {
        File file = new File(path, fileName);
        if (file.exists()) {
            return this.getClassData(file);
        }
        return null;
    }

    private byte[] getClassData(File f) {
        try {
            int n;
            FileInputStream stream = new FileInputStream(f);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = stream.read(b)) != -1) {
                out.write(b, 0, n);
            }
            stream.close();
            out.close();
            return out.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] loadJarData(String path, String fileName) {
        InputStream stream = null;
        File archive = new File(path);
        if (!archive.exists()) {
            return null;
        }
        try (ZipFile zipFile = new ZipFile(archive);){
            int n;
            ZipEntry entry = zipFile.getEntry(fileName);
            if (entry == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            int size = (int)entry.getSize();
            stream = zipFile.getInputStream(entry);
            byte[] data = new byte[size];
            for (int pos = 0; pos < size; pos += n) {
                n = stream.read(data, pos, data.length - pos);
            }
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void addExclude(String name) {
        this.fExcluded.add(name.replace("*", ""));
    }

    public void addExcludes(String ... names) {
        for (String name : names) {
            this.addExclude(name);
        }
    }

    private void readInternalExcludes() {
        this.readExcludes(this.getClass().getResource(EXCLUDED_FILE));
    }

    private void readUserExcludes() {
        String excludesPath = System.getProperty(SYSTEM_PROP_EXCLUDES_NAME);
        if (excludesPath == null) {
            excludesPath = EXCLUDED_FILE;
        }
        this.readExcludes(Thread.currentThread().getContextClassLoader().getResource(excludesPath));
    }

    private void readExcludes(URL excludesUrl) {
        if (excludesUrl == null) {
            return;
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader(excludesUrl.openStream()));){
            while (in.ready()) {
                this.addExclude(in.readLine());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

