/*
 * Decompiled with CFR 0.152.
 */
package org.blocks4j.commons.classpath;

import java.io.InputStream;
import java.net.URI;
import org.blocks4j.commons.classpath.RegExp;

public class ClasspathResource {
    public static InputStream asStream(String arg) {
        URI uri = URI.create(arg);
        if (null == uri) {
            return null;
        }
        InputStream is = null;
        try {
            String name = RegExp.withoutSchemeAndParameters(uri);
            is = ClasspathResource.classLoader(name);
            if (null == is) {
                is = ClasspathResource.currentThread(name);
                if (null == is) {
                    is = ClasspathResource.newClass(name);
                }
                if (null == is) {
                    is = ClasspathResource.classLoader("/" + name);
                }
                if (null == is) {
                    is = ClasspathResource.currentThread("/" + name);
                }
                if (null == is) {
                    is = ClasspathResource.newClass("/" + name);
                }
                if (null == is) {
                    return null;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return is;
    }

    private static InputStream classLoader(String arg) {
        return ClassLoader.getSystemResourceAsStream(arg);
    }

    private static InputStream currentThread(String arg) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(arg);
    }

    private static InputStream newClass(String arg) {
        return Class.class.getResourceAsStream(arg);
    }
}

